/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.application.options.ImportSchemeChooserDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.codeStyleMapping.EclipseCodeStyleMappingDefinitionKt;
import org.jetbrains.idea.eclipse.codeStyleMapping.util.MappingDefinition;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileElements;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ2\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter;", "Lcom/intellij/openapi/options/SchemeImporter;", "Lcom/intellij/psi/codeStyle/CodeStyleScheme;", "Lorg/jetbrains/idea/eclipse/importer/EclipseXmlProfileElements;", "<init>", "()V", "getSourceExtensions", "", "", "()[Ljava/lang/String;", "importScheme", "project", "Lcom/intellij/openapi/project/Project;", "selectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentScheme", "schemeFactory", "Lcom/intellij/openapi/options/SchemeFactory;", "Companion", "intellij.eclipse"})
@SourceDebugExtension(value={"SMAP\nEclipseCodeStyleSchemeImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EclipseCodeStyleSchemeImporter.kt\norg/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n14#2:128\n*S KotlinDebug\n*F\n+ 1 EclipseCodeStyleSchemeImporter.kt\norg/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter\n*L\n36#1:128\n*E\n"})
public final class EclipseCodeStyleSchemeImporter
implements SchemeImporter<CodeStyleScheme>,
EclipseXmlProfileElements {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public String[] getSourceExtensions() {
        String[] stringArray = new String[]{"xml"};
        return stringArray;
    }

    @Nullable
    public CodeStyleScheme importScheme(@NotNull Project project, @NotNull VirtualFile selectedFile, @NotNull CodeStyleScheme currentScheme, @NotNull SchemeFactory<? extends CodeStyleScheme> schemeFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedFile, (String)"selectedFile");
        Intrinsics.checkNotNullParameter((Object)currentScheme, (String)"currentScheme");
        Intrinsics.checkNotNullParameter(schemeFactory, (String)"schemeFactory");
        String[] stringArray = Companion.readEclipseXmlProfileNames(selectedFile);
        Pair pair = ImportSchemeChooserDialog.selectOrCreateTargetScheme((Project)project, (CodeStyleScheme)currentScheme, schemeFactory, (String[])Arrays.copyOf(stringArray, stringArray.length));
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        String selectedName = (String)ExtensionsKt.component1((Pair)pair2);
        CodeStyleScheme selectedScheme = (CodeStyleScheme)ExtensionsKt.component2((Pair)pair2);
        CodeStyleSettings codeStyleSettings = selectedScheme.getCodeStyleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
        Companion.importCodeStyleSettings(selectedFile, selectedName, codeStyleSettings);
        return selectedScheme;
    }

    @JvmStatic
    public static final void importCodeStyleSettings(@NotNull Map<String, String> external, @NotNull CodeStyleSettings codeStyleSettings) throws SchemeImportException {
        Companion.importCodeStyleSettings(external, codeStyleSettings);
    }

    @JvmStatic
    public static final void importCodeStyleSettings(@NotNull VirtualFile file, @Nullable String profileName, @NotNull CodeStyleSettings codeStyleSettings) throws SchemeImportException {
        Companion.importCodeStyleSettings(file, profileName, codeStyleSettings);
    }

    @JvmStatic
    @NotNull
    public static final String[] readEclipseXmlProfileNames(@NotNull VirtualFile $this$readEclipseXmlProfileNames) throws SchemeImportException {
        return Companion.readEclipseXmlProfileNames($this$readEclipseXmlProfileNames);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> readEclipseXmlProfileOptions(@NotNull VirtualFile $this$readEclipseXmlProfileOptions, @Nullable String selectedProfileName) throws SchemeImportException {
        return Companion.readEclipseXmlProfileOptions($this$readEclipseXmlProfileOptions, selectedProfileName);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> readEclipseXmlProfileOptions(@NotNull InputStream $this$readEclipseXmlProfileOptions, @Nullable String selectedProfileName) throws SchemeImportException {
        return Companion.readEclipseXmlProfileOptions($this$readEclipseXmlProfileOptions, selectedProfileName);
    }

    @JvmStatic
    public static final void readEclipseXmlProfile(@NotNull VirtualFile $this$readEclipseXmlProfile, @NotNull EclipseXmlProfileReader.OptionHandler handler) throws SchemeImportException {
        Companion.readEclipseXmlProfile($this$readEclipseXmlProfile, handler);
    }

    @JvmStatic
    public static final void readEclipseXmlProfile(@NotNull InputStream $this$readEclipseXmlProfile, @NotNull EclipseXmlProfileReader.OptionHandler handler) throws SchemeImportException {
        Companion.readEclipseXmlProfile($this$readEclipseXmlProfile, handler);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EclipseCodeStyleSchemeImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013*\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00172\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0011\u0010\u001b\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001c*\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "importCodeStyleSettings", "", "external", "", "", "codeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "profileName", "readEclipseXmlProfileNames", "", "(Lcom/intellij/openapi/vfs/VirtualFile;)[Ljava/lang/String;", "readEclipseXmlProfileOptions", "selectedProfileName", "Ljava/io/InputStream;", "readEclipseXmlProfile", "handler", "Lorg/jetbrains/idea/eclipse/importer/EclipseXmlProfileReader$OptionHandler;", "getInputStreamAndWrapIOException", "Lorg/jetbrains/annotations/NotNull;", "intellij.eclipse"})
    @SourceDebugExtension(value={"SMAP\nEclipseCodeStyleSchemeImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EclipseCodeStyleSchemeImporter.kt\norg/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1863#2,2:128\n37#3,2:130\n1#4:132\n*S KotlinDebug\n*F\n+ 1 EclipseCodeStyleSchemeImporter.kt\norg/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$Companion\n*L\n44#1:128,2\n74#1:130,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        public final void importCodeStyleSettings(@NotNull Map<String, String> external, @NotNull CodeStyleSettings codeStyleSettings) throws SchemeImportException {
            Intrinsics.checkNotNullParameter(external, (String)"external");
            Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
            MappingDefinition mapping = EclipseCodeStyleMappingDefinitionKt.buildEclipseCodeStyleMappingTo(codeStyleSettings);
            List<String> importProblems = mapping.importSettings(external);
            if (!((Collection)importProblems).isEmpty()) {
                Iterable $this$forEach$iv = importProblems;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Companion.getLOG().info("Unexpected value in Eclipse XML profile: " + it);
                }
                Object[] objectArray = new Object[]{importProblems.size()};
                String string = EclipseBundle.message("eclipse.xml.profile.import.unexpected.values", objectArray);
                Iterable iterable = importProblems;
                CharSequence charSequence = "\n";
                Object[] objectArray2 = new Object[]{importProblems.size() - 5};
                String string2 = EclipseBundle.message("eclipse.xml.profile.import.unexpected.values.and.x.more", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                throw new SchemeImportException(string + "\n" + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, null, null, (int)5, (CharSequence)string2, null, (int)38, null) + "\n" + EclipseBundle.message("eclipse.xml.profile.import.unexpected.values.see.logs", new Object[0]));
            }
        }

        @JvmStatic
        public final void importCodeStyleSettings(@NotNull VirtualFile file, @Nullable String profileName, @NotNull CodeStyleSettings codeStyleSettings) throws SchemeImportException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
            Map<String, String> external = this.readEclipseXmlProfileOptions(file, profileName);
            this.importCodeStyleSettings(external, codeStyleSettings);
        }

        @JvmStatic
        @NotNull
        public final String[] readEclipseXmlProfileNames(@NotNull VirtualFile $this$readEclipseXmlProfileNames) throws SchemeImportException {
            Intrinsics.checkNotNullParameter((Object)$this$readEclipseXmlProfileNames, (String)"<this>");
            Set names = new LinkedHashSet();
            this.readEclipseXmlProfile($this$readEclipseXmlProfileNames, new EclipseXmlProfileReader.OptionHandler(names){
                final /* synthetic */ Set<String> $names;
                {
                    this.$names = $names;
                }

                public void handleOption(String eclipseKey, String value) {
                    Intrinsics.checkNotNullParameter((Object)eclipseKey, (String)"eclipseKey");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                }

                public void handleName(String name) {
                    if (name != null) {
                        this.$names.add(name);
                    }
                }
            });
            Collection $this$toTypedArray$iv = names;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> readEclipseXmlProfileOptions(@NotNull VirtualFile $this$readEclipseXmlProfileOptions, @Nullable String selectedProfileName) throws SchemeImportException {
            Intrinsics.checkNotNullParameter((Object)$this$readEclipseXmlProfileOptions, (String)"<this>");
            return this.readEclipseXmlProfileOptions(this.getInputStreamAndWrapIOException($this$readEclipseXmlProfileOptions), selectedProfileName);
        }

        public static /* synthetic */ Map readEclipseXmlProfileOptions$default(Companion companion, VirtualFile virtualFile, String string, int n, Object object) throws SchemeImportException {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.readEclipseXmlProfileOptions(virtualFile, string);
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> readEclipseXmlProfileOptions(@NotNull InputStream $this$readEclipseXmlProfileOptions, @Nullable String selectedProfileName) throws SchemeImportException {
            Intrinsics.checkNotNullParameter((Object)$this$readEclipseXmlProfileOptions, (String)"<this>");
            Map settings = new LinkedHashMap();
            this.readEclipseXmlProfile($this$readEclipseXmlProfileOptions, new EclipseXmlProfileReader.OptionHandler(selectedProfileName, settings){
                private String currentProfileName;
                final /* synthetic */ String $selectedProfileName;
                final /* synthetic */ Map<String, String> $settings;
                {
                    this.$selectedProfileName = $selectedProfileName;
                    this.$settings = $settings;
                }

                public final String getCurrentProfileName() {
                    return this.currentProfileName;
                }

                public final void setCurrentProfileName(String string) {
                    this.currentProfileName = string;
                }

                public void handleOption(String eclipseKey, String value) {
                    Intrinsics.checkNotNullParameter((Object)eclipseKey, (String)"eclipseKey");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    if (this.$selectedProfileName == null || this.currentProfileName != null && Intrinsics.areEqual((Object)this.currentProfileName, (Object)this.$selectedProfileName)) {
                        this.$settings.put(eclipseKey, value);
                    }
                }

                public void handleName(String name) {
                    this.currentProfileName = name;
                }
            });
            return settings;
        }

        public static /* synthetic */ Map readEclipseXmlProfileOptions$default(Companion companion, InputStream inputStream, String string, int n, Object object) throws SchemeImportException {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.readEclipseXmlProfileOptions(inputStream, string);
        }

        @JvmStatic
        public final void readEclipseXmlProfile(@NotNull VirtualFile $this$readEclipseXmlProfile, @NotNull EclipseXmlProfileReader.OptionHandler handler) throws SchemeImportException {
            Intrinsics.checkNotNullParameter((Object)$this$readEclipseXmlProfile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            this.readEclipseXmlProfile(this.getInputStreamAndWrapIOException($this$readEclipseXmlProfile), handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void readEclipseXmlProfile(@NotNull InputStream $this$readEclipseXmlProfile, @NotNull EclipseXmlProfileReader.OptionHandler handler) throws SchemeImportException {
            Intrinsics.checkNotNullParameter((Object)$this$readEclipseXmlProfile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Closeable closeable = $this$readEclipseXmlProfile;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                new EclipseXmlProfileReader(handler).readSettings(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final InputStream getInputStreamAndWrapIOException(VirtualFile $this$getInputStreamAndWrapIOException) {
            InputStream inputStream;
            try {
                inputStream = $this$getInputStreamAndWrapIOException.getInputStream();
            }
            catch (IOException e) {
                throw new SchemeImportException((Throwable)e);
            }
            InputStream inputStream2 = inputStream;
            Intrinsics.checkNotNull((Object)inputStream2);
            return inputStream2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

