/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ide.RegionUrlMapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.RegistryKeys;
import com.intellij.packageChecker.model.ConfigUrlHolder;
import com.intellij.packageChecker.model.HttpClientApi;
import com.intellij.packageChecker.model.HttpClientHeadersService;
import com.intellij.packageChecker.model.RemoteConfigService;
import com.intellij.packageChecker.model.RemoteConfigServiceKt;
import com.intellij.packageChecker.model.ResourceUrl;
import com.intellij.packageChecker.model.UrlConfig;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0018\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/packageChecker/model/RemoteConfigService;", "", "<init>", "()V", "httpClient", "Lcom/intellij/packageChecker/model/HttpClientApi;", "initialExpiration", "Ljava/time/LocalDateTime;", "standardExpiration", "defaultDbUrl", "Lcom/intellij/packageChecker/model/ResourceUrl;", "cachedConfig", "Lcom/intellij/packageChecker/model/UrlConfig;", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "", "kotlin.jvm.PlatformType", "Ljava/net/http/HttpResponse$BodyHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDbUrl", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "obtainUrlConfigOrDefault", "getCopyrightOrEmpty", "getCopyright", "withLink", "", "resetCacheToDefault", "", "Companion", "intellij.packageChecker"})
public final class RemoteConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClientApi httpClient = new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getHeaderParams(), null, 2, null);
    @NotNull
    private final LocalDateTime initialExpiration;
    @NotNull
    private final LocalDateTime standardExpiration;
    @NotNull
    private final ResourceUrl defaultDbUrl;
    @NotNull
    private UrlConfig cachedConfig;
    private final HttpResponse.BodyHandler<String> bodyHandler;
    private final ObjectMapper objectMapper;

    public RemoteConfigService() {
        LocalDateTime localDateTime = LocalDateTime.now().minusHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"minusHours(...)");
        this.initialExpiration = localDateTime;
        LocalDateTime localDateTime2 = LocalDateTime.now().plusDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"plusDays(...)");
        this.standardExpiration = localDateTime2;
        this.defaultDbUrl = new ResourceUrl(RegistryKeys.INSTANCE.getDatabaseUrl(), this.initialExpiration);
        this.cachedConfig = new UrlConfig(this.defaultDbUrl, null, null, 6, null);
        this.bodyHandler = HttpResponse.BodyHandlers.ofString(Charset.defaultCharset());
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getDbUrl(@NotNull Continuation<? super ResourceUrl> $completion) {
        if (!($completion instanceof getDbUrl.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteConfigService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getDbUrl((Continuation<? super ResourceUrl>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (RegistryKeys.INSTANCE.getDisableRemoteConfiguration()) {
                    return this.cachedConfig.db;
                }
                if (this.cachedConfig.db.expiration.compareTo(LocalDateTime.now()) >= 0) ** GOTO lbl29
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = this.obtainUrlConfigOrDefault((Continuation<? super UrlConfig>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                var2_5 = (RemoteConfigService)$continuation.L$1;
                this = (RemoteConfigService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                var2_5.cachedConfig = (UrlConfig)v0;
lbl29:
                // 2 sources

                return this.cachedConfig.db;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object obtainUrlConfigOrDefault(Continuation<? super UrlConfig> $completion) {
        if (!($completion instanceof obtainUrlConfigOrDefault.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteConfigService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteConfigService.access$obtainUrlConfigOrDefault(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
                    int label;
                    final /* synthetic */ RemoteConfigService this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                String string = RegionUrlMapper.mapUrl((String)ConfigUrlHolder.INSTANCE.getDefaultConfigUrl(), (Region)RegionSettings.getRegion());
                                if (string == null) {
                                    string = ConfigUrlHolder.INSTANCE.getDefaultConfigUrl();
                                }
                                String regionConfigUrl = string;
                                HttpClientApi httpClientApi = RemoteConfigService.access$getHttpClient$p(this.this$0);
                                HttpResponse.BodyHandler bodyHandler2 = RemoteConfigService.access$getBodyHandler$p(this.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)bodyHandler2, (String)"access$getBodyHandler$p(...)");
                                this.label = 1;
                                Object object3 = httpClientApi.get(regionConfigUrl, bodyHandler2, (Continuation)this);
                                if (object3 != object2) return ((HttpResponse)object3).body();
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return ((HttpResponse)object3).body();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var6_4) goto lbl19
lbl18:
                // 1 sources

                return var6_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (RemoteConfigService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    body = (String)v0;
                    urlConfig = (UrlConfig)this.objectMapper.readValue(body, UrlConfig.class);
                    var2_5 = UrlConfig.copy$default(urlConfig, new ResourceUrl(urlConfig.db.url, this.standardExpiration), null, null, 6, null);
                }
                catch (Exception e) {
                    RemoteConfigServiceKt.access$getLogger$p().warn("Cannot load config from url: " + ConfigUrlHolder.INSTANCE.getDefaultConfigUrl(), (Throwable)e);
                    var2_5 = new UrlConfig(this.defaultDbUrl, null, null, 6, null);
                }
                return var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NlsSafe
    @NotNull
    public final String getCopyrightOrEmpty() {
        String string = RemoteConfigService.getCopyright$default(this, false, 1, null);
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NlsSafe
    @Nullable
    public final String getCopyright(boolean withLink) {
        String string;
        String dataProvider;
        String string2 = dataProvider = this.cachedConfig.dataProvider;
        if (string2 == null) return null;
        if (StringsKt.isBlank((CharSequence)string2)) return null;
        boolean bl = true;
        if (!bl) return null;
        boolean bl2 = true;
        if (!bl2) {
            return null;
        }
        String dataProviderLink = this.cachedConfig.dataProviderLink;
        if (withLink) {
            String string3 = dataProviderLink;
            boolean bl3 = string3 != null ? !StringsKt.isBlank((CharSequence)string3) : false;
            if (bl3) {
                String link = "<a href=\"" + dataProviderLink + "\">" + dataProvider + "</a>";
                Object[] objectArray = new Object[]{link};
                string = PackageCheckerBundle.message("copyright.message", objectArray);
                return string;
            }
        }
        Object[] objectArray = new Object[]{dataProvider};
        string = PackageCheckerBundle.message("copyright.message", objectArray);
        return string;
    }

    public static /* synthetic */ String getCopyright$default(RemoteConfigService remoteConfigService, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return remoteConfigService.getCopyright(bl);
    }

    @TestOnly
    public final void resetCacheToDefault() {
        this.cachedConfig = new UrlConfig(this.defaultDbUrl, null, null, 6, null);
    }

    public static final /* synthetic */ Object access$obtainUrlConfigOrDefault(RemoteConfigService $this, Continuation $completion) {
        return $this.obtainUrlConfigOrDefault((Continuation<? super UrlConfig>)$completion);
    }

    public static final /* synthetic */ HttpClientApi access$getHttpClient$p(RemoteConfigService $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ HttpResponse.BodyHandler access$getBodyHandler$p(RemoteConfigService $this) {
        return $this.bodyHandler;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/packageChecker/model/RemoteConfigService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/packageChecker/model/RemoteConfigService;", "intellij.packageChecker"})
    @SourceDebugExtension(value={"SMAP\nRemoteConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigService.kt\ncom/intellij/packageChecker/model/RemoteConfigService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,103:1\n40#2,3:104\n*S KotlinDebug\n*F\n+ 1 RemoteConfigService.kt\ncom/intellij/packageChecker/model/RemoteConfigService$Companion\n*L\n87#1:104,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteConfigService getInstance() {
            boolean $i$f$service = false;
            Class<RemoteConfigService> serviceClass$iv = RemoteConfigService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RemoteConfigService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

