/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposer;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.RemoteRepository;

class EnhancedLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    private static final String LOCAL_REPO_ID = "";
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;
    private final LocalPathPrefixComposer localPathPrefixComposer;

    EnhancedLocalRepositoryManager(File basedir, LocalPathComposer localPathComposer, String trackingFilename, TrackingFileManager trackingFileManager, LocalPathPrefixComposer localPathPrefixComposer) {
        super(basedir, "enhanced", localPathComposer);
        this.trackingFilename = Objects.requireNonNull(trackingFilename);
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
        this.localPathPrefixComposer = Objects.requireNonNull(localPathPrefixComposer);
    }

    private String concatPaths(String prefix, String artifactPath) {
        if (prefix == null || prefix.isEmpty()) {
            return artifactPath;
        }
        return prefix + '/' + artifactPath;
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForLocalArtifact(artifact), super.getPathForLocalArtifact(artifact));
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForRemoteArtifact(artifact, repository), super.getPathForRemoteArtifact(artifact, repository, context));
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForLocalMetadata(metadata), super.getPathForLocalMetadata(metadata));
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.concatPaths(this.localPathPrefixComposer.getPathPrefixForRemoteMetadata(metadata, repository), super.getPathForRemoteMetadata(metadata, repository, context));
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        File file;
        String path;
        Artifact artifact = request.getArtifact();
        LocalArtifactResult result2 = new LocalArtifactResult(request);
        if (Objects.equals(artifact.getVersion(), artifact.getBaseVersion())) {
            path = this.getPathForLocalArtifact(artifact);
            file = new File(this.getRepository().getBasedir(), path);
            this.checkFind(file, result2);
        }
        if (!result2.isAvailable()) {
            for (RemoteRepository repository : request.getRepositories()) {
                path = this.getPathForRemoteArtifact(artifact, repository, request.getContext());
                file = new File(this.getRepository().getBasedir(), path);
                this.checkFind(file, result2);
                if (!result2.isAvailable()) continue;
                break;
            }
        }
        return result2;
    }

    private void checkFind(File file, LocalArtifactResult result2) {
        if (file.isFile()) {
            result2.setFile(file);
            Properties props = this.readRepos(file);
            if (props.get(this.getKey(file, LOCAL_REPO_ID)) != null) {
                result2.setAvailable(true);
            } else {
                String context = result2.getRequest().getContext();
                for (RemoteRepository repository : result2.getRequest().getRepositories()) {
                    if (props.get(this.getKey(file, this.getRepositoryKey(repository, context))) == null) continue;
                    result2.setAvailable(true);
                    result2.setRepository(repository);
                    break;
                }
                if (!result2.isAvailable() && !this.isTracked(props, file)) {
                    result2.setAvailable(true);
                }
            }
        }
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        Collection<String> repositories = request.getRepository() == null ? Collections.singleton(LOCAL_REPO_ID) : this.getRepositoryKeys(request.getRepository(), request.getContexts());
        if (request.getRepository() == null) {
            this.addArtifact(request.getArtifact(), repositories, null, null);
        } else {
            for (String context : request.getContexts()) {
                this.addArtifact(request.getArtifact(), repositories, request.getRepository(), context);
            }
        }
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts2) {
        HashSet<String> keys2 = new HashSet<String>();
        if (contexts2 != null) {
            for (String context : contexts2) {
                keys2.add(this.getRepositoryKey(repository, context));
            }
        }
        return keys2;
    }

    private void addArtifact(Artifact artifact, Collection<String> repositories, RemoteRepository repository, String context) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        String path = repository == null ? this.getPathForLocalArtifact(artifact) : this.getPathForRemoteArtifact(artifact, repository, context);
        File file = new File(this.getRepository().getBasedir(), path);
        this.addRepo(file, repositories);
    }

    private Properties readRepos(File artifactFile) {
        File trackingFile = this.getTrackingFile(artifactFile);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private void addRepo(File artifactFile, Collection<String> repositories) {
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(artifactFile, repository), LOCAL_REPO_ID);
        }
        File trackingFile = this.getTrackingFile(artifactFile);
        this.trackingFileManager.update(trackingFile, updates);
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }

    private String getKey(File file, String repository) {
        return file.getName() + '>' + repository;
    }

    private boolean isTracked(Properties props, File file) {
        if (props != null) {
            String keyPrefix = file.getName() + '>';
            for (Object key : props.keySet()) {
                if (!key.toString().startsWith(keyPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

