/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

public final class DataPool {
    private static final String CONFIG_PROP_COLLECTOR_POOL_ARTIFACT = "aether.dependencyCollector.pool.artifact";
    private static final String CONFIG_PROP_COLLECTOR_POOL_DEPENDENCY = "aether.dependencyCollector.pool.dependency";
    private static final String CONFIG_PROP_COLLECTOR_POOL_DESCRIPTOR = "aether.dependencyCollector.pool.descriptor";
    private static final String CONFIG_PROP_COLLECTOR_POOL_DEPENDENCY_LISTS = "aether.dependencyCollector.pool.dependencyLists";
    private static final String CONFIG_PROP_COLLECTOR_POOL_INTERN_ARTIFACT_DESCRIPTOR_DEPENDENCIES = "aether.dependencyCollector.pool.internArtifactDescriptorDependencies";
    private static final String CONFIG_PROP_COLLECTOR_POOL_INTERN_ARTIFACT_DESCRIPTOR_MANAGED_DEPENDENCIES = "aether.dependencyCollector.pool.internArtifactDescriptorManagedDependencies";
    private static final String ARTIFACT_POOL = DataPool.class.getName() + "$Artifact";
    private static final String DEPENDENCY_POOL = DataPool.class.getName() + "$Dependency";
    private static final String DESCRIPTORS = DataPool.class.getName() + "$Descriptors";
    private static final String DEPENDENCY_LISTS_POOL = DataPool.class.getName() + "$DependencyLists";
    public static final ArtifactDescriptorResult NO_DESCRIPTOR = new ArtifactDescriptorResult(new ArtifactDescriptorRequest());
    private final InternPool<Artifact, Artifact> artifacts;
    private final InternPool<Dependency, Dependency> dependencies;
    private final InternPool<DescriptorKey, Descriptor> descriptors;
    private final InternPool<List<Dependency>, List<Dependency>> dependencyLists;
    private final ConcurrentHashMap<Object, Constraint> constraints;
    private final ConcurrentHashMap<Object, List<DependencyNode>> nodes;
    private final boolean internArtifactDescriptorDependencies;
    private final boolean internArtifactDescriptorManagedDependencies;
    private static final String HARD = "hard";
    private static final String WEAK = "weak";

    public DataPool(RepositorySystemSession session) {
        RepositoryCache cache2 = session.getCache();
        this.internArtifactDescriptorDependencies = ConfigUtils.getBoolean(session, false, CONFIG_PROP_COLLECTOR_POOL_INTERN_ARTIFACT_DESCRIPTOR_DEPENDENCIES);
        this.internArtifactDescriptorManagedDependencies = ConfigUtils.getBoolean(session, true, CONFIG_PROP_COLLECTOR_POOL_INTERN_ARTIFACT_DESCRIPTOR_MANAGED_DEPENDENCIES);
        InternPool artifactsPool = null;
        InternPool dependenciesPool = null;
        InternPool descriptorsPool = null;
        InternPool dependencyListsPool = null;
        if (cache2 != null) {
            artifactsPool = (InternPool)cache2.get(session, ARTIFACT_POOL);
            dependenciesPool = (InternPool)cache2.get(session, DEPENDENCY_POOL);
            descriptorsPool = (InternPool)cache2.get(session, DESCRIPTORS);
            dependencyListsPool = (InternPool)cache2.get(session, DEPENDENCY_LISTS_POOL);
        }
        if (artifactsPool == null) {
            String artifactPoolType = ConfigUtils.getString(session, WEAK, CONFIG_PROP_COLLECTOR_POOL_ARTIFACT);
            artifactsPool = DataPool.createPool(artifactPoolType);
            if (cache2 != null) {
                cache2.put(session, ARTIFACT_POOL, artifactsPool);
            }
        }
        if (dependenciesPool == null) {
            String dependencyPoolType = ConfigUtils.getString(session, WEAK, CONFIG_PROP_COLLECTOR_POOL_DEPENDENCY);
            dependenciesPool = DataPool.createPool(dependencyPoolType);
            if (cache2 != null) {
                cache2.put(session, DEPENDENCY_POOL, dependenciesPool);
            }
        }
        if (descriptorsPool == null) {
            String descriptorPoolType = ConfigUtils.getString(session, HARD, CONFIG_PROP_COLLECTOR_POOL_DESCRIPTOR);
            descriptorsPool = DataPool.createPool(descriptorPoolType);
            if (cache2 != null) {
                cache2.put(session, DESCRIPTORS, descriptorsPool);
            }
        }
        if (dependencyListsPool == null) {
            String dependencyListsPoolType = ConfigUtils.getString(session, HARD, CONFIG_PROP_COLLECTOR_POOL_DEPENDENCY_LISTS);
            dependencyListsPool = DataPool.createPool(dependencyListsPoolType);
            if (cache2 != null) {
                cache2.put(session, DEPENDENCY_LISTS_POOL, dependencyListsPool);
            }
        }
        this.artifacts = artifactsPool;
        this.dependencies = dependenciesPool;
        this.descriptors = descriptorsPool;
        this.dependencyLists = dependencyListsPool;
        this.constraints = new ConcurrentHashMap(256);
        this.nodes = new ConcurrentHashMap(256);
    }

    public Artifact intern(Artifact artifact) {
        return this.artifacts.intern(artifact, artifact);
    }

    public Dependency intern(Dependency dependency) {
        return this.dependencies.intern(dependency, dependency);
    }

    public DescriptorKey toKey(ArtifactDescriptorRequest request) {
        return new DescriptorKey(request.getArtifact());
    }

    public ArtifactDescriptorResult getDescriptor(DescriptorKey key, ArtifactDescriptorRequest request) {
        Descriptor descriptor2 = this.descriptors.get(key);
        if (descriptor2 != null) {
            return descriptor2.toResult(request);
        }
        return null;
    }

    public void putDescriptor(DescriptorKey key, ArtifactDescriptorResult result2) {
        if (this.internArtifactDescriptorDependencies) {
            result2.setDependencies(this.intern(result2.getDependencies()));
        }
        if (this.internArtifactDescriptorManagedDependencies) {
            result2.setManagedDependencies(this.intern(result2.getManagedDependencies()));
        }
        this.descriptors.intern(key, new GoodDescriptor(result2));
    }

    public void putDescriptor(DescriptorKey key, ArtifactDescriptorException e) {
        this.descriptors.intern(key, BadDescriptor.INSTANCE);
    }

    private List<Dependency> intern(List<Dependency> dependencies) {
        return this.dependencyLists.intern(dependencies, dependencies);
    }

    public Object toKey(VersionRangeRequest request) {
        return new ConstraintKey(request);
    }

    public VersionRangeResult getConstraint(Object key, VersionRangeRequest request) {
        Constraint constraint = this.constraints.get(key);
        if (constraint != null) {
            return constraint.toResult(request);
        }
        return null;
    }

    public void putConstraint(Object key, VersionRangeResult result2) {
        this.constraints.put(key, new Constraint(result2));
    }

    public Object toKey(Artifact artifact, List<RemoteRepository> repositories, DependencySelector selector, DependencyManager manager, DependencyTraverser traverser, VersionFilter filter2) {
        return new GraphKey(artifact, repositories, selector, manager, traverser, filter2);
    }

    public List<DependencyNode> getChildren(Object key) {
        return this.nodes.get(key);
    }

    public void putChildren(Object key, List<DependencyNode> children2) {
        this.nodes.put(key, children2);
    }

    private static <K, V> InternPool<K, V> createPool(String type) {
        if (HARD.equals(type)) {
            return new HardInternPool();
        }
        if (WEAK.equals(type)) {
            return new WeakInternPool();
        }
        throw new IllegalArgumentException("Unknown object pool type: '" + type + "'");
    }

    private static interface InternPool<K, V> {
        public V get(K var1);

        public V intern(K var1, V var2);
    }

    public static final class DescriptorKey {
        private final Artifact artifact;
        private final int hashCode;

        private DescriptorKey(Artifact artifact) {
            this.artifact = artifact;
            this.hashCode = Objects.hashCode(artifact);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DescriptorKey that = (DescriptorKey)o;
            return Objects.equals(this.artifact, that.artifact);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{artifact='" + this.artifact + '\'' + '}';
        }
    }

    static abstract class Descriptor {
        Descriptor() {
        }

        public abstract ArtifactDescriptorResult toResult(ArtifactDescriptorRequest var1);
    }

    static final class GoodDescriptor
    extends Descriptor {
        final Artifact artifact;
        final List<Artifact> relocations;
        final Collection<Artifact> aliases;
        final List<RemoteRepository> repositories;
        final List<Dependency> dependencies;
        final List<Dependency> managedDependencies;

        GoodDescriptor(ArtifactDescriptorResult result2) {
            this.artifact = result2.getArtifact();
            this.relocations = result2.getRelocations();
            this.aliases = result2.getAliases();
            this.dependencies = result2.getDependencies();
            this.managedDependencies = result2.getManagedDependencies();
            this.repositories = result2.getRepositories();
        }

        @Override
        public ArtifactDescriptorResult toResult(ArtifactDescriptorRequest request) {
            ArtifactDescriptorResult result2 = new ArtifactDescriptorResult(request);
            result2.setArtifact(this.artifact);
            result2.setRelocations(this.relocations);
            result2.setAliases(this.aliases);
            result2.setDependencies(this.dependencies);
            result2.setManagedDependencies(this.managedDependencies);
            result2.setRepositories(this.repositories);
            return result2;
        }
    }

    static final class BadDescriptor
    extends Descriptor {
        static final BadDescriptor INSTANCE = new BadDescriptor();

        BadDescriptor() {
        }

        @Override
        public ArtifactDescriptorResult toResult(ArtifactDescriptorRequest request) {
            return NO_DESCRIPTOR;
        }
    }

    static final class ConstraintKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        ConstraintKey(VersionRangeRequest request) {
            this.artifact = request.getArtifact();
            this.repositories = request.getRepositories();
            this.hashCode = this.artifact.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConstraintKey)) {
                return false;
            }
            ConstraintKey that = (ConstraintKey)obj;
            return this.artifact.equals(that.artifact) && ConstraintKey.equals(this.repositories, that.repositories);
        }

        private static boolean equals(List<RemoteRepository> repos1, List<RemoteRepository> repos2) {
            if (repos1.size() != repos2.size()) {
                return false;
            }
            Iterator<RemoteRepository> it1 = repos1.iterator();
            Iterator<RemoteRepository> it2 = repos2.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                RemoteRepository repo1 = it1.next();
                RemoteRepository repo2 = it2.next();
                if (repo1.isRepositoryManager() != repo2.isRepositoryManager()) {
                    return false;
                }
                if (repo1.isRepositoryManager()) {
                    if (ConstraintKey.equals(repo1.getMirroredRepositories(), repo2.getMirroredRepositories())) continue;
                    return false;
                }
                if (!repo1.getUrl().equals(repo2.getUrl())) {
                    return false;
                }
                if (repo1.getPolicy(true).isEnabled() != repo2.getPolicy(true).isEnabled()) {
                    return false;
                }
                if (repo1.getPolicy(false).isEnabled() == repo2.getPolicy(false).isEnabled()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class Constraint {
        final VersionRepo[] repositories;
        final VersionConstraint versionConstraint;

        Constraint(VersionRangeResult result2) {
            this.versionConstraint = result2.getVersionConstraint();
            List<Version> versions = result2.getVersions();
            this.repositories = new VersionRepo[versions.size()];
            int i = 0;
            for (Version version : versions) {
                this.repositories[i++] = new VersionRepo(version, result2.getRepository(version));
            }
        }

        VersionRangeResult toResult(VersionRangeRequest request) {
            VersionRangeResult result2 = new VersionRangeResult(request);
            for (VersionRepo vr : this.repositories) {
                result2.addVersion(vr.version);
                result2.setRepository(vr.version, vr.repo);
            }
            result2.setVersionConstraint(this.versionConstraint);
            return result2;
        }

        static final class VersionRepo {
            final Version version;
            final ArtifactRepository repo;

            VersionRepo(Version version, ArtifactRepository repo) {
                this.version = version;
                this.repo = repo;
            }
        }
    }

    static final class GraphKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final DependencySelector selector;
        private final DependencyManager manager;
        private final DependencyTraverser traverser;
        private final VersionFilter filter;
        private final int hashCode;

        GraphKey(Artifact artifact, List<RemoteRepository> repositories, DependencySelector selector, DependencyManager manager, DependencyTraverser traverser, VersionFilter filter2) {
            this.artifact = artifact;
            this.repositories = repositories;
            this.selector = selector;
            this.manager = manager;
            this.traverser = traverser;
            this.filter = filter2;
            this.hashCode = Objects.hash(artifact, repositories, selector, manager, traverser, filter2);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof GraphKey)) {
                return false;
            }
            GraphKey that = (GraphKey)obj;
            return Objects.equals(this.artifact, that.artifact) && Objects.equals(this.repositories, that.repositories) && Objects.equals(this.selector, that.selector) && Objects.equals(this.manager, that.manager) && Objects.equals(this.traverser, that.traverser) && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class HardInternPool<K, V>
    implements InternPool<K, V> {
        private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap(256);

        private HardInternPool() {
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public V intern(K key, V value) {
            return (V)this.map.computeIfAbsent(key, k -> value);
        }
    }

    private static class WeakInternPool<K, V>
    implements InternPool<K, V> {
        private final Map<K, WeakReference<V>> map = Collections.synchronizedMap(new WeakHashMap(256));

        private WeakInternPool() {
        }

        @Override
        public V get(K key) {
            WeakReference<V> ref = this.map.get(key);
            return ref != null ? (V)ref.get() : null;
        }

        @Override
        public V intern(K key, V value) {
            Object pooled;
            WeakReference<V> pooledRef = this.map.get(key);
            if (pooledRef != null && (pooled = pooledRef.get()) != null) {
                return (V)pooled;
            }
            this.map.put(key, new WeakReference<V>(value));
            return value;
        }
    }
}

