/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.Paths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/history/core/HistoryPathFilter;", "", "guessedProjectDir", "", "pathFilter", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "matcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "getMatcher", "()Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "affectsMatching", "", "path", "Companion", "intellij.platform.lvcs.impl"})
@ApiStatus.Experimental
public final class HistoryPathFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String guessedProjectDir;
    @NotNull
    private final MinusculeMatcher matcher;

    private HistoryPathFilter(String guessedProjectDir, String pathFilter) {
        this.guessedProjectDir = guessedProjectDir;
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)("*" + pathFilter)).build();
        Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"build(...)");
        this.matcher = minusculeMatcher;
    }

    @NotNull
    public final MinusculeMatcher getMatcher() {
        return this.matcher;
    }

    public final boolean affectsMatching(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.guessedProjectDir != null && StringsKt.startsWith$default((String)path, (String)this.guessedProjectDir, (boolean)false, (int)2, null)) {
            String string2 = path.substring(this.guessedProjectDir.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = Paths.getNameOf(path);
        }
        String partToMatch = string;
        return this.matcher.matches(partToMatch);
    }

    @JvmStatic
    @Nullable
    public static final HistoryPathFilter create(@Nullable String pathPattern, @NotNull Project project) {
        return Companion.create(pathPattern, project);
    }

    @JvmStatic
    @TestOnly
    @JvmName(name="create")
    @Nullable
    public static final HistoryPathFilter create(@Nullable String guessedProjectDir, @Nullable String pathPattern) {
        return Companion.create(guessedProjectDir, pathPattern);
    }

    public /* synthetic */ HistoryPathFilter(String guessedProjectDir, String pathFilter, DefaultConstructorMarker $constructor_marker) {
        this(guessedProjectDir, pathFilter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0001\u00a8\u0006\u000b"}, d2={"Lcom/intellij/history/core/HistoryPathFilter$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/history/core/HistoryPathFilter;", "pathPattern", "", "project", "Lcom/intellij/openapi/project/Project;", "guessedProjectDir", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final HistoryPathFilter create(@Nullable String pathPattern, @NotNull Project project) {
            HistoryPathFilter historyPathFilter;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (pathPattern == null) {
                historyPathFilter = null;
            } else {
                VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
                historyPathFilter = new HistoryPathFilter(virtualFile != null ? virtualFile.getPath() : null, pathPattern, null);
            }
            return historyPathFilter;
        }

        @JvmStatic
        @TestOnly
        @JvmName(name="create")
        @Nullable
        public final HistoryPathFilter create(@Nullable String guessedProjectDir, @Nullable String pathPattern) {
            return pathPattern == null ? null : new HistoryPathFilter(guessedProjectDir, pathPattern, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

