/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.javac.Iterators;

public final class PersistentMultiMaplet<K, V, C extends Collection<V>>
implements MultiMaplet<K, V> {
    private final PersistentHashMap<K, C> myMap;
    private final DataExternalizer<V> myValueExternalizer;
    private final C myEmptyCollection;
    private final Supplier<? extends C> myCollectionFactory;

    public PersistentMultiMaplet(Path mapFile, KeyDescriptor<K> keyDescriptor, final DataExternalizer<V> valueExternalizer, Supplier<? extends C> collectionFactory) {
        this.myCollectionFactory = collectionFactory;
        try {
            Collection col = (Collection)collectionFactory.get();
            this.myEmptyCollection = col instanceof List ? Collections.emptyList() : (col instanceof Set ? Collections.emptySet() : col);
            this.myValueExternalizer = valueExternalizer;
            this.myMap = PersistentMapBuilder.newBuilder((Path)mapFile, keyDescriptor, (DataExternalizer)new DataExternalizer<C>(){

                public void save(@NotNull DataOutput out, C data) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    out.writeInt(data.size());
                    for (Object value : data) {
                        valueExternalizer.save(out, value);
                    }
                }

                public C read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Collection acc = (Collection)PersistentMultiMaplet.this.myCollectionFactory.get();
                    DataInputStream stream = (DataInputStream)in;
                    while (stream.available() > 0) {
                        int size = stream.readInt();
                        Consumer<Object> appender = size >= 0 ? acc::add : acc::remove;
                        size = Math.abs(size);
                        while (size-- > 0) {
                            appender.accept(valueExternalizer.read((DataInput)stream));
                        }
                    }
                    return acc;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "out";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "in";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/jps/dependency/impl/PersistentMultiMaplet$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "save";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "read";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).build();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsKey(K key) {
        try {
            return this.myMap.containsMapping(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @NotNull
    public C get(K key) {
        Collection<Object> collection;
        try {
            Collection col = (Collection)this.myMap.get(key);
            collection = col != null ? col : this.myEmptyCollection;
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
        if (collection == null) {
            PersistentMultiMaplet.$$$reportNull$$$0(0);
        }
        return (C)collection;
    }

    @Override
    public void put(K key, @NotNull Iterable<? extends V> values) {
        if (values == null) {
            PersistentMultiMaplet.$$$reportNull$$$0(1);
        }
        try {
            C data = this.ensureCollection(values);
            if (data.isEmpty()) {
                this.myMap.remove(key);
            } else {
                this.myMap.put(key, data);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private C ensureCollection(Iterable<? extends V> seq) {
        if (this.myEmptyCollection instanceof Set && seq instanceof Set) {
            return (C)((Collection)seq);
        }
        if (this.myEmptyCollection instanceof List && seq instanceof List) {
            return (C)((Collection)seq);
        }
        return (C)Iterators.collect(seq, (Collection)((Collection)this.myCollectionFactory.get()));
    }

    @Override
    public void remove(K key) {
        try {
            this.myMap.remove(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void appendValue(K key, V value) {
        this.appendValues(key, Collections.singleton(value));
    }

    @Override
    public void appendValues(K key, final @NotNull Iterable<? extends V> values) {
        if (values == null) {
            PersistentMultiMaplet.$$$reportNull$$$0(2);
        }
        if (!Iterators.isEmpty(values)) {
            try {
                this.myMap.appendData(key, new AppendablePersistentMap.ValueDataAppender(){

                    public void append(@NotNull DataOutput out) throws IOException {
                        if (out == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        out.writeInt(Iterators.count((Iterable)values));
                        for (Object v : values) {
                            PersistentMultiMaplet.this.myValueExternalizer.save(out, v);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/dependency/impl/PersistentMultiMaplet$2", "append"));
                    }
                });
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    @Override
    public void removeValue(K key, V value) {
        this.removeValues(key, Collections.singleton(value));
    }

    @Override
    public void removeValues(K key, final @NotNull Iterable<? extends V> values) {
        if (values == null) {
            PersistentMultiMaplet.$$$reportNull$$$0(3);
        }
        if (!Iterators.isEmpty(values)) {
            try {
                this.myMap.appendData(key, new AppendablePersistentMap.ValueDataAppender(){

                    public void append(@NotNull DataOutput out) throws IOException {
                        if (out == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        out.writeInt(-Iterators.count((Iterable)values));
                        for (Object v : values) {
                            PersistentMultiMaplet.this.myValueExternalizer.save(out, v);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/dependency/impl/PersistentMultiMaplet$3", "append"));
                    }
                });
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    @Override
    @NotNull
    public Iterable<K> getKeys() {
        Collection collection;
        try {
            collection = this.myMap.getAllKeysWithExistingMapping();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (collection == null) {
            PersistentMultiMaplet.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public void close() {
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.myMap.force();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/PersistentMultiMaplet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/PersistentMultiMaplet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

