/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;

public final class BuildTargetTypeState {
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getInstance(BuildTargetTypeState.class);
    private final Object2IntOpenHashMap<BuildTarget<?>> targetIds = new Object2IntOpenHashMap();
    private final List<Pair<String, Integer>> myStaleTargetIds;
    private final ConcurrentMap<BuildTarget<?>, BuildTargetConfiguration> configurations;
    private final BuildTargetType<?> myTargetType;
    private final BuildTargetsState targetState;
    private final Path myTargetsFile;
    private volatile long myAverageTargetBuildTimeMs = -1L;

    public BuildTargetTypeState(BuildTargetType<?> targetType, BuildTargetsState state) {
        this.targetIds.defaultReturnValue(-1);
        this.myTargetType = targetType;
        this.targetState = state;
        this.myTargetsFile = state.getDataPaths().getTargetTypeDataRoot(targetType).toPath().resolve("targets.dat");
        this.configurations = new ConcurrentHashMap();
        this.myStaleTargetIds = new ArrayList<Pair<String, Integer>>();
        this.load();
    }

    private void load() {
        if (Files.notExists(this.myTargetsFile, new LinkOption[0])) {
            return;
        }
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.myTargetsFile, new OpenOption[0])));){
            int version = input.readInt();
            int size = input.readInt();
            BuildTargetLoader<?> loader = this.myTargetType.createLoader(this.targetState.getModel());
            while (size-- > 0) {
                String stringId = IOUtil.readString((DataInput)input);
                int intId = input.readInt();
                this.targetState.markUsedId(intId);
                Object target = loader.createTarget(stringId);
                if (target != null) {
                    this.targetIds.put(target, intId);
                    continue;
                }
                this.myStaleTargetIds.add((Pair<String, Integer>)Pair.create((Object)stringId, (Object)intId));
            }
            if (version >= 1) {
                this.myAverageTargetBuildTimeMs = input.readLong();
            }
        }
        catch (IOException e) {
            LOG.info("Cannot load " + this.myTargetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void save() {
        try {
            NioFiles.createParentDirectories((Path)this.myTargetsFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(this.myTargetsFile, new OpenOption[0])));){
            output.writeInt(1);
            output.writeInt(this.targetIds.size() + this.myStaleTargetIds.size());
            for (Object2IntMap.Entry entry : this.targetIds.object2IntEntrySet()) {
                IOUtil.writeString((String)((BuildTarget)entry.getKey()).getId(), (DataOutput)output);
                output.writeInt(entry.getIntValue());
            }
            for (Pair pair : this.myStaleTargetIds) {
                IOUtil.writeString((String)((String)pair.first), (DataOutput)output);
                output.writeInt((Integer)pair.second);
            }
            output.writeLong(this.myAverageTargetBuildTimeMs);
        }
        catch (IOException e) {
            LOG.info("Cannot save " + this.myTargetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public synchronized List<Pair<String, Integer>> getStaleTargetIds() {
        return new ArrayList<Pair<String, Integer>>(this.myStaleTargetIds);
    }

    public synchronized void removeStaleTarget(String targetId) {
        this.myStaleTargetIds.removeIf(pair -> ((String)pair.first).equals(targetId));
    }

    public synchronized int getTargetId(BuildTarget<?> target) {
        int result = this.targetIds.getInt(target);
        if (result == -1) {
            result = this.targetState.getFreeId();
            this.targetIds.put(target, result);
        }
        return result;
    }

    public void setAverageTargetBuildTime(long timeInMs) {
        this.myAverageTargetBuildTimeMs = timeInMs;
    }

    public long getAverageTargetBuildTime() {
        return this.myAverageTargetBuildTimeMs;
    }

    @NotNull
    public BuildTargetConfiguration getConfiguration(@NotNull BuildTarget<?> target) {
        BuildTargetConfiguration configuration;
        if (target == null) {
            BuildTargetTypeState.$$$reportNull$$$0(0);
        }
        if ((configuration = (BuildTargetConfiguration)this.configurations.get(target)) != null) {
            BuildTargetConfiguration buildTargetConfiguration = configuration;
            if (buildTargetConfiguration == null) {
                BuildTargetTypeState.$$$reportNull$$$0(1);
            }
            return buildTargetConfiguration;
        }
        configuration = new BuildTargetConfiguration(target, this.targetState);
        BuildTargetConfiguration existing = this.configurations.putIfAbsent(target, configuration);
        BuildTargetConfiguration buildTargetConfiguration = existing == null ? configuration : existing;
        if (buildTargetConfiguration == null) {
            BuildTargetTypeState.$$$reportNull$$$0(2);
        }
        return buildTargetConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetTypeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetTypeState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

