/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Pair;

final class PointAndParentForScrollingJTextFieldQuery {
    @Nonnull
    @RunsInCurrentThread
    static Pair<Point, Container> pointAndParentForScrolling(@Nonnull JTextField textField) {
        Container parent;
        Point origin = new Point(textField.getX(), textField.getY());
        for (parent = textField.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            origin = PointAndParentForScrollingJTextFieldQuery.addRectangleToPoint(Preconditions.checkNotNull(parent.getBounds()), origin);
        }
        return Pair.of(origin, parent);
    }

    @Nonnull
    private static Point addRectangleToPoint(@Nonnull Rectangle r, @Nonnull Point p) {
        Point newPoint = new Point(p);
        newPoint.x += r.x;
        newPoint.y += r.y;
        return newPoint;
    }

    private PointAndParentForScrollingJTextFieldQuery() {
    }
}

