/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathEntry {
    private final String myClassPathEntry;
    private static final DirectoryEntryProcessor myDirectoryProcessor = new DirectoryEntryProcessor();
    private static final ZipEntryProcessor myZipProcessor = new ZipEntryProcessor();

    /*
     * WARNING - void declaration
     */
    public ClassPathEntry(String classPathEntry) {
        void var1_1;
        this.myClassPathEntry = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void iterateMatchedClasses(ClassFilter filter, ClassEntry.Consumer consumer) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        ClassPathEntryProcessor processor = ClassPathEntry.createEntryProcessor(this.myClassPathEntry);
        if (processor == null) {
            return;
        }
        processor.setFilter((ClassFilter)var1_1);
        var3_3.iterateMatchedClasses(this.myClassPathEntry, (ClassEntry.Consumer)var2_2);
    }

    private static ClassPathEntryProcessor createEntryProcessor(String entry) {
        File file;
        File file2 = new File(entry);
        if (file2.isDirectory()) {
            return myDirectoryProcessor;
        }
        if (file2.isFile() && (file2.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
            return myZipProcessor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathEntry that = (ClassPathEntry)o;
        return this.myClassPathEntry.equals(var1_1.myClassPathEntry);
    }

    public int hashCode() {
        return this.myClassPathEntry.hashCode();
    }

    private static class ZipEntryProcessor
    extends AbstractClassPathEntryProcessor {
        private ZipEntryProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        public void iterateMatchedClasses(String classPathEntry, ClassEntry.Consumer consumer) throws IOException {
            void var1_1;
            Object var2_2;
            ZipFile zipFile = new ZipFile(new File(classPathEntry));
            try {
                InputStream[] is = new InputStream[]{null};
                Enumeration<? extends ZipEntry> zenum = zipFile.entries();
                while (zenum.hasMoreElements()) {
                    Object var5_5;
                    String className;
                    ZipEntry ze = zenum.nextElement();
                    if (ze.isDirectory() || !ze.getName().endsWith(".class") || !this.shouldInclude(className = ClassNameUtil.convertToFQName(ClassNameUtil.removeClassSuffix(ze.getName())))) continue;
                    is[0] = null;
                    try {
                        ZipEntry zipEntry = ze;
                        consumer.consume(new ClassEntry(this, className, is, zipFile, zipEntry){
                            final /* synthetic */ InputStream[] val$is;
                            final /* synthetic */ ZipFile val$zipFile;
                            final /* synthetic */ ZipEntry val$zipEntry;
                            final /* synthetic */ ZipEntryProcessor this$0;
                            {
                                void var2_2;
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$is = inputStreamArray;
                                this.val$zipFile = zipFile;
                                this.val$zipEntry = zipEntry;
                                super((String)var2_2);
                            }

                            public InputStream getClassInputStream() throws IOException {
                                this.val$is[0] = this.val$zipFile.getInputStream(this.val$zipEntry);
                                return this.val$is[0];
                            }
                        });
                        var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        var5_5 = null;
                        CoverageIOUtil.close(is[0]);
                        throw throwable;
                    }
                    CoverageIOUtil.close(is[0]);
                    {
                    }
                }
                var2_2 = null;
            }
            catch (Throwable throwable) {
                var2_2 = null;
                var1_1.close();
                throw throwable;
            }
            var1_1.close();
        }
    }

    private static class DirectoryEntryProcessor
    extends AbstractClassPathEntryProcessor {
        private DirectoryEntryProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        public void iterateMatchedClasses(String classPathEntry, ClassEntry.Consumer consumer) {
            void var3_3;
            void var2_2;
            void var1_1;
            File dir = new File(classPathEntry);
            InputStream[] is = new InputStream[]{null};
            this.collectClasses("", (File)var1_1, (ClassEntry.Consumer)var2_2, (InputStream[])var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private void collectClasses(String curPath, File parent, ClassEntry.Consumer consumer, InputStream[] is) {
            File[] files = parent.listFiles();
            if (files != null) {
                void var2_2;
                String prefix = curPath.isEmpty() ? "" : curPath + ".";
                Arrays.sort(files, new Comparator<File>(this){
                    final /* synthetic */ DirectoryEntryProcessor this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int compare(File o1, File o2) {
                        void var2_2;
                        return ClassNameUtil.removeClassSuffix(o1.getName()).compareTo(ClassNameUtil.removeClassSuffix(var2_2.getName()));
                    }
                });
                for (Object f : var2_2) {
                    void var8_8;
                    String name = f.getName();
                    if (name.endsWith(".class")) {
                        String className = prefix + ClassNameUtil.removeClassSuffix(name);
                        if (!this.shouldInclude(className)) continue;
                        is[0] = null;
                        try {
                            consumer.consume(new ClassEntry(this, className, is, f){
                                final /* synthetic */ InputStream[] val$is;
                                final /* synthetic */ File val$f;
                                final /* synthetic */ DirectoryEntryProcessor this$0;
                                {
                                    void var2_2;
                                    void var1_1;
                                    this.this$0 = var1_1;
                                    this.val$is = inputStreamArray;
                                    this.val$f = file;
                                    super((String)var2_2);
                                }

                                public InputStream getClassInputStream() throws IOException {
                                    this.val$is[0] = new FileInputStream(this.val$f);
                                    return this.val$is[0];
                                }
                            });
                            f = null;
                        }
                        catch (Throwable throwable) {
                            f = null;
                            CoverageIOUtil.close(is[0]);
                            throw throwable;
                        }
                        CoverageIOUtil.close(is[0]);
                        {
                            continue;
                        }
                    }
                    if (!f.isDirectory()) continue;
                    this.collectClasses(prefix + (String)var8_8, f, consumer, is);
                }
            }
        }
    }

    private static interface ClassPathEntryProcessor {
        public void setFilter(ClassFilter var1);

        public void iterateMatchedClasses(String var1, ClassEntry.Consumer var2) throws IOException;
    }

    private static abstract class AbstractClassPathEntryProcessor
    implements ClassPathEntryProcessor {
        private ClassFilter myFilter;

        private AbstractClassPathEntryProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        public void setFilter(ClassFilter filter) {
            void var1_1;
            this.myFilter = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected final boolean shouldInclude(String className) {
            void var1_1;
            if (this.myFilter == null) {
                return true;
            }
            return this.myFilter.shouldInclude((String)var1_1);
        }
    }
}

