/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline;

import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElementManipulator;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionGrayTextElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionTextElement;
import com.intellij.ml.inline.completion.features.correctness.HighlightedRange;
import com.intellij.ml.inline.completion.impl.inline.HighlightRangesNormalizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.UtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J4\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0007J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0014\u0010\u001b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u001c\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionHighlighterUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "withAlpha", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "alpha", "", "highlight", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "suggestion", "", "additionalHighlights", "Lcom/intellij/ml/inline/completion/features/correctness/HighlightedRange;", "extend", "grayText", "safeShiftLeft", "Lcom/intellij/openapi/util/TextRange;", "delta", "mute", "withDefaults", "on", "Ljava/awt/Color;", "background", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nMLCompletionHighlighterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionHighlighterUtils.kt\ncom/intellij/ml/inline/completion/impl/inline/MLCompletionHighlighterUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n1#2:262\n1557#3:263\n1628#3,3:264\n1557#3:267\n1628#3,3:268\n774#3:271\n865#3,2:272\n24#4:274\n*S KotlinDebug\n*F\n+ 1 MLCompletionHighlighterUtils.kt\ncom/intellij/ml/inline/completion/impl/inline/MLCompletionHighlighterUtils\n*L\n54#1:263\n54#1:264,3\n77#1:267\n77#1:268,3\n78#1:271\n78#1:272,2\n29#1:274\n*E\n"})
public final class MLCompletionHighlighterUtils {
    @NotNull
    public static final MLCompletionHighlighterUtils INSTANCE;
    @NotNull
    private static final Logger LOG;

    private MLCompletionHighlighterUtils() {
    }

    @VisibleForTesting
    @NotNull
    public final TextAttributes withAlpha(@NotNull TextAttributes $this$withAlpha, @NotNull EditorColorsScheme scheme, int alpha) {
        TextAttributes textAttributes;
        block3: {
            Color it;
            Intrinsics.checkNotNullParameter((Object)$this$withAlpha, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            TextAttributes textAttributes2 = $this$withAlpha.clone();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"clone(...)");
            TextAttributes attributes = textAttributes = textAttributes2;
            boolean bl = false;
            Color color = scheme.getColor(EditorColors.CARET_ROW_COLOR);
            if (color == null) {
                Color color2 = scheme.getDefaultBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
            }
            Color background = color;
            Color color3 = attributes.getForegroundColor();
            if (color3 != null) {
                it = color3;
                boolean bl2 = false;
                attributes.setForegroundColor(INSTANCE.on(it, background, alpha));
            }
            Color color4 = attributes.getBackgroundColor();
            if (color4 != null) {
                it = color4;
                boolean bl3 = false;
                attributes.setBackgroundColor(INSTANCE.on(it, background, alpha));
            }
            Color color5 = attributes.getEffectColor();
            if (color5 == null) break block3;
            it = color5;
            boolean bl4 = false;
            attributes.setEffectColor(INSTANCE.on(it, background, alpha));
        }
        return textAttributes;
    }

    public static /* synthetic */ TextAttributes withAlpha$default(MLCompletionHighlighterUtils mLCompletionHighlighterUtils, TextAttributes textAttributes, EditorColorsScheme editorColorsScheme, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 140;
        }
        return mLCompletionHighlighterUtils.withAlpha(textAttributes, editorColorsScheme, n);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final List<InlineCompletionElement> highlight(@NotNull Editor editor, int startOffset, @NotNull String suggestion, @NotNull List<HighlightedRange> additionalHighlights) {
        void $this$mapTo$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter(additionalHighlights, (String)"additionalHighlights");
        Object object = editor.getHighlighter();
        LexerEditorHighlighter lexerEditorHighlighter = object instanceof LexerEditorHighlighter ? (LexerEditorHighlighter)object : null;
        if (lexerEditorHighlighter == null) {
            return this.grayText(suggestion);
        }
        LexerEditorHighlighter highlighter = lexerEditorHighlighter;
        try {
            list = highlighter.getAttributesFor(editor.getDocument(), startOffset, (CharSequence)suggestion);
        }
        catch (Throwable e) {
            Promises.errorIfNotMessage((Logger)LOG, (Throwable)e);
            return this.grayText(suggestion);
        }
        object = list;
        Intrinsics.checkNotNull((Object)object);
        Object rangeAttributes = object;
        Iterable $this$map$iv = (Iterable)rangeAttributes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)pair);
            TextRange range = (TextRange)ExtensionsKt.component1((Pair)pair);
            TextAttributes attributes = (TextAttributes)ExtensionsKt.component2((Pair)pair);
            String string = suggestion.substring(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Intrinsics.checkNotNull((Object)attributes);
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            collection.add(new InlineCompletionTextElement(string, INSTANCE.mute(attributes, editorColorsScheme)));
        }
        List baseHighlighted = (List)destination$iv$iv;
        try {
            list = this.extend(baseHighlighted, editor, startOffset, additionalHighlights);
        }
        catch (Throwable e) {
            Promises.errorIfNotMessage((Logger)LOG, (Throwable)e);
            list = baseHighlighted;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineCompletionElement> extend(List<? extends InlineCompletionElement> $this$extend, Editor editor, int startOffset, List<HighlightedRange> additionalHighlights) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        HighlightedRange it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (additionalHighlights.isEmpty()) {
            return $this$extend;
        }
        Iterable iterable = additionalHighlights;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (HighlightedRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightedRange(INSTANCE.safeShiftLeft(it.getAbsoluteLocation(), startOffset), it.getAttributes()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HighlightedRange)element$iv$iv;
            boolean bl = false;
            if (!(!it.getAbsoluteLocation().isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it2 = (List)destination$iv$iv;
        boolean bl = false;
        List<HighlightedRange> ranges = HighlightRangesNormalizer.INSTANCE.normalize$intellij_ml_inline_completion(it2);
        int offset = 0;
        List elements = CollectionsKt.toMutableList((Collection)$this$extend);
        Ref.IntRef elementIndex = new Ref.IntRef();
        List result = new ArrayList();
        for (HighlightedRange range : ranges) {
            InlineCompletionElementManipulator manipulator2;
            while (elementIndex.element < elements.size() && offset + MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().length() <= range.getAbsoluteLocation().getStartOffset()) {
                offset += MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().length();
                ((Collection)result).add(MLCompletionHighlighterUtils.extend$element(elements, elementIndex));
                int element$iv$iv = elementIndex.element;
                elementIndex.element = element$iv$iv + 1;
            }
            if (elementIndex.element == elements.size()) break;
            Intrinsics.checkNotNull((Object)InlineCompletionElementManipulator.Companion.getApplicable(MLCompletionHighlighterUtils.extend$element(elements, elementIndex)));
            boolean bl2 = false;
            UtilKt.addIfNotNull((List)result, (Object)manipulator2.substring(MLCompletionHighlighterUtils.extend$element(elements, elementIndex), 0, range.getAbsoluteLocation().getStartOffset() - offset));
            int n = elementIndex.element;
            InlineCompletionElement inlineCompletionElement = manipulator2.substring(MLCompletionHighlighterUtils.extend$element(elements, elementIndex), range.getAbsoluteLocation().getStartOffset() - offset, MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().length());
            Intrinsics.checkNotNull((Object)inlineCompletionElement);
            elements.set(n, inlineCompletionElement);
            offset = range.getAbsoluteLocation().getStartOffset();
            StringBuilder newText = new StringBuilder();
            while (elementIndex.element < elements.size() && offset + MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().length() <= range.getAbsoluteLocation().getEndOffset()) {
                offset += MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().length();
                newText.append(MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText());
                int manipulator2 = elementIndex.element;
                elementIndex.element = manipulator2 + 1;
            }
            if (elementIndex.element < elements.size()) {
                InlineCompletionElementManipulator manipulator3;
                String string = MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().substring(0, range.getAbsoluteLocation().getEndOffset() - offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                newText.append(string);
                Intrinsics.checkNotNull((Object)InlineCompletionElementManipulator.Companion.getApplicable(MLCompletionHighlighterUtils.extend$element(elements, elementIndex)));
                int n2 = elementIndex.element;
                InlineCompletionElement inlineCompletionElement2 = manipulator3.substring(MLCompletionHighlighterUtils.extend$element(elements, elementIndex), range.getAbsoluteLocation().getEndOffset() - offset, MLCompletionHighlighterUtils.extend$element(elements, elementIndex).getText().length());
                Intrinsics.checkNotNull((Object)inlineCompletionElement2);
                elements.set(n2, inlineCompletionElement2);
                offset = range.getAbsoluteLocation().getEndOffset();
            }
            object = result;
            String string = newText.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            TextAttributes textAttributes = range.getAttributes();
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            object.add(new InlineCompletionTextElement(string, this.mute(textAttributes, editorColorsScheme)));
        }
        while (elementIndex.element < elements.size()) {
            ((Collection)result).add(MLCompletionHighlighterUtils.extend$element(elements, elementIndex));
            int n = elementIndex.element;
            elementIndex.element = n + 1;
        }
        return result;
    }

    private final List<InlineCompletionElement> grayText(String suggestion) {
        return CollectionsKt.listOf((Object)new InlineCompletionGrayTextElement(suggestion));
    }

    private final TextRange safeShiftLeft(TextRange $this$safeShiftLeft, int delta) {
        return new TextRange(RangesKt.coerceAtLeast((int)($this$safeShiftLeft.getStartOffset() - delta), (int)0), RangesKt.coerceAtLeast((int)($this$safeShiftLeft.getEndOffset() - delta), (int)0));
    }

    private final TextAttributes mute(TextAttributes $this$mute, EditorColorsScheme scheme) {
        return MLCompletionHighlighterUtils.withAlpha$default(this, this.withDefaults($this$mute, scheme), scheme, 0, 2, null);
    }

    private final TextAttributes withDefaults(TextAttributes $this$withDefaults, EditorColorsScheme scheme) {
        TextAttributes textAttributes;
        block2: {
            TextAttributes textAttributes2 = $this$withDefaults.clone();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"clone(...)");
            TextAttributes attributes = textAttributes = textAttributes2;
            boolean bl = false;
            Color color = attributes.getForegroundColor();
            if (color == null) {
                Color color2 = scheme.getDefaultForeground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
            }
            attributes.setForegroundColor(color);
            if (attributes.getFontType() != 0) break block2;
            TextAttributes textAttributes3 = scheme.getAttributes(HighlighterColors.TEXT);
            if (textAttributes3 != null) {
                TextAttributes it = textAttributes3;
                boolean bl2 = false;
                attributes.setFontType(it.getFontType());
            }
        }
        return textAttributes;
    }

    private final Color on(Color $this$on, Color background, int alpha) {
        return new Color(MLCompletionHighlighterUtils.on$on($this$on.getRed(), alpha, background.getRed()), MLCompletionHighlighterUtils.on$on($this$on.getGreen(), alpha, background.getGreen()), MLCompletionHighlighterUtils.on$on($this$on.getBlue(), alpha, background.getBlue()));
    }

    private static final InlineCompletionElement extend$element(List<InlineCompletionElement> elements, Ref.IntRef elementIndex) {
        return elements.get(elementIndex.element);
    }

    private static final int on$on(int $this$on_u24on, int $alpha, int x) {
        return ($this$on_u24on * $alpha + x * (255 - $alpha)) / 255;
    }

    static {
        MLCompletionHighlighterUtils $this$thisLogger$iv = INSTANCE = new MLCompletionHighlighterUtils();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(MLCompletionHighlighterUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

