/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimEmptyLinesAtStartTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "isCurrentLineEmpty", "", "()Z", "isCurrentLineEmpty$delegate", "Lkotlin/Lazy;", "removeBlankLinesIfNeeded", "", "transform", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "intellij.ml.inline.completion"})
public final class TrimEmptyLinesAtStartTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    private final Document document;
    private final int offset;
    @NotNull
    private final Lazy isCurrentLineEmpty$delegate;

    public TrimEmptyLinesAtStartTransformer(@NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super("Trim empty lines at the start");
        this.document = document;
        this.offset = offset;
        this.isCurrentLineEmpty$delegate = LazyKt.lazy(() -> TrimEmptyLinesAtStartTransformer.isCurrentLineEmpty_delegate$lambda$0(this));
    }

    private final boolean isCurrentLineEmpty() {
        Lazy lazy = this.isCurrentLineEmpty$delegate;
        return (Boolean)lazy.getValue();
    }

    private final String removeBlankLinesIfNeeded(String $this$removeBlankLinesIfNeeded) {
        if (!this.isCurrentLineEmpty()) {
            return $this$removeBlankLinesIfNeeded;
        }
        List suggestionLines = CollectionsKt.toMutableList((Collection)StringsKt.lines((CharSequence)$this$removeBlankLinesIfNeeded));
        while (true) {
            String string = (String)CollectionsKt.firstOrNull((List)suggestionLines);
            boolean bl = string != null ? StringsKt.isBlank((CharSequence)string) : false;
            if (!bl) break;
            CollectionsKt.removeFirst((List)suggestionLines);
        }
        return CollectionsKt.joinToString$default((Iterable)suggestionLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transform(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return this.diagnoseMapping(proposal, (Function0<RawMLCompletionProposal>)((Function0)() -> TrimEmptyLinesAtStartTransformer.transform$lambda$1(proposal, this)));
    }

    private static final boolean isCurrentLineEmpty_delegate$lambda$0(TrimEmptyLinesAtStartTransformer this$0) {
        int line = this$0.document.getLineNumber(this$0.offset);
        TextRange textRange = DocumentUtil.getLineTextRange((Document)this$0.document, (int)line);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getLineTextRange(...)");
        TextRange lineRange = textRange;
        String string = this$0.document.getText(lineRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)string);
    }

    private static final RawMLCompletionProposal transform$lambda$1(RawMLCompletionProposal $proposal, TrimEmptyLinesAtStartTransformer this$0) {
        return $proposal.withSuggestion(this$0.removeBlankLinesIfNeeded($proposal.getSuggestion()));
    }
}

