/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.attestation.statement.TPMGenerated;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMISTAttest;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMSCertifyInfo;
import com.webauthn4j.data.attestation.statement.TPMSClockInfo;
import com.webauthn4j.data.attestation.statement.TPMTHA;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.util.UnsignedNumberUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TPMSAttestDeserializer
extends StdDeserializer<TPMSAttest> {
    public TPMSAttestDeserializer() {
        super(TPMSAttest.class);
    }

    public @NonNull TPMSAttest deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        ByteBuffer buffer = ByteBuffer.wrap(value);
        byte[] magicBytes = new byte[4];
        buffer.get(magicBytes);
        TPMGenerated magic = TPMGenerated.create(magicBytes);
        byte[] typeBytes = new byte[2];
        buffer.get(typeBytes);
        TPMISTAttest type = TPMISTAttest.create(typeBytes);
        int qualifiedSignerSize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
        byte[] qualifiedSigner = new byte[qualifiedSignerSize];
        buffer.get(qualifiedSigner);
        int extraDataSize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
        byte[] extraData = new byte[extraDataSize];
        buffer.get(extraData);
        TPMSClockInfo clock = this.extractClockInfo(buffer);
        BigInteger firmwareVersion = UnsignedNumberUtil.getUnsignedLong((ByteBuffer)buffer);
        TPMUAttest attested = this.extractTPMUAttest(type, buffer);
        if (buffer.remaining() > 0) {
            throw new InvalidFormatException(p, "input byte array contains surplus data", (Object)value, TPMTPublic.class);
        }
        return new TPMSAttest(magic, type, qualifiedSigner, extraData, clock, firmwareVersion, attested);
    }

    private @NonNull TPMSClockInfo extractClockInfo(@NonNull ByteBuffer buffer) {
        BigInteger clock = UnsignedNumberUtil.getUnsignedLong((ByteBuffer)buffer);
        long resetCount = UnsignedNumberUtil.getUnsignedInt((ByteBuffer)buffer);
        long restartCount = UnsignedNumberUtil.getUnsignedInt((ByteBuffer)buffer);
        boolean safe = buffer.get() != 0;
        return new TPMSClockInfo(clock, resetCount, restartCount, safe);
    }

    private @NonNull TPMUAttest extractTPMUAttest(@NonNull TPMISTAttest type, @NonNull ByteBuffer buffer) {
        if (type != TPMISTAttest.TPM_ST_ATTEST_CERTIFY) {
            throw new NotImplementedException();
        }
        int nameSize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
        TPMTHA name = this.extractTPMTHA(buffer, nameSize - 2);
        int qualifiedNameSize = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer);
        TPMTHA qualifiedName = this.extractTPMTHA(buffer, qualifiedNameSize - 2);
        return new TPMSCertifyInfo(name, qualifiedName);
    }

    private @NonNull TPMTHA extractTPMTHA(@NonNull ByteBuffer buffer, int digestLength) {
        TPMIAlgHash hashAlg = TPMIAlgHash.create(UnsignedNumberUtil.getUnsignedShort((ByteBuffer)buffer));
        byte[] digest = new byte[digestLength];
        buffer.get(digest);
        return new TPMTHA(hashAlg, digest);
    }
}

