/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.TokenList;

public final class ExpressionCardinality
extends Expression {
    private Expression subExpression;
    private boolean atLeastOne = false;
    private boolean atMostOne = true;

    public ExpressionCardinality(Expression subExpression, boolean atLeastOne, boolean atMostOne) {
        this.subExpression = subExpression;
        this.atLeastOne = atLeastOne;
        this.atMostOne = atMostOne;
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList tokenList) {
        ASTNode cr;
        TokenList list = tokenList;
        ASTNode node = new ASTNode();
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        ArrayList<Object> values = new ArrayList<Object>();
        while ((cr = this.subExpression.parse(language, list)).isSuccess()) {
            nodes.add(cr);
            values.add(cr.getValue());
            list = cr.getRemainingTokens();
            if (this.atMostOne) break;
        }
        if (!this.atLeastOne || !nodes.isEmpty()) {
            node.setChildren(nodes.toArray(new ASTNode[0]));
            node.setRemainingTokens(list);
            node.setSuccess(true);
            node.setValue(this.atMostOne ? (values.isEmpty() ? null : values.get(0)) : values.toArray());
            this.generateValue(node);
        }
        return node;
    }

    @Override
    List<Expression> getChildExpressions() {
        return List.of(this.subExpression);
    }

    @Override
    boolean collectFirsts(ResourceBundle language, Set<String> firsts) {
        return this.subExpression.collectFirsts(language, firsts) || this.atLeastOne;
    }

    public String toString() {
        return "cardinal(" + this.atLeastOne + ", " + this.atMostOne + "' " + this.subExpression.toString() + ")";
    }

    public Expression getSubExpression() {
        return this.subExpression;
    }

    public boolean isAtLeastOne() {
        return this.atLeastOne;
    }

    public boolean isAtMostOne() {
        return this.atMostOne;
    }
}

