/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXPort;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.serial.PortInUseException;
import org.openhab.core.io.transport.serial.SerialPort;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.rxtx.RxTxSerialPort;

@NonNullByDefault
public class SerialPortIdentifierImpl
implements SerialPortIdentifier {
    final CommPortIdentifier id;

    public SerialPortIdentifierImpl(CommPortIdentifier id) {
        this.id = id;
    }

    public String getName() {
        String name = this.id.getName();
        return name != null ? name : "";
    }

    /*
     * WARNING - void declaration
     */
    public SerialPort open(String owner, int timeout) throws PortInUseException {
        try {
            RXTXPort cp;
            RXTXPort rXTXPort = cp = this.id.open(owner, timeout);
            if (rXTXPort instanceof gnu.io.SerialPort) {
                void port;
                gnu.io.SerialPort serialPort = (gnu.io.SerialPort)rXTXPort;
                gnu.io.SerialPort cfr_ignored_0 = (gnu.io.SerialPort)rXTXPort;
                return new RxTxSerialPort((gnu.io.SerialPort)port);
            }
            throw new IllegalStateException(String.format("We expect a serial port instead of '%s'", cp.getClass()));
        }
        catch (gnu.io.PortInUseException e) {
            String message = e.getMessage();
            if (message != null) {
                throw new PortInUseException(message, (Exception)((Object)e));
            }
            throw new PortInUseException((Exception)((Object)e));
        }
    }

    public boolean isCurrentlyOwned() {
        return this.id.isCurrentlyOwned();
    }

    public @Nullable String getCurrentOwner() {
        return this.id.getCurrentOwner();
    }
}

