/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.file;

import java.io.File;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.internal.provider.file.AbstractFileProvider;
import org.openhab.core.service.WatchService;

@NonNullByDefault
public class AutomationWatchService
implements WatchService.WatchEventListener {
    private final WatchService watchService;
    private final Path watchingDir;
    private AbstractFileProvider provider;

    public AutomationWatchService(AbstractFileProvider provider, WatchService watchService, String watchingDir) {
        this.watchService = watchService;
        this.watchingDir = Path.of(watchingDir, new String[0]);
        this.provider = provider;
    }

    public void activate() {
        this.watchService.registerListener((WatchService.WatchEventListener)this, this.watchingDir);
    }

    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public Path getSourcePath() {
        return this.watchingDir;
    }

    public void processWatchEvent(WatchService.Kind kind, Path path) {
        File file = path.toFile();
        if (!file.isHidden()) {
            if (kind == WatchService.Kind.DELETE) {
                this.provider.removeResources(file);
            } else if (file.canRead()) {
                this.provider.importResources(file);
            }
        }
    }
}

