/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.serial.PortInUseException;
import org.openhab.core.io.transport.serial.SerialPort;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.internal.SerialPortImpl;

@NonNullByDefault
public class SerialPortIdentifierImpl
implements SerialPortIdentifier {
    final CommPortIdentifier id;

    public SerialPortIdentifierImpl(CommPortIdentifier id) {
        this.id = id;
    }

    public String getName() {
        String name = this.id.getName();
        return name != null ? name : "";
    }

    /*
     * WARNING - void declaration
     */
    public SerialPort open(String owner, int timeout) throws PortInUseException {
        try {
            CommPort cp;
            CommPort commPort = cp = this.id.open(owner, timeout);
            if (commPort instanceof javax.comm.SerialPort) {
                void port;
                javax.comm.SerialPort serialPort = (javax.comm.SerialPort)commPort;
                javax.comm.SerialPort cfr_ignored_0 = (javax.comm.SerialPort)commPort;
                return new SerialPortImpl((javax.comm.SerialPort)port);
            }
            throw new IllegalStateException(String.format("We expect a serial port instead of '%s'", cp.getClass()));
        }
        catch (javax.comm.PortInUseException e) {
            String message = e.getMessage();
            if (message != null) {
                throw new PortInUseException(message, (Exception)((Object)e));
            }
            throw new PortInUseException((Exception)((Object)e));
        }
    }

    public boolean isCurrentlyOwned() {
        return this.id.isCurrentlyOwned();
    }

    public @Nullable String getCurrentOwner() {
        return this.id.getCurrentOwner();
    }
}

