/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.checkpoint.Confirmable;
import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishConfirmable;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingQosHandler;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttStatefulPublishWithFlows;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.util.collections.ChunkedArrayQueue;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import org.jetbrains.annotations.NotNull;

@ClientScope
class MqttIncomingPublishService {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttIncomingPublishService.class);
    private static final boolean QOS_0_DROP_OLDEST = true;
    @NotNull
    private final MqttIncomingQosHandler incomingQosHandler;
    @NotNull
    final MqttIncomingPublishFlows incomingPublishFlows;
    @NotNull
    private final ChunkedArrayQueue<MqttStatefulPublishWithFlows> qos0Queue = new ChunkedArrayQueue(32);
    private final @NotNull ChunkedArrayQueue.Iterator qos0It = this.qos0Queue.iterator();
    @NotNull
    private final ChunkedArrayQueue<MqttStatefulPublishWithFlows> qos1Or2Queue = new ChunkedArrayQueue(32);
    private final @NotNull ChunkedArrayQueue.Iterator qos1Or2It = this.qos1Or2Queue.iterator();
    private long nextQoS1Or2PublishId = 1L;
    private int referencedFlowCount;
    private int runIndex;
    private int blockingFlowCount;

    MqttIncomingPublishService(@NotNull MqttIncomingQosHandler incomingQosHandler, @NotNull MqttIncomingPublishFlows incomingPublishFlows) {
        this.incomingQosHandler = incomingQosHandler;
        this.incomingPublishFlows = incomingPublishFlows;
    }

    @CallByThread(value="Netty EventLoop")
    void onPublishQos0(@NotNull MqttStatefulPublishWithFlows publishWithFlows, int receiveMaximum) {
        if (this.qos0Queue.size() >= receiveMaximum) {
            LOGGER.warn("QoS 0 publish message dropped.");
            this.qos0It.reset();
            MqttStatefulPublishWithFlows flows = (MqttStatefulPublishWithFlows)this.qos0It.next();
            this.qos0It.remove();
            for (HandleList.Handle h = (HandleList.Handle)flows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
                if (((MqttIncomingPublishFlow)h.getElement()).dereference() != 0) continue;
                --this.referencedFlowCount;
            }
        }
        this.onPublish(publishWithFlows);
        if (!publishWithFlows.isEmpty()) {
            this.qos0Queue.offer(publishWithFlows);
        }
    }

    @CallByThread(value="Netty EventLoop")
    boolean onPublishQos1Or2(@NotNull MqttStatefulPublishWithFlows publishWithFlows, int receiveMaximum) {
        if (this.qos1Or2Queue.size() >= receiveMaximum) {
            return false;
        }
        publishWithFlows.id = this.nextQoS1Or2PublishId++;
        this.onPublish(publishWithFlows);
        if (this.qos1Or2Queue.isEmpty() && publishWithFlows.isEmpty() && publishWithFlows.areAcknowledged()) {
            this.incomingQosHandler.ack(publishWithFlows);
        } else {
            this.qos1Or2Queue.offer(publishWithFlows);
        }
        return true;
    }

    @CallByThread(value="Netty EventLoop")
    private void onPublish(@NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        this.incomingPublishFlows.findMatching(publishWithFlows);
        if (publishWithFlows.isEmpty()) {
            LOGGER.warn("No publish flow registered for {}.", publishWithFlows.publish);
        }
        this.drain();
        for (HandleList.Handle h = (HandleList.Handle)publishWithFlows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            if (((MqttIncomingPublishFlow)h.getElement()).reference() != 1) continue;
            ++this.referencedFlowCount;
        }
        this.emit(publishWithFlows);
    }

    @CallByThread(value="Netty EventLoop")
    void drain() {
        MqttStatefulPublishWithFlows publishWithFlows;
        ++this.runIndex;
        this.blockingFlowCount = 0;
        this.qos1Or2It.reset();
        while (this.qos1Or2It.hasNext()) {
            publishWithFlows = (MqttStatefulPublishWithFlows)this.qos1Or2It.next();
            this.emit(publishWithFlows);
            if (this.qos1Or2It.getIterated() == 1 && publishWithFlows.isEmpty() && publishWithFlows.areAcknowledged()) {
                this.qos1Or2It.remove();
                this.incomingQosHandler.ack(publishWithFlows);
                continue;
            }
            if (this.blockingFlowCount != this.referencedFlowCount) continue;
            return;
        }
        this.qos0It.reset();
        while (this.qos0It.hasNext()) {
            publishWithFlows = (MqttStatefulPublishWithFlows)this.qos0It.next();
            this.emit(publishWithFlows);
            if (this.qos0It.getIterated() == 1 && publishWithFlows.isEmpty()) {
                this.qos0It.remove();
                continue;
            }
            if (this.blockingFlowCount != this.referencedFlowCount) continue;
            return;
        }
    }

    @CallByThread(value="Netty EventLoop")
    private void emit(@NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        for (HandleList.Handle h = (HandleList.Handle)publishWithFlows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            MqttIncomingPublishFlow flow = (MqttIncomingPublishFlow)h.getElement();
            if (flow.isCancelled()) {
                publishWithFlows.remove(h);
                if (flow.dereference() != 0) continue;
                --this.referencedFlowCount;
                continue;
            }
            long requested = flow.requested(this.runIndex);
            if (requested > 0L) {
                MqttPublish publish = (MqttPublish)publishWithFlows.publish.stateless();
                if (flow.manualAcknowledgement) {
                    Confirmable confirmable = publish.getQos() == MqttQos.AT_MOST_ONCE ? new MqttIncomingPublishConfirmable.Qos0() : new MqttIncomingPublishConfirmable(flow, publishWithFlows);
                    publish = publish.withConfirmable(confirmable);
                }
                flow.onNext(publish);
                publishWithFlows.remove(h);
                if (flow.dereference() != 0) continue;
                --this.referencedFlowCount;
                flow.checkDone();
                continue;
            }
            if (requested != 0L) continue;
            ++this.blockingFlowCount;
            if (this.blockingFlowCount == this.referencedFlowCount) break;
        }
    }
}

