/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.batch.MLBatchIngestionAction;
import org.opensearch.ml.common.transport.batch.MLBatchIngestionInput;
import org.opensearch.ml.common.transport.batch.MLBatchIngestionRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLBatchIngestAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLBatchIngestAction.class);
    private static final String ML_BATCH_INGESTION_ACTION = "ml_batch_ingestion_action";

    public String getName() {
        return ML_BATCH_INGESTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_batch_ingestion", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLBatchIngestionRequest mlBatchIngestTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLBatchIngestionAction.INSTANCE, (ActionRequest)mlBatchIngestTaskRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLBatchIngestionRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new IOException("Batch Ingestion request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLBatchIngestionInput mlBatchIngestionInput = MLBatchIngestionInput.parse((XContentParser)parser);
        return new MLBatchIngestionRequest(mlBatchIngestionInput);
    }
}

