/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.GetWorkflowStateAction;
import org.opensearch.flowframework.transport.GetWorkflowStateRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class WorkflowTimeoutUtility {
    private static final Logger logger = LogManager.getLogger(WorkflowTimeoutUtility.class);

    public static ActionListener<WorkflowResponse> scheduleTimeoutHandler(Client client, ThreadPool threadPool, String workflowId, String tenantId, ActionListener<WorkflowResponse> listener, long timeout, AtomicBoolean isResponseSent) {
        long adjustedTimeout = Math.max(timeout, TimeValue.timeValueMillis((long)0L).millis());
        Scheduler.ScheduledCancellable scheduledCancellable = threadPool.schedule((Runnable)new WorkflowTimeoutListener(client, workflowId, tenantId, listener, isResponseSent), TimeValue.timeValueMillis((long)adjustedTimeout), "opensearch_provision_workflow");
        return WorkflowTimeoutUtility.wrapWithTimeoutCancellationListener(listener, scheduledCancellable, isResponseSent);
    }

    public static <Response> ActionListener<Response> wrapWithTimeoutCancellationListener(final ActionListener<Response> listener, final Scheduler.ScheduledCancellable scheduledCancellable, final AtomicBoolean isResponseSent) {
        return new ActionListener<Response>(){

            public void onResponse(Response response) {
                if (isResponseSent.compareAndSet(false, true)) {
                    scheduledCancellable.cancel();
                }
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                if (isResponseSent.compareAndSet(false, true)) {
                    scheduledCancellable.cancel();
                }
                listener.onFailure(e);
            }
        };
    }

    public static void handleResponse(String workflowId, WorkflowResponse workflowResponse, AtomicBoolean isResponseSent, ActionListener<WorkflowResponse> listener) {
        if (isResponseSent.compareAndSet(false, true)) {
            listener.onResponse((Object)new WorkflowResponse(workflowResponse.getWorkflowId(), workflowResponse.getWorkflowState()));
        } else {
            logger.info("Ignoring onResponse for workflowId: {} as timeout already occurred", (Object)workflowId);
        }
    }

    public static void handleFailure(String workflowId, Exception e, AtomicBoolean isResponseSent, ActionListener<WorkflowResponse> listener) {
        if (isResponseSent.compareAndSet(false, true)) {
            FlowFrameworkException exception = new FlowFrameworkException("Failed to execute workflow " + workflowId, ExceptionsHelper.status((Throwable)e));
            listener.onFailure((Exception)((Object)exception));
        } else {
            logger.info("Ignoring onFailure for workflowId: {} as timeout already occurred", (Object)workflowId);
        }
    }

    public static void fetchWorkflowStateAfterTimeout(Client client, String workflowId, String tenantId, ActionListener<WorkflowResponse> listener) {
        logger.info("Fetching workflow state after timeout");
        client.execute((ActionType)GetWorkflowStateAction.INSTANCE, (ActionRequest)new GetWorkflowStateRequest(workflowId, false, tenantId), ActionListener.wrap(response -> listener.onResponse((Object)new WorkflowResponse(workflowId, response.getWorkflowState())), exception -> listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to get workflow state after timeout", ExceptionsHelper.status((Throwable)exception))))));
    }

    private static class WorkflowTimeoutListener
    implements Runnable {
        private final Client client;
        private final String workflowId;
        private final String tenantId;
        private final ActionListener<WorkflowResponse> listener;
        private final AtomicBoolean isResponseSent;

        WorkflowTimeoutListener(Client client, String workflowId, String tenantId, ActionListener<WorkflowResponse> listener, AtomicBoolean isResponseSent) {
            this.client = client;
            this.workflowId = workflowId;
            this.tenantId = tenantId;
            this.listener = listener;
            this.isResponseSent = isResponseSent;
        }

        @Override
        public void run() {
            if (this.isResponseSent.compareAndSet(false, true)) {
                logger.warn("Workflow execution timed out for workflowId: {}", (Object)this.workflowId);
                WorkflowTimeoutUtility.fetchWorkflowStateAfterTimeout(this.client, this.workflowId, this.tenantId, this.listener);
            }
        }
    }
}

