/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedSetStarTreeValuesIterator;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.ExactMatchDimFilter;
import org.opensearch.search.startree.filter.RangeMatchDimFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;

class KeywordFieldMapper
implements DimensionFilterMapper {
    KeywordFieldMapper() {
    }

    @Override
    public DimensionFilter getExactMatchFilter(MappedFieldType mappedFieldType, List<Object> rawValues) {
        KeywordFieldMapper.KeywordFieldType keywordFieldType = (KeywordFieldMapper.KeywordFieldType)mappedFieldType;
        ArrayList<Object> convertedValues = new ArrayList<Object>(rawValues.size());
        for (Object rawValue : rawValues) {
            convertedValues.add(this.parseRawKeyword(mappedFieldType.name(), rawValue, keywordFieldType));
        }
        return new ExactMatchDimFilter(mappedFieldType.name(), convertedValues);
    }

    @Override
    public DimensionFilter getRangeMatchFilter(MappedFieldType mappedFieldType, Object rawLow, Object rawHigh, boolean includeLow, boolean includeHigh) {
        KeywordFieldMapper.KeywordFieldType keywordFieldType = (KeywordFieldMapper.KeywordFieldType)mappedFieldType;
        return new RangeMatchDimFilter(mappedFieldType.name(), this.parseRawKeyword(mappedFieldType.name(), rawLow, keywordFieldType), this.parseRawKeyword(mappedFieldType.name(), rawHigh, keywordFieldType), includeLow, includeHigh);
    }

    @Override
    public Optional<Long> getMatchingOrdinal(String dimensionName, Object value, StarTreeValues starTreeValues, DimensionFilter.MatchType matchType) {
        SortedSetStarTreeValuesIterator sortedSetIterator = (SortedSetStarTreeValuesIterator)starTreeValues.getDimensionValuesIterator(dimensionName);
        try {
            if (matchType == DimensionFilter.MatchType.EXACT) {
                long ordinal = sortedSetIterator.lookupTerm((BytesRef)value);
                return ordinal >= 0L ? Optional.of(ordinal) : Optional.empty();
            }
            TermsEnum termsEnum = sortedSetIterator.termsEnum();
            TermsEnum.SeekStatus seekStatus = termsEnum.seekCeil((BytesRef)value);
            switch (matchType) {
                case GTE: {
                    return seekStatus == TermsEnum.SeekStatus.END ? Optional.empty() : Optional.of(termsEnum.ord());
                }
                case GT: {
                    switch (seekStatus) {
                        case END: {
                            return Optional.empty();
                        }
                        case FOUND: {
                            if (termsEnum.ord() + 1L < sortedSetIterator.getValueCount()) {
                                return Optional.of(termsEnum.ord() + 1L);
                            }
                            return Optional.empty();
                        }
                        case NOT_FOUND: {
                            return Optional.of(termsEnum.ord());
                        }
                    }
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(seekStatus));
                }
                case LTE: {
                    if (seekStatus == TermsEnum.SeekStatus.NOT_FOUND) {
                        return termsEnum.ord() - 1L >= 0L ? Optional.of(termsEnum.ord() - 1L) : Optional.empty();
                    }
                    return Optional.of(termsEnum.ord());
                }
                case LT: {
                    if (seekStatus == TermsEnum.SeekStatus.END) {
                        return Optional.of(termsEnum.ord());
                    }
                    return termsEnum.ord() - 1L >= 0L ? Optional.of(termsEnum.ord() - 1L) : Optional.empty();
                }
            }
            throw new IllegalStateException("unexpected matchType " + String.valueOf((Object)matchType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object parseRawKeyword(String field, Object rawValue, KeywordFieldMapper.KeywordFieldType keywordFieldType) {
        BytesRef parsedValue = null;
        if (rawValue != null) {
            if (keywordFieldType.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                parsedValue = BytesRefs.toBytesRef(rawValue);
            } else {
                if (rawValue instanceof BytesRef) {
                    rawValue = ((BytesRef)rawValue).utf8ToString();
                }
                parsedValue = keywordFieldType.getTextSearchInfo().getSearchAnalyzer().normalize(field, rawValue.toString());
            }
        }
        return parsedValue;
    }
}

