/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.Map;
import java.util.Set;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.stats.InternalStatNames;
import org.opensearch.timeseries.transport.BaseStatsNodesTransportAction;
import org.opensearch.timeseries.transport.StatsNodeResponse;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.transport.TransportService;

public class ADStatsNodesTransportAction
extends BaseStatsNodesTransportAction {
    private final JvmService jvmService;
    private final ADTaskManager adTaskManager;

    @Inject
    public ADStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ADStats adStats, JvmService jvmService, ADTaskManager adTaskManager) {
        super(threadPool, clusterService, transportService, actionFilters, adStats, ADStatsNodesAction.NAME);
        this.jvmService = jvmService;
        this.adTaskManager = adTaskManager;
    }

    @Override
    protected StatsNodeResponse createADStatsNodeResponse(StatsRequest adStatsRequest) {
        Map<String, Object> statValues = super.createADStatsNodeResponse(adStatsRequest).getStatsMap();
        Set<String> statsToBeRetrieved = adStatsRequest.getStatsToBeRetrieved();
        if (statsToBeRetrieved.contains(InternalStatNames.JVM_HEAP_USAGE.getName())) {
            long heapUsedPercent = this.jvmService.stats().getMem().getHeapUsedPercent();
            statValues.put(InternalStatNames.JVM_HEAP_USAGE.getName(), heapUsedPercent);
        }
        if (statsToBeRetrieved.contains(InternalStatNames.AD_USED_BATCH_TASK_SLOT_COUNT.getName())) {
            int usedTaskSlot = this.adTaskManager.getLocalAdUsedBatchTaskSlot();
            statValues.put(InternalStatNames.AD_USED_BATCH_TASK_SLOT_COUNT.getName(), usedTaskSlot);
        }
        if (statsToBeRetrieved.contains(InternalStatNames.AD_DETECTOR_ASSIGNED_BATCH_TASK_SLOT_COUNT.getName())) {
            int assignedBatchTaskSlot = this.adTaskManager.getLocalAdAssignedBatchTaskSlot();
            statValues.put(InternalStatNames.AD_DETECTOR_ASSIGNED_BATCH_TASK_SLOT_COUNT.getName(), assignedBatchTaskSlot);
        }
        return new StatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

