/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.p3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.primavera.common.ColumnDefinition;
import net.sf.mpxj.primavera.common.RowValidator;
import net.sf.mpxj.primavera.common.Table;
import net.sf.mpxj.primavera.common.TableDefinition;

class TableReader {
    private final TableDefinition m_definition;

    public TableReader(TableDefinition tableDefinition) {
        this.m_definition = tableDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, Table table) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.read(fileInputStream, table);
        }
        catch (Throwable throwable) {
            StreamHelper.closeQuietly(fileInputStream);
            throw throwable;
        }
        StreamHelper.closeQuietly(fileInputStream);
    }

    private void read(InputStream inputStream, Table table) throws IOException {
        int n;
        byte[] byArray = new byte[this.m_definition.getPageSize()];
        while ((n = inputStream.read(byArray)) != -1) {
            if (n != byArray.length) {
                throw new IOException("Unexpected end of file");
            }
            this.readPage(byArray, table);
        }
    }

    private void readPage(byte[] byArray, Table table) {
        int n = this.getShort(byArray, 0);
        if (n == 17408) {
            int n2 = this.m_definition.getRecordSize();
            RowValidator rowValidator = this.m_definition.getRowValidator();
            String string = this.m_definition.getPrimaryKeyColumnName();
            int n3 = 6;
            while (n3 + n2 <= byArray.length) {
                int n4 = this.getShort(byArray, n3);
                if (n4 != 0) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("ROW_VERSION", n4);
                    for (ColumnDefinition columnDefinition : this.m_definition.getColumns()) {
                        Object object = columnDefinition.read(n3, byArray);
                        hashMap.put(columnDefinition.getName(), object);
                    }
                    if (rowValidator == null || rowValidator.validRow(hashMap)) {
                        table.addRow(string, hashMap);
                    }
                }
                n3 += n2;
            }
        }
    }

    private int getShort(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 16; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }
}

