/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Utils;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlRendererOptions {
    @NotNull
    public final String softBreak;
    public final boolean isSoftBreakAllSpaces;
    @NotNull
    public final String hardBreak;
    @Nullable
    public final String strongEmphasisStyleHtmlOpen;
    @Nullable
    public final String strongEmphasisStyleHtmlClose;
    @Nullable
    public final String emphasisStyleHtmlOpen;
    @Nullable
    public final String emphasisStyleHtmlClose;
    @Nullable
    public final String codeStyleHtmlOpen;
    @Nullable
    public final String codeStyleHtmlClose;
    public final boolean escapeHtmlBlocks;
    public final boolean escapeHtmlCommentBlocks;
    public final boolean escapeInlineHtml;
    public final boolean escapeInlineHtmlComments;
    public final boolean percentEncodeUrls;
    public final int indentSize;
    public final boolean suppressHtmlBlocks;
    public final boolean suppressHtmlCommentBlocks;
    public final boolean suppressInlineHtml;
    public final boolean suppressInlineHtmlComments;
    public final boolean doNotRenderLinksInDocument;
    public final boolean renderHeaderId;
    public final boolean generateHeaderIds;
    @NotNull
    public final String languageClassPrefix;
    @NotNull
    public final HashMap<String, String> languageClassMap;
    @NotNull
    public final String languageDelimiters;
    public final CharPredicate languageDelimiterSet;
    @NotNull
    public final String noLanguageClass;
    @NotNull
    public final String sourcePositionAttribute;
    @Nullable
    public final String inlineCodeSpliceClass;
    public final boolean sourcePositionParagraphLines;
    public final boolean sourceWrapHtmlBlocks;
    public final int formatFlags;
    public final int maxTrailingBlankLines;
    public final int maxBlankLines;
    public final boolean htmlBlockOpenTagEol;
    public final boolean htmlBlockCloseTagEol;
    public final boolean unescapeHtmlEntities;
    public final boolean noPTagsUseBr;
    @NotNull
    public final String autolinkWwwPrefix;
    @Nullable
    public final Pattern suppressedLinks;

    public HtmlRendererOptions(DataHolder options) {
        this.softBreak = HtmlRenderer.SOFT_BREAK.get(options);
        this.isSoftBreakAllSpaces = Utils.isWhiteSpaceNoEOL(this.softBreak);
        this.hardBreak = HtmlRenderer.HARD_BREAK.get(options);
        this.strongEmphasisStyleHtmlOpen = HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_OPEN.get(options);
        this.strongEmphasisStyleHtmlClose = HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_CLOSE.get(options);
        this.emphasisStyleHtmlOpen = HtmlRenderer.EMPHASIS_STYLE_HTML_OPEN.get(options);
        this.emphasisStyleHtmlClose = HtmlRenderer.EMPHASIS_STYLE_HTML_CLOSE.get(options);
        this.codeStyleHtmlOpen = HtmlRenderer.CODE_STYLE_HTML_OPEN.get(options);
        this.codeStyleHtmlClose = HtmlRenderer.CODE_STYLE_HTML_CLOSE.get(options);
        this.escapeHtmlBlocks = HtmlRenderer.ESCAPE_HTML_BLOCKS.get(options);
        this.escapeHtmlCommentBlocks = HtmlRenderer.ESCAPE_HTML_COMMENT_BLOCKS.get(options);
        this.escapeInlineHtml = HtmlRenderer.ESCAPE_INLINE_HTML.get(options);
        this.escapeInlineHtmlComments = HtmlRenderer.ESCAPE_INLINE_HTML_COMMENTS.get(options);
        this.percentEncodeUrls = HtmlRenderer.PERCENT_ENCODE_URLS.get(options);
        this.indentSize = HtmlRenderer.INDENT_SIZE.get(options);
        this.suppressHtmlBlocks = HtmlRenderer.SUPPRESS_HTML_BLOCKS.get(options);
        this.suppressHtmlCommentBlocks = HtmlRenderer.SUPPRESS_HTML_COMMENT_BLOCKS.get(options);
        this.suppressInlineHtml = HtmlRenderer.SUPPRESS_INLINE_HTML.get(options);
        this.suppressInlineHtmlComments = HtmlRenderer.SUPPRESS_INLINE_HTML_COMMENTS.get(options);
        this.doNotRenderLinksInDocument = HtmlRenderer.DO_NOT_RENDER_LINKS.get(options);
        this.renderHeaderId = HtmlRenderer.RENDER_HEADER_ID.get(options);
        this.generateHeaderIds = HtmlRenderer.GENERATE_HEADER_ID.get(options);
        this.languageClassPrefix = HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX.get(options);
        this.languageClassMap = HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_MAP.get(options);
        this.languageDelimiters = HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS.get(options);
        this.languageDelimiterSet = CharPredicate.anyOf(this.languageDelimiters);
        this.noLanguageClass = HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS.get(options);
        this.sourcePositionAttribute = HtmlRenderer.SOURCE_POSITION_ATTRIBUTE.get(options);
        this.sourcePositionParagraphLines = !this.sourcePositionAttribute.isEmpty() && HtmlRenderer.SOURCE_POSITION_PARAGRAPH_LINES.get(options) != false;
        this.sourceWrapHtmlBlocks = !this.sourcePositionAttribute.isEmpty() && HtmlRenderer.SOURCE_WRAP_HTML_BLOCKS.get(options) != false;
        this.formatFlags = HtmlRenderer.FORMAT_FLAGS.get(options);
        this.maxTrailingBlankLines = HtmlRenderer.MAX_TRAILING_BLANK_LINES.get(options);
        this.maxBlankLines = HtmlRenderer.MAX_BLANK_LINES.get(options);
        this.htmlBlockOpenTagEol = HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL.get(options);
        this.htmlBlockCloseTagEol = HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL.get(options);
        this.unescapeHtmlEntities = HtmlRenderer.UNESCAPE_HTML_ENTITIES.get(options);
        this.noPTagsUseBr = HtmlRenderer.NO_P_TAGS_USE_BR.get(options);
        this.inlineCodeSpliceClass = HtmlRenderer.INLINE_CODE_SPLICE_CLASS.get(options);
        this.autolinkWwwPrefix = HtmlRenderer.AUTOLINK_WWW_PREFIX.get(options);
        String ignoreLinks = HtmlRenderer.SUPPRESSED_LINKS.get(options);
        this.suppressedLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
    }
}

