/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.dialog;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.model.DependencyKt;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelImpl;
import com.intellij.packageChecker.service.IgnorableDependenciesServiceKt;
import com.intellij.packageChecker.service.IgnoreReason;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.TextAreaKt;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/packageChecker/toolwindow/dialog/IgnoreVulnerabilitiesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "pkg", "Lorg/jetbrains/security/package/Package;", "moduleName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/security/package/Package;Ljava/lang/String;)V", "reasonIgnoring", "doOKAction", "", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nIgnoreVulnerabilitiesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreVulnerabilitiesDialog.kt\ncom/intellij/packageChecker/toolwindow/dialog/IgnoreVulnerabilitiesDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n31#2,2:74\n*S KotlinDebug\n*F\n+ 1 IgnoreVulnerabilitiesDialog.kt\ncom/intellij/packageChecker/toolwindow/dialog/IgnoreVulnerabilitiesDialog\n*L\n37#1:74,2\n*E\n"})
public final class IgnoreVulnerabilitiesDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Package pkg;
    @NotNull
    private final String moduleName;
    @NotNull
    private String reasonIgnoring;

    public IgnoreVulnerabilitiesDialog(@NotNull Project project, @NotNull Package pkg, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        super(project, null, false, DialogWrapper.IdeModalityType.MODELESS, true);
        this.project = project;
        this.pkg = pkg;
        this.moduleName = moduleName;
        this.reasonIgnoring = "";
        this.setTitle(PackageCheckerBundle.message("ignoreVulnerabilities.dialog.title", new Object[0]));
        this.setCancelButtonText(CommonBundle.getCancelButtonText());
        this.setOKButtonText(PackageCheckerBundle.message("ignoreVulnerabilities.dialog.ignore", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        super.doOKAction();
        if (StringsKt.isBlank((CharSequence)this.reasonIgnoring)) {
            this.reasonIgnoring = IgnoreReason.NOT_EXPLOITABLE.getTitle().get();
        }
        IgnorableDependenciesServiceKt.ignoreVulnerability(this.project, this.pkg, this.moduleName, this.reasonIgnoring);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectDependenciesModelImpl> serviceClass$iv = ProjectDependenciesModelImpl.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ProjectDependenciesModelImpl)object).refresh(this.project);
    }

    @NlsSafe
    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7(this, arg_0));
    }

    private static final Unit createCenterPanel$lambda$7$lambda$0(IgnoreVulnerabilitiesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PackageCheckerBundle.message("ignoreVulnerabilities.dialog.packageTitle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        $this$row.label(DependencyKt.simplifiedCoordinates(this$0.pkg));
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$7$lambda$3$lambda$2$lambda$1(IgnoreVulnerabilitiesDialog this$0) {
        this$0.validate();
        this$0.pack();
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3$lambda$2(IgnoreVulnerabilitiesDialog this$0, AtomicBooleanProperty $isOtherReason, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reasonIgnoring = (String)it.getItem();
        $isOtherReason.set(Intrinsics.areEqual((Object)this$0.reasonIgnoring, (Object)IgnoreReason.OTHER.getTitle().get()));
        if (!$isOtherReason.get().booleanValue()) {
            ApplicationManager.getApplication().invokeLater(() -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7$lambda$3$lambda$2$lambda$1(this$0), this$0.project.getDisposed());
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3(IgnoreVulnerabilitiesDialog this$0, AtomicBooleanProperty $isOtherReason, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PackageCheckerBundle.message("ignoreVulnerabilities.dialog.reasonTitle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        Row.comboBox$default((Row)$this$row, (Collection)IgnoreReason.Companion.localizedReasons(), null, (int)2, null).onChanged(arg_0 -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7$lambda$3$lambda$2(this$0, $isOtherReason, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PackageCheckerBundle.message("ignoreVulnerabilities.dialog.describeReason", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6$lambda$5(IgnoreVulnerabilitiesDialog this$0, JBTextArea it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reasonIgnoring = it.getText();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(IgnoreVulnerabilitiesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextAreaKt.rows((Cell)$this$row.textArea().onChanged(arg_0 -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7$lambda$6$lambda$5(this$0, arg_0)), (int)5).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7(IgnoreVulnerabilitiesDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        AtomicBooleanProperty isOtherReason = new AtomicBooleanProperty(false);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7$lambda$0(this$0, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7$lambda$3(this$0, isOtherReason, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$panel, null, IgnoreVulnerabilitiesDialog::createCenterPanel$lambda$7$lambda$4, (int)1, null).visibleIf((ObservableProperty)isOtherReason).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IgnoreVulnerabilitiesDialog.createCenterPanel$lambda$7$lambda$6(this$0, arg_0), (int)1, null).visibleIf((ObservableProperty)isOtherReason);
        return Unit.INSTANCE;
    }
}

