/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.cwm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.actions.ActionsKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.ActionIdAndPresentationModel;
import com.jetbrains.rd.ide.model.AsyncActionGroupExpandResponse;
import com.jetbrains.rd.ide.model.AsyncActionUpdateRequest;
import com.jetbrains.rd.ide.model.AsyncActionsModel;
import com.jetbrains.rd.ide.model.AsyncActionsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.PresentationModel;
import com.jetbrains.rdclient.actions.ActionPlaceExKt;
import com.jetbrains.rdclient.actions.base.BackendCustomComponentAction;
import com.jetbrains.rdclient.actions.cwm.FrontendActionUpdateHostBase;
import com.jetbrains.rdclient.actions.cwm.FrontendActionUpdateUtilsKt;
import com.jetbrains.rdclient.actions.cwm.FrontendPresentationDecorator;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0018\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020&2\u0006\u0010$\u001a\u00020\tH\u0014J\u0018\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0018\u0010*\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010+2\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0011H\u0002J2\u0010.\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020\t2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002002\u0006\u00101\u001a\u000202H\u0014J\u001c\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0002042\u0006\u00105\u001a\u000206H\u0014R6\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0002X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00069"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost;", "Lcom/jetbrains/rdclient/actions/cwm/FrontendActionUpdateHostBase;", "Lcom/jetbrains/rd/ide/model/PresentationModel;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "pendingUpdates", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/AsyncActionUpdateRequest;", "", "Lcom/intellij/openapi/actionSystem/Presentation;", "Lkotlin/collections/HashMap;", "invalidValue", "getInvalidValue", "()Lcom/jetbrains/rd/ide/model/PresentationModel;", "taskName", "", "getTaskName", "()Ljava/lang/String;", "disableKeyboardActions", "", "backendActionIds", "", "componentId", "Lcom/jetbrains/ide/model/uiautomation/ComponentId;", "updatePresentation", "frontendActionId", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isActionAlwaysEnabledFix", "", "actionId", "addPendingRequest", "request", "startTask", "Lcom/jetbrains/rd/framework/IRdTask;", "addPendingUpdate", "req", "presentation", "removePendingUpdate", "", "clearPendingUpdates", "place", "applyTaskResult", "result", "Lcom/jetbrains/rd/framework/RdTaskResult;", "startTimeNs", "", "retrieveValues", "", "response", "Lcom/jetbrains/rd/ide/model/AsyncActionGroupExpandResponse;", "Companion", "MyActionPopupMenuListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendActionPresentationUpdateHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost\n+ 2 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n66#2,3:181\n68#3,4:184\n68#3,4:188\n68#3,4:192\n1187#4,2:196\n1261#4,4:198\n*S KotlinDebug\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost\n*L\n108#1:181,3\n139#1:184,4\n152#1:188,4\n169#1:192,4\n177#1:196,2\n177#1:198,4\n*E\n"})
public final class FrontendActionPresentationUpdateHost
extends FrontendActionUpdateHostBase<PresentationModel, PresentationModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<AsyncActionUpdateRequest, Set<Presentation>> pendingUpdates;
    @NotNull
    private final PresentationModel invalidValue;
    @NotNull
    private final String taskName;

    public FrontendActionPresentationUpdateHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, true);
        this.pendingUpdates = new HashMap();
        this.invalidValue = new PresentationModel(2, null, null, null, null, false, 32, null);
        this.taskName = "update()";
        ActionManagerEx.Companion.getInstanceEx().addActionPopupMenuListener((ActionPopupMenuListener)new MyActionPopupMenuListener(), (Disposable)this);
    }

    @Override
    @NotNull
    protected PresentationModel getInvalidValue() {
        return this.invalidValue;
    }

    @Override
    @NotNull
    protected String getTaskName() {
        return this.taskName;
    }

    public final void disableKeyboardActions(@NotNull List<String> backendActionIds, @NotNull ComponentId componentId) {
        Intrinsics.checkNotNullParameter(backendActionIds, (String)"backendActionIds");
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        for (String backendActionId : backendActionIds) {
            this.getCache().putValue(backendActionId, "keyboard shortcut", componentId, this.getInvalidValue());
        }
    }

    public final void updatePresentation(@NotNull String frontendActionId, @Nullable AnAction action, @NotNull AnActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        String backendActionId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(frontendActionId);
        PresentationModel lastPresentationModel = (PresentationModel)this.requestAsyncUpdate(frontendActionId, backendActionId, action, actionEvent);
        if (lastPresentationModel != null) {
            Presentation presentation = actionEvent.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            ActionsKt.applyPresentationModel((AnAction)action, (Presentation)presentation, (PresentationModel)lastPresentationModel);
            Presentation presentation2 = actionEvent.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            BackendCustomComponentAction.Companion.initIfNeeded(backendActionId, presentation2, lastPresentationModel);
        }
        if (this.isActionAlwaysEnabledFix(backendActionId)) {
            actionEvent.getPresentation().setEnabled(true);
        }
        FrontendPresentationDecorator.Companion.decorate(backendActionId, action, actionEvent);
    }

    private final boolean isActionAlwaysEnabledFix(String actionId) {
        Object[] objectArray = new String[]{"Resume", "StepInto", "StepOver", "StepOut", "ForceStepInto", "SmartStepInto", "ForceStepOver"};
        return SetsKt.setOf((Object[])objectArray).contains(actionId);
    }

    @Override
    protected boolean addPendingRequest(@NotNull AsyncActionUpdateRequest request2, @NotNull AnActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        Presentation presentation = actionEvent.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        return this.addPendingUpdate(request2, presentation);
    }

    @Override
    @NotNull
    protected IRdTask<PresentationModel> startTask(@NotNull AsyncActionUpdateRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        AsyncActionsModel actionsModel = AsyncActionsModel_GeneratedKt.getAsyncActionsModel((IProtocol)FrontendSessionsUtilKt.getProtocol(this.getSession()));
        return actionsModel.getUpdate().start(this.getServiceLifetime(), (Object)request2);
    }

    private final synchronized boolean addPendingUpdate(AsyncActionUpdateRequest req, Presentation presentation) {
        Set pendingPresentations;
        Map $this$getOrCreate$iv = this.pendingUpdates;
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get(req);
        if (object == null) {
            AsyncActionUpdateRequest it = req;
            boolean bl = false;
            Set it$iv = new HashSet();
            boolean bl2 = false;
            $this$getOrCreate$iv.put(req, it$iv);
            object = it$iv;
        }
        boolean isAlreadyRequested = !((Collection)(pendingPresentations = (Set)object)).isEmpty();
        pendingPresentations.add(presentation);
        return isAlreadyRequested;
    }

    private final synchronized Set<Presentation> removePendingUpdate(AsyncActionUpdateRequest req) {
        return this.pendingUpdates.remove(req);
    }

    private final synchronized void clearPendingUpdates(String place) {
        Iterator it = ((Map)this.pendingUpdates).entrySet().iterator();
        while (it.hasNext()) {
            String p = ((AsyncActionUpdateRequest)it.next().getKey()).getPlace();
            if (!Intrinsics.areEqual((Object)p, (Object)place)) continue;
            it.remove();
        }
    }

    @Override
    protected void applyTaskResult(@Nullable AnAction action, @NotNull AsyncActionUpdateRequest request2, @NotNull RdTaskResult<PresentationModel> result2, long startTimeNs) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        String place = request2.getPlace();
        String backendId = request2.getActionId();
        ComponentId componentId = FrontendActionUpdateUtilsKt.getComponentId(request2);
        try {
            Set<Presentation> presentations = this.removePendingUpdate(request2);
            if (!(result2 instanceof RdTaskResult.Success)) {
                Logger $this$trace$iv = FrontendActionUpdateHostBase.Companion.getLOG();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Received update with status " + result2 + " for action " + backendId + ", place " + place + ". Skip it.");
                }
                return;
            }
            PresentationModel presentationModel = (PresentationModel)((RdTaskResult.Success)result2).unwrap();
            if (presentationModel == null) {
                FrontendActionPresentationUpdateHost $this$applyTaskResult_u24lambda_u242 = this;
                boolean bl = false;
                FrontendActionUpdateHostBase.Companion.getLOG().error("Received update with invalid result for action " + backendId + ", place " + place);
                presentationModel = $this$applyTaskResult_u24lambda_u242.getInvalidValue();
            }
            PresentationModel presentationModel2 = presentationModel;
            if (presentations != null) {
                Logger $this$trace$iv = FrontendActionUpdateHostBase.Companion.getLOG();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    double time = (double)(System.nanoTime() - startTimeNs) / 1000000.0;
                    logger.trace("Received update for action " + backendId + " place " + place + ", took " + time + " ms. (enabled=" + ActionsKt.isEnabled((PresentationModel)presentationModel2) + ", visible=" + ActionsKt.isVisible((PresentationModel)presentationModel2) + ", hasDescription=" + (presentationModel2.getDescription() != null) + ")");
                }
                this.getCache().putValue(backendId, place, componentId, presentationModel2);
                for (Presentation p : presentations) {
                    ActionsKt.applyPresentationModel((AnAction)action, (Presentation)p, (PresentationModel)presentationModel2);
                    BackendCustomComponentAction.Companion.initIfNeeded(backendId, p, presentationModel2);
                    ActionUiKind uiKind = ActionPlaces.isPopupPlace((String)place) ? (ActionUiKind)ActionUiKind.POPUP : ActionUiKind.NONE;
                    AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)DataContext.EMPTY_CONTEXT, (Presentation)p, (String)place, (ActionUiKind)uiKind, null);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                    FrontendPresentationDecorator.Companion.decorate(backendId, action, anActionEvent);
                }
            }
        }
        catch (CancellationException ex) {
            Logger $this$trace$iv = FrontendActionUpdateHostBase.Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Action update for " + backendId + " cancelled");
            }
        }
        catch (Throwable t) {
            FrontendActionUpdateHostBase.Companion.getLOG().error("Exception occurred while handling action update result", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<String, PresentationModel> retrieveValues(@NotNull AsyncActionGroupExpandResponse response) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Iterable $this$associate$iv = response.getPresentations();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ActionIdAndPresentationModel it = (ActionIdAndPresentationModel)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getId(), (Object)it.getPresentation());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendActionPresentationUpdateHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,180:1\n31#2,2:181\n*S KotlinDebug\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$Companion\n*L\n31#1:181,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendActionPresentationUpdateHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendActionPresentationUpdateHost> serviceClass$iv = FrontendActionPresentationUpdateHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendActionPresentationUpdateHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$MyActionPopupMenuListener;", "Lcom/intellij/openapi/actionSystem/ex/ActionPopupMenuListener;", "<init>", "(Lcom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost;)V", "actionPopupMenuReleased", "", "menu", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendActionPresentationUpdateHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$MyActionPopupMenuListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,180:1\n68#2,4:181\n*S KotlinDebug\n*F\n+ 1 FrontendActionPresentationUpdateHost.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendActionPresentationUpdateHost$MyActionPopupMenuListener\n*L\n50#1:181,4\n*E\n"})
    public final class MyActionPopupMenuListener
    implements ActionPopupMenuListener {
        public void actionPopupMenuReleased(@NotNull ActionPopupMenu menu) {
            Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
            ThreadingAssertions.assertEventDispatchThread();
            String string = menu.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            String place = ActionPlaceExKt.normalizeActionPlace(string);
            if (!ActionPlaces.isPopupPlace((String)place) && !Intrinsics.areEqual((Object)"MainMenu", (Object)place)) {
                return;
            }
            Logger $this$trace$iv = FrontendActionUpdateHostBase.Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Clearing the cache and cancelling pending actions for transparent place('" + place + "').");
            }
            FrontendActionPresentationUpdateHost.this.getCache().clear(place);
            FrontendActionPresentationUpdateHost.this.clearPendingUpdates(place);
        }
    }
}

