/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;

public class JpegImageIOImage
extends JpegImage {
    public JpegImageIOImage(FopImage.ImageInfo info) {
        super(info);
    }

    protected boolean loadDimensions() {
        if (this.bitmaps == null) {
            return this.loadBitmap();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadBitmap() {
        try {
            this.inputStream.reset();
            BufferedImage imageData = ImageIO.read(this.inputStream);
            this.height = imageData.getHeight();
            this.width = imageData.getWidth();
            ColorModel cm = imageData.getColorModel();
            this.bitsPerPixel = cm.getComponentSize(0);
            this.colorSpace = cm.getColorSpace();
            int[] tmpMap = imageData.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            if (cm.hasAlpha()) {
                int transparencyType = cm.getTransparency();
                if (transparencyType == 1) {
                    this.isTransparent = false;
                } else if (transparencyType == 2) {
                    if (cm instanceof IndexColorModel) {
                        this.isTransparent = false;
                        byte[] alphas = new byte[((IndexColorModel)cm).getMapSize()];
                        byte[] reds = new byte[((IndexColorModel)cm).getMapSize()];
                        byte[] greens = new byte[((IndexColorModel)cm).getMapSize()];
                        byte[] blues = new byte[((IndexColorModel)cm).getMapSize()];
                        ((IndexColorModel)cm).getAlphas(alphas);
                        ((IndexColorModel)cm).getReds(reds);
                        ((IndexColorModel)cm).getGreens(greens);
                        ((IndexColorModel)cm).getBlues(blues);
                        for (int i = 0; i < ((IndexColorModel)cm).getMapSize(); ++i) {
                            if ((alphas[i] & 0xFF) != 0) continue;
                            this.isTransparent = true;
                            this.transparentColor = new Color(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                            break;
                        }
                    } else {
                        this.isTransparent = false;
                    }
                } else {
                    this.isTransparent = false;
                }
            } else {
                this.isTransparent = false;
            }
            this.bitmaps = new byte[this.width * this.height * 3];
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int p = tmpMap[i * this.width + j];
                    int r = p >> 16 & 0xFF;
                    int g = p >> 8 & 0xFF;
                    int b = p & 0xFF;
                    this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                    this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                    this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error while loading image: " + ex.getMessage()), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.inputStream = null;
        }
        return true;
    }
}

