/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import org.graalvm.visualvm.lib.profiler.spi.JavaPlatformManagerProvider;
import org.graalvm.visualvm.lib.profiler.spi.JavaPlatformProvider;
import org.openide.util.Lookup;

public final class JavaPlatform {
    private final JavaPlatformProvider provider;

    public static JavaPlatform getJavaPlatformById(String platformId) {
        if (platformId != null) {
            List<JavaPlatform> platforms = JavaPlatform.getPlatforms();
            for (JavaPlatform platform : platforms) {
                if (!platformId.equals(platform.getPlatformId())) continue;
                return platform;
            }
        }
        return null;
    }

    public static List<JavaPlatform> getPlatforms() {
        List<JavaPlatformProvider> platformProviders = JavaPlatform.provider().getPlatforms();
        ArrayList<JavaPlatform> platforms = new ArrayList<JavaPlatform>(platformProviders.size());
        for (JavaPlatformProvider p : platformProviders) {
            if (p.getPlatformJavaFile() == null || !MiscUtils.isSupportedJVM(p.getSystemProperties())) continue;
            platforms.add(new JavaPlatform(p));
        }
        return Collections.unmodifiableList(platforms);
    }

    public static JavaPlatform getDefaultPlatform() {
        return new JavaPlatform(JavaPlatform.provider().getDefaultPlatform());
    }

    public static void showCustomizer() {
        JavaPlatform.provider().showCustomizer();
    }

    private static JavaPlatformManagerProvider provider() {
        return (JavaPlatformManagerProvider)Lookup.getDefault().lookup(JavaPlatformManagerProvider.class);
    }

    JavaPlatform(JavaPlatformProvider p) {
        this.provider = p;
    }

    public String getDisplayName() {
        return this.provider.getDisplayName();
    }

    public String getPlatformId() {
        return this.provider.getPlatformId();
    }

    public int getPlatformJDKMinor() {
        return Platform.getJDKMinorNumber((String)this.getVersion());
    }

    public String getPlatformJDKVersion() {
        String ver = this.getVersion();
        if (ver == null) {
            return null;
        }
        return Platform.getJDKVersionString((String)ver);
    }

    public String getPlatformJavaFile() {
        return this.provider.getPlatformJavaFile();
    }

    public Map<String, String> getSystemProperties() {
        return this.provider.getSystemProperties();
    }

    public Map<String, String> getProperties() {
        return this.provider.getProperties();
    }

    public int getPlatformArchitecture() {
        String arch = this.getSystemProperties().get("sun.arch.data.model");
        if (arch == null) {
            return 32;
        }
        return Integer.parseInt(arch);
    }

    public String getVersion() {
        return this.getSystemProperties().get("java.version");
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaPlatform) {
            return this.getPlatformId().equals(((JavaPlatform)obj).getPlatformId());
        }
        return false;
    }

    public int hashCode() {
        return this.getPlatformId().hashCode();
    }
}

