/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BasicVector_ByteBuffer;
import org.armedbear.lisp.BasicVector_UnsignedByte8;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Java;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class ByteArrayOutputStream
extends Stream {
    private final java.io.ByteArrayOutputStream byteArrayOutputStream;
    private static final Primitive MAKE_BYTE_ARRAY_OUTPUT_STREAM = new Primitive("%make-byte-array-output-stream", Lisp.PACKAGE_SYS, false, "&optional element-type"){

        @Override
        public LispObject execute() {
            return new ByteArrayOutputStream();
        }

        @Override
        public LispObject execute(LispObject arg) {
            return new ByteArrayOutputStream(arg);
        }
    };
    private static final Primitive GET_OUTPUT_STREAM_STRING = new Primitive("%get-output-stream-bytes", Lisp.PACKAGE_SYS, false, "byte-array-output-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof ByteArrayOutputStream) {
                return JavaObject.getInstance(((ByteArrayOutputStream)arg).getByteArray());
            }
            return Lisp.type_error(this, Symbol.STREAM);
        }
    };
    private static final Primitive GET_OUTPUT_STREAM_ARRAY = new Primitive("%get-output-stream-array", Lisp.PACKAGE_SYS, false, "byte-array-output-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof ByteArrayOutputStream) {
                byte[] array = ((ByteArrayOutputStream)arg).getByteArray();
                if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                    return new BasicVector_ByteBuffer(array, false);
                }
                if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.PRIMITIVE_ARRAY)) {
                    return new BasicVector_UnsignedByte8(array);
                }
            }
            return Lisp.type_error(this, Symbol.STREAM);
        }
    };

    public ByteArrayOutputStream() {
        this(Lisp.UNSIGNED_BYTE_8);
    }

    ByteArrayOutputStream(LispObject elementType) {
        super(Symbol.SYSTEM_STREAM);
        this.elementType = elementType;
        this.byteArrayOutputStream = new java.io.ByteArrayOutputStream(2048);
        this.initAsBinaryOutputStream(this.byteArrayOutputStream);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        return super.typep(type);
    }

    @Override
    protected long _getFilePosition() {
        if (this.elementType == Lisp.NIL) {
            return 0L;
        }
        return this.byteArrayOutputStream.size();
    }

    public byte[] getByteArray() {
        if (this.elementType == Lisp.NIL) {
            return new byte[0];
        }
        return this.byteArrayOutputStream.toByteArray();
    }
}

