/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.action.enterprise.RefreshProjectAction;
import ca.sqlpower.architect.swingui.enterprise.PrivilegesEditorPanel;
import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.GroupMember;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.SPSUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ProjectSecurityPanel
implements DataEntryPanel {
    private static final ImageIcon ADD_ICON = new ImageIcon(RefreshProjectAction.class.getResource("/icons/famfamfam/add.png"));
    private static final ImageIcon REMOVE_ICON = new ImageIcon(RefreshProjectAction.class.getResource("/icons/famfamfam/delete.png"));
    private final JPanel panel;
    private final JLabel panelLabel;
    private final Action closeAction;
    private final ArchitectSwingProject securityWorkspace;
    private final SPObject subject;
    private final Class<?> type;
    private final String username;
    private GroupOrUserTableModel userModel;
    private GroupOrUserTableModel groupModel;
    private boolean hasUnsavedChanges = false;
    private final Dialog d;

    public ProjectSecurityPanel(ArchitectSwingProject securityWorkspace, SPObject subject, Class<?> type, String username, Dialog d, Action closeAction) {
        this.securityWorkspace = securityWorkspace;
        this.subject = subject;
        this.type = type;
        this.username = username;
        this.closeAction = closeAction;
        this.d = d;
        this.panelLabel = new JLabel("Permissions for '" + (subject != null ? subject.getName() : type.getSimpleName()) + "'");
        this.panelLabel.setFont(new Font(this.panelLabel.getFont().getFontName(), 1, this.panelLabel.getFont().getSize() + 1));
        this.panel = new JPanel();
        this.refreshPanel();
    }

    private void refreshPanel() {
        this.userModel = new GroupOrUserTableModel(User.class);
        this.groupModel = new GroupOrUserTableModel(Group.class);
        CellConstraints cc = new CellConstraints();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref", "pref:grow, 5dlu, pref:grow, pref:grow, 5dlu, pref:grow, pref:grow, 5dlu, pref:grow"));
        builder.add((Component)this.panelLabel, cc.xy(1, 1));
        JLabel userPermissions = new JLabel("User Permissions");
        userPermissions.setFont(new Font(userPermissions.getFont().getFontName(), 1, userPermissions.getFont().getSize()));
        builder.add((Component)userPermissions, cc.xy(1, 3));
        builder.add((Component)this.userModel.getPanel(), cc.xy(1, 4));
        JLabel groupPermissions = new JLabel("Group Permissions");
        groupPermissions.setFont(userPermissions.getFont());
        builder.add((Component)groupPermissions, cc.xy(1, 6));
        builder.add((Component)this.groupModel.getPanel(), cc.xy(1, 7));
        JButton okButton = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSecurityPanel.this.userModel.applyChanges();
                ProjectSecurityPanel.this.groupModel.applyChanges();
                ProjectSecurityPanel.this.closeAction.actionPerformed(e);
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSecurityPanel.this.userModel.discardChanges();
                ProjectSecurityPanel.this.groupModel.discardChanges();
                ProjectSecurityPanel.this.closeAction.actionPerformed(e);
            }
        });
        ButtonBarBuilder buttonBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        buttonBuilder.addGlue();
        buttonBuilder.addGridded((JComponent)okButton);
        buttonBuilder.addRelatedGap();
        buttonBuilder.addGridded((JComponent)cancelButton);
        buttonBuilder.setDefaultButtonBarGapBorder();
        builder.add((Component)buttonBuilder.getPanel(), cc.xy(1, 9));
        builder.setDefaultDialogBorder();
        this.panel.removeAll();
        this.panel.add(builder.getPanel());
        this.panel.revalidate();
        this.disableIfNecessary();
    }

    public boolean applyChanges() {
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    public void disableIfNecessary() {
        User user = null;
        ArrayList<Grant> grantsForUser = new ArrayList<Grant>();
        for (User aUser : this.securityWorkspace.getChildren(User.class)) {
            if (!aUser.getUsername().equals(this.username)) continue;
            user = aUser;
        }
        if (user == null) {
            throw new IllegalStateException("User cannot possibly be null");
        }
        for (Grant g : user.getChildren(Grant.class)) {
            grantsForUser.add(g);
        }
        for (Grant g : this.securityWorkspace.getChildren(Group.class)) {
            for (GroupMember gm : g.getChildren(GroupMember.class)) {
                if (!gm.getUser().getUUID().equals(user.getUUID())) continue;
                for (Grant gr : g.getChildren(Grant.class)) {
                    grantsForUser.add(gr);
                }
            }
        }
        boolean disable = true;
        for (Grant g : grantsForUser) {
            if ((g.isSystemLevel() || this.subject == null || !g.getSubject().equals(this.subject.getUUID())) && (!g.isSystemLevel() || !g.getType().equals(this.type.getName())) || !g.isGrantPrivilege()) continue;
            disable = false;
        }
        if (disable) {
            Component[] componentArray;
            Iterator<Object> i$ = this.userModel.getComponents().iterator();
            while (i$.hasNext()) {
                for (Component component : componentArray = (Component[])i$.next()) {
                    component.setEnabled(false);
                }
            }
            i$ = this.groupModel.getComponents().iterator();
            while (i$.hasNext()) {
                for (Component component : componentArray = (Component[])i$.next()) {
                    component.setEnabled(false);
                }
            }
        }
    }

    public static Action createShowAction(final ArchitectSwingProject securityWorkspace, final SPObject subject, final Class<?> type, final String username, final JComponent panel) {
        return new AbstractAction("Manage Security Settings..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog d = SPSUtils.makeOwnedDialog((Component)panel, (String)"Security Manager");
                AbstractAction closeAction = new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        d.dispose();
                    }
                };
                ProjectSecurityPanel spm = new ProjectSecurityPanel(securityWorkspace, subject, type, username, d, closeAction);
                d.setDefaultCloseOperation(2);
                d.setContentPane(spm.getPanel());
                SPSUtils.makeJDialogCancellable((Window)d, null);
                d.pack();
                d.setLocationRelativeTo(panel);
                d.setVisible(true);
            }
        };
    }

    private class GroupOrUserTableModel
    implements TableModel,
    DataEntryPanel {
        private final Component[] headerRow;
        private final List<Component[]> rows;
        private final int numColumns = 7;
        private final List<DataEntryPanel> panels = new ArrayList<DataEntryPanel>();
        private final List<SPObject> objectsWithSpecificGrants;
        private final List<SPObject> objectsWithoutSpecificGrants;
        private final List<SPObject> objectsWithGlobalGrants;
        private final List<SPObject> objectsWithoutGlobalGrants;

        public GroupOrUserTableModel(final Class<? extends SPObject> groupOrUserClass) {
            this.rows = new ArrayList<Component[]>();
            this.objectsWithoutSpecificGrants = new ArrayList<SPObject>();
            this.objectsWithSpecificGrants = new ArrayList<SPObject>();
            this.objectsWithGlobalGrants = new ArrayList<SPObject>();
            this.objectsWithoutGlobalGrants = new ArrayList<SPObject>();
            HashMap<SPObject, Grant> specificGrants = new HashMap<SPObject, Grant>();
            HashMap<SPObject, Grant> globalGrants = new HashMap<SPObject, Grant>();
            for (SPObject object : ProjectSecurityPanel.this.securityWorkspace.getChildren(groupOrUserClass)) {
                for (Grant grant : object.getChildren(Grant.class)) {
                    if (grant.isSystemLevel() && grant.getType().equals(ProjectSecurityPanel.this.type.getName())) {
                        globalGrants.put(object, grant);
                    }
                    if (ProjectSecurityPanel.this.subject == null || grant.isSystemLevel() || !grant.getSubject().equals(ProjectSecurityPanel.this.subject.getUUID())) continue;
                    specificGrants.put(object, grant);
                }
            }
            for (SPObject obj : ProjectSecurityPanel.this.securityWorkspace.getChildren(groupOrUserClass)) {
                this.objectsWithoutSpecificGrants.add(obj);
                this.objectsWithoutGlobalGrants.add(obj);
            }
            for (SPObject obj : specificGrants.keySet()) {
                this.objectsWithSpecificGrants.add(obj);
            }
            for (SPObject obj : globalGrants.keySet()) {
                this.objectsWithGlobalGrants.add(obj);
            }
            this.objectsWithoutSpecificGrants.removeAll(this.objectsWithSpecificGrants);
            this.objectsWithoutGlobalGrants.removeAll(this.objectsWithGlobalGrants);
            Comparator<SPObject> comparator = new Comparator<SPObject>(){

                @Override
                public int compare(SPObject o1, SPObject o2) {
                    return o1.getName().toUpperCase().compareTo(o2.getName().toUpperCase());
                }
            };
            Collections.sort(this.objectsWithSpecificGrants, comparator);
            Collections.sort(this.objectsWithoutSpecificGrants, comparator);
            Collections.sort(this.objectsWithGlobalGrants, comparator);
            Collections.sort(this.objectsWithoutGlobalGrants, comparator);
            this.headerRow = new Component[7];
            this.headerRow[0] = new JLabel("Name");
            this.headerRow[1] = new JLabel("View");
            this.headerRow[2] = new JLabel("Create");
            this.headerRow[3] = new JLabel("Modify");
            this.headerRow[4] = new JLabel("Delete");
            this.headerRow[5] = new JLabel("Grant");
            JButton addButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JList list = new JList(new DefaultListModel());
                    DefaultListModel model = (DefaultListModel)list.getModel();
                    for (SPObject obj : ProjectSecurityPanel.this.subject != null ? GroupOrUserTableModel.this.objectsWithoutSpecificGrants : GroupOrUserTableModel.this.objectsWithoutGlobalGrants) {
                        model.addElement(obj);
                    }
                    Object[] message = new Object[]{"Select " + groupOrUserClass.getSimpleName() + "s to add", new JScrollPane(list)};
                    Object[] selections = new Object[]{"OK", "Cancel"};
                    Integer selection = JOptionPane.showOptionDialog(ProjectSecurityPanel.this.d, message, "", -1, 1, null, selections, selections[0]);
                    if (selection == 0) {
                        int[] selectedIndices = list.getSelectedIndices();
                        for (int i = 0; i < selectedIndices.length; ++i) {
                            SPObject obj = (SPObject)model.get(selectedIndices[i]);
                            if (ProjectSecurityPanel.this.subject != null) {
                                obj.addChild((SPObject)new Grant(ProjectSecurityPanel.this.subject, false, false, false, false, false), obj.getChildren(Grant.class).size());
                                continue;
                            }
                            obj.addChild((SPObject)new Grant(ProjectSecurityPanel.this.type.getName(), false, false, false, false, false), obj.getChildren(Grant.class).size());
                        }
                        ProjectSecurityPanel.this.refreshPanel();
                    }
                }
            });
            addButton.setIcon(ADD_ICON);
            addButton.setBorderPainted(false);
            addButton.setContentAreaFilled(false);
            this.headerRow[6] = addButton;
            this.rows.add(this.headerRow);
            if (ProjectSecurityPanel.this.subject != null) {
                for (final SPObject object : this.objectsWithSpecificGrants) {
                    final PrivilegesEditorPanel specific = new PrivilegesEditorPanel((Grant)specificGrants.get(object), object, ProjectSecurityPanel.this.subject.getUUID(), ProjectSecurityPanel.this.type.getName(), ProjectSecurityPanel.this.username, ProjectSecurityPanel.this.securityWorkspace);
                    PrivilegesEditorPanel global = new PrivilegesEditorPanel((Grant)globalGrants.get(object), object, ProjectSecurityPanel.this.subject.getUUID(), ProjectSecurityPanel.this.type.getName(), ProjectSecurityPanel.this.username, ProjectSecurityPanel.this.securityWorkspace);
                    this.panels.add(specific);
                    this.panels.add(global);
                    global.getCreatePrivilege().setEnabled(false);
                    global.getModifyPrivilege().setEnabled(false);
                    global.getDeletePrivilege().setEnabled(false);
                    global.getViewPrivilege().setEnabled(false);
                    global.getGrantPrivilege().setEnabled(false);
                    global.getCreatePrivilege().setText(null);
                    global.getModifyPrivilege().setText(null);
                    global.getDeletePrivilege().setText(null);
                    global.getViewPrivilege().setText(null);
                    global.getGrantPrivilege().setText(null);
                    specific.getCreatePrivilege().setText(null);
                    specific.getModifyPrivilege().setText(null);
                    specific.getDeletePrivilege().setText(null);
                    specific.getViewPrivilege().setText(null);
                    specific.getGrantPrivilege().setText(null);
                    JButton removeButton = new JButton(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                object.removeChild((SPObject)specific.getGrant());
                            }
                            catch (Exception ex) {
                                throw new RuntimeException("Unable to remove grant from object", ex);
                            }
                            ProjectSecurityPanel.this.refreshPanel();
                        }
                    });
                    removeButton.setIcon(REMOVE_ICON);
                    removeButton.setBorderPainted(false);
                    removeButton.setContentAreaFilled(false);
                    Component[] rowComponents = new Component[]{new JLabel(object.getName()), global.getViewPrivilege().isSelected() ? global.getViewPrivilege() : specific.getViewPrivilege(), global.getCreatePrivilege().isSelected() ? global.getCreatePrivilege() : specific.getCreatePrivilege(), global.getModifyPrivilege().isSelected() ? global.getModifyPrivilege() : specific.getModifyPrivilege(), global.getDeletePrivilege().isSelected() ? global.getDeletePrivilege() : specific.getDeletePrivilege(), global.getGrantPrivilege().isSelected() ? global.getGrantPrivilege() : specific.getGrantPrivilege(), removeButton};
                    for (Component component : rowComponents) {
                        component.setBackground(Color.white);
                    }
                    this.rows.add(rowComponents);
                }
            } else {
                for (final SPObject object : this.objectsWithGlobalGrants) {
                    final PrivilegesEditorPanel global = new PrivilegesEditorPanel((Grant)globalGrants.get(object), object, null, ProjectSecurityPanel.this.type.getName(), ProjectSecurityPanel.this.username, ProjectSecurityPanel.this.securityWorkspace);
                    this.panels.add(global);
                    global.getCreatePrivilege().setText(null);
                    global.getModifyPrivilege().setText(null);
                    global.getDeletePrivilege().setText(null);
                    global.getViewPrivilege().setText(null);
                    global.getGrantPrivilege().setText(null);
                    JButton removeButton = new JButton(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                object.removeChild((SPObject)global.getGrant());
                            }
                            catch (Exception ex) {
                                throw new RuntimeException("Unable to remove grant from object", ex);
                            }
                            ProjectSecurityPanel.this.refreshPanel();
                        }
                    });
                    removeButton.setIcon(REMOVE_ICON);
                    removeButton.setBorderPainted(false);
                    removeButton.setContentAreaFilled(false);
                    Component[] rowComponents = new Component[]{new JLabel(object.getName()), global.getViewPrivilege(), global.getCreatePrivilege(), global.getModifyPrivilege(), global.getDeletePrivilege(), global.getGrantPrivilege(), removeButton};
                    for (Component component : rowComponents) {
                        component.setBackground(Color.white);
                    }
                    this.rows.add(rowComponents);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.headerRow[columnIndex].getClass();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex)[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public List<Component[]> getComponents() {
            return this.rows;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        public void discardChanges() {
            for (DataEntryPanel dep : this.panels) {
                dep.discardChanges();
            }
        }

        public JComponent getPanel() {
            JTable table = new JTable(this);
            table.setTableHeader(null);
            for (int i = 0; i < table.getColumnCount(); ++i) {
                TableColumn col = table.getColumnModel().getColumn(i);
                col.setCellRenderer(new RowCellRenderer(this));
                col.setCellEditor(new RowCellEditor(this));
            }
            table.getColumnModel().getColumn(6).setPreferredWidth(table.getRowHeight());
            table.setShowHorizontalLines(false);
            table.setShowVerticalLines(false);
            JScrollPane scrollpane = new JScrollPane(table);
            scrollpane.setVerticalScrollBarPolicy(22);
            scrollpane.setHorizontalScrollBarPolicy(30);
            int preferredHeight = table.getRowHeight() * 7;
            int preferredWidth = scrollpane.getVerticalScrollBar().getWidth();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                preferredWidth += table.getColumnModel().getColumn(i).getWidth();
            }
            scrollpane.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
            scrollpane.getViewport().setBackground(Color.WHITE);
            return scrollpane;
        }

        public boolean applyChanges() {
            boolean success = true;
            for (DataEntryPanel dep : this.panels) {
                if (dep.applyChanges()) continue;
                success = false;
            }
            return success;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }
    }

    private class RowCellEditor
    implements TableCellEditor {
        private GroupOrUserTableModel model;

        public RowCellEditor(GroupOrUserTableModel model) {
            this.model = model;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return (Component)this.model.getValueAt(row, column);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }
    }

    private class RowCellRenderer
    implements TableCellRenderer {
        private GroupOrUserTableModel model;

        public RowCellRenderer(GroupOrUserTableModel model) {
            this.model = model;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                table.setToolTipText(((JLabel)this.model.getValueAt(row, column)).getText());
            }
            return (Component)this.model.getValueAt(row, column);
        }
    }
}

