/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.mapviewer.ChatDisplay;
import net.sf.freecol.client.gui.mapviewer.MapViewerBounds;
import net.sf.freecol.client.gui.mapviewer.MapViewerRepaintManager;
import net.sf.freecol.client.gui.mapviewer.MapViewerScaledUtils;
import net.sf.freecol.client.gui.mapviewer.MapViewerState;
import net.sf.freecol.client.gui.mapviewer.TileBounds;
import net.sf.freecol.client.gui.mapviewer.TileViewer;
import net.sf.freecol.client.gui.mapviewer.UnitAnimator;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.military.DefensiveMap;
import net.sf.freecol.server.ai.military.DefensiveZone;

public final class MapViewer
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(MapViewer.class.getName());
    private final MapViewerBounds mapViewerBounds = new MapViewerBounds();
    private final MapViewerState mapViewerState;
    private final TileViewer tv;
    private final MapViewerRepaintManager rpm;
    private final MapViewerScaledUtils mapViewerScaledUtils;
    private final ImageLibrary lib;
    private TileBounds tileBounds = new TileBounds(new Dimension(0, 0), 1.0f);
    private List<Rectangle> fullyRepaintedAreas = new ArrayList<Rectangle>();

    public MapViewer(FreeColClient freeColClient, ImageLibrary lib, ActionListener al) {
        super(freeColClient);
        this.lib = lib;
        this.tv = new TileViewer(freeColClient, lib);
        ChatDisplay chatDisplay = new ChatDisplay(freeColClient);
        UnitAnimator unitAnimator = new UnitAnimator(freeColClient, this, lib);
        this.mapViewerState = new MapViewerState(chatDisplay, unitAnimator, al);
        this.mapViewerScaledUtils = new MapViewerScaledUtils();
        this.rpm = new MapViewerRepaintManager();
        this.updateScaledVariables();
    }

    public void changeScale(float newScale) {
        this.lib.changeScaleFactor(newScale);
        this.tv.updateScaledVariables();
        this.updateScaledVariables();
        this.mapViewerBounds.positionMap();
        this.rpm.markAsDirty();
    }

    private void updateScaledVariables() {
        this.tileBounds = new TileBounds(this.lib.getTileSize(), this.lib.getScaleFactor());
        this.mapViewerBounds.updateSizeVariables(this.tileBounds);
        this.mapViewerScaledUtils.updateScaledVariables(this.lib);
    }

    public void changeSize(Dimension size) {
        this.tileBounds = new TileBounds(this.lib.getTileSize(), this.lib.getScaleFactor());
        this.mapViewerBounds.changeSize(size, this.tileBounds);
        this.rpm.markAsDirty();
    }

    public Tile convertToMapTile(int x, int y) {
        return this.mapViewerBounds.convertToMapTile(this.getMap(), x, y);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="lazy load of extra tiles")
    public boolean displayMap(Graphics2D g2d, Dimension size) {
        long startMs = Utils.now();
        Rectangle clipBounds = g2d.getClipBounds();
        if (this.mapViewerBounds.getFocus() == null) {
            this.paintBlackBackground(g2d, clipBounds);
            return false;
        }
        if (this.rpm.isRepaintsBlocked(size)) {
            VolatileImage backBufferImage = this.rpm.getBackBufferImage();
            g2d.drawImage(backBufferImage, 0, 0, null);
            return false;
        }
        boolean fullMapRenderedWithoutUsingBackBuffer = this.rpm.prepareBuffers(this.mapViewerBounds, this.mapViewerBounds.getFocus());
        Rectangle dirtyClipBounds = this.rpm.getDirtyClipBounds();
        if (this.rpm.isAllDirty()) {
            fullMapRenderedWithoutUsingBackBuffer = true;
        }
        VolatileImage backBufferImage = this.rpm.getBackBufferImage();
        BufferedImage nonAnimationBufferImage = this.rpm.getNonAnimationBufferImage();
        Graphics2D backBufferG2d = backBufferImage.createGraphics();
        AffineTransform backBufferOriginTransform = backBufferG2d.getTransform();
        Map map = this.getMap();
        Rectangle allRenderingClipBounds = dirtyClipBounds.isEmpty() ? clipBounds : clipBounds.union(dirtyClipBounds);
        this.paintBlackBackground(backBufferG2d, allRenderingClipBounds);
        TileClippingBounds animatedBaseTileTcb = new TileClippingBounds(map, allRenderingClipBounds);
        long initMs = Utils.now();
        backBufferG2d.setClip(allRenderingClipBounds);
        backBufferG2d.translate(animatedBaseTileTcb.clipLeftX, animatedBaseTileTcb.clipTopY);
        this.paintEachTile(backBufferG2d, animatedBaseTileTcb, (tileG2d, tile) -> this.tv.displayAnimatedBaseTiles(tileG2d, tile, false));
        long animatedBaseMs = Utils.now();
        if (!dirtyClipBounds.isEmpty()) {
            this.displayToNonAnimationBufferImage(dirtyClipBounds, nonAnimationBufferImage, map);
        }
        long nonAnimatedMs = Utils.now();
        backBufferG2d.setTransform(backBufferOriginTransform);
        backBufferG2d.setClip(allRenderingClipBounds);
        backBufferG2d.drawImage((Image)nonAnimationBufferImage, 0, 0, null);
        backBufferG2d.dispose();
        g2d.drawImage(backBufferImage, 0, 0, null);
        long useBuffersMs = Utils.now();
        Tile cursorTile = this.getVisibleCursorTile();
        if (cursorTile != null && this.mapViewerState.getCursor().isActive() && !this.mapViewerState.getUnitAnimator().isUnitsOutForAnimation()) {
            Point p = this.mapViewerBounds.calculateTilePosition(cursorTile, false);
            String key = this.mapViewerState.getViewMode() == GUI.ViewMode.MOVE_UNITS ? "image.tile.unitSelect" : "image.tile.tileSelect";
            BufferedImage image = this.lib.getScaledImage(key);
            g2d.drawImage((Image)image, p.x - (image.getWidth() - this.tileBounds.getWidth()) / 2, p.y - (image.getHeight() - this.tileBounds.getHeight()) / 2, null);
        }
        long cursorTileMs = Utils.now();
        if (this.mapViewerState.getUnitPath() != null) {
            this.displayPath(g2d, this.mapViewerState.getUnitPath());
        } else if (this.mapViewerState.getGotoPath() != null) {
            this.displayPath(g2d, this.mapViewerState.getGotoPath());
        }
        long gotoPathMs = Utils.now();
        if (this.mapViewerState.isRangedAttackMode() && this.mapViewerState.getActiveUnit() != null && this.mapViewerState.getActiveUnit().getTile() != null) {
            BufferedImage rangedTarget = this.lib.getRangedTargetCrosshair();
            Iterable<Tile> possibleTargets = map.getCircleTiles(this.mapViewerState.getActiveUnit().getTile(), true, this.mapViewerState.getActiveUnit().getType().getAttackRange());
            for (Tile t : possibleTargets) {
                Point point;
                if (!this.mapViewerState.getActiveUnit().canAttackRanged(t) || (point = this.mapViewerBounds.calculateTilePosition(t, false)) == null) continue;
                g2d.drawImage((Image)rangedTarget, point.x + (this.tileBounds.getWidth() - rangedTarget.getWidth()) / 2, point.y + (this.tileBounds.getHeight() - rangedTarget.getHeight()) / 2, null);
            }
        }
        this.mapViewerState.getChatDisplay().display(g2d, this.mapViewerBounds.getSize());
        long chatMs = Utils.now();
        if (FreeColDebugger.debugRendering()) {
            this.fullyRepaintedAreas.add(dirtyClipBounds);
            g2d.setColor(new Color(255, 0, 0, 100));
            for (Rectangle r : this.fullyRepaintedAreas) {
                g2d.fill(r);
            }
            this.fullyRepaintedAreas.clear();
        }
        this.verifyAndMarkAsClean(size, clipBounds);
        if (fullMapRenderedWithoutUsingBackBuffer && logger.isLoggable(Level.FINEST)) {
            long endMs = Utils.now();
            long gap = endMs - startMs;
            StringBuilder sb = new StringBuilder(128);
            sb.append("displayMap fullRendering=").append(fullMapRenderedWithoutUsingBackBuffer).append(" time= ").append(gap).append(" init=").append(initMs - startMs).append(" animated=").append(animatedBaseMs - initMs).append(" displayNonAnimationImages=").append(nonAnimatedMs - animatedBaseMs).append(" buffers=").append(useBuffersMs - nonAnimatedMs).append(" cursorTile=").append(cursorTileMs - useBuffersMs).append(" goto=").append(gotoPathMs - cursorTileMs).append(" chat=").append(chatMs - gotoPathMs).append(" finish=").append(endMs - chatMs);
            logger.finest(sb.toString());
        }
        return fullMapRenderedWithoutUsingBackBuffer;
    }

    public void paintImmediatelyToBuffersOnly() {
        if (this.mapViewerBounds.getFocus() == null || this.rpm.isRepaintsBlocked(this.mapViewerBounds.getSize())) {
            return;
        }
        this.rpm.prepareBuffers(this.mapViewerBounds, this.mapViewerBounds.getFocus());
        Rectangle dirtyClipBounds = this.rpm.getDirtyClipBounds();
        if (dirtyClipBounds.isEmpty()) {
            return;
        }
        BufferedImage nonAnimationBufferImage = this.rpm.getNonAnimationBufferImage();
        Map map = this.getMap();
        this.displayToNonAnimationBufferImage(dirtyClipBounds, nonAnimationBufferImage, map);
        if (FreeColDebugger.debugRendering()) {
            this.fullyRepaintedAreas.add(dirtyClipBounds);
        }
        this.rpm.markAsClean();
    }

    private void displayToNonAnimationBufferImage(Rectangle dirtyClipBounds, BufferedImage nonAnimationBufferImage, Map map) {
        TileClippingBounds tcb = new TileClippingBounds(map, dirtyClipBounds);
        Graphics2D nonAnimationG2d = nonAnimationBufferImage.createGraphics();
        this.displayNonAnimationImages(nonAnimationG2d, dirtyClipBounds, tcb);
        nonAnimationG2d.dispose();
    }

    private void displayNonAnimationImages(Graphics2D nonAnimationG2d, Rectangle clipBounds, TileClippingBounds tcb) {
        RescaleOp fow;
        long t0 = Utils.now();
        Player player = this.getMyPlayer();
        ClientOptions options = this.getClientOptions();
        nonAnimationG2d.setComposite(AlphaComposite.Clear);
        nonAnimationG2d.fill(clipBounds);
        nonAnimationG2d.setComposite(AlphaComposite.SrcOver);
        nonAnimationG2d.setClip(clipBounds);
        nonAnimationG2d.translate(tcb.clipLeftX, tcb.clipTopY);
        long t1 = Utils.now();
        this.paintEachTile(nonAnimationG2d, tcb, (tileG2d, tile) -> this.tv.displayTileWithBeach(tileG2d, tile));
        nonAnimationG2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long t2 = Utils.now();
        this.paintEachTile(nonAnimationG2d, tcb, (tileG2d, tile) -> {
            if (this.getClientOptions().isRiverAnimationEnabled() && (tile.hasRiver() || this.tv.hasRiverDelta(tile))) {
                return;
            }
            this.tv.drawBaseTileTransitions(tileG2d, tile);
        });
        long t3 = Utils.now();
        this.displayGrid(nonAnimationG2d, options, tcb);
        long t4 = Utils.now();
        if (options.getInteger("model.option.displayTileText") == 3) {
            this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> this.displayTerritorialBorders(tileG2d, tile, BorderType.REGION, true));
        }
        long t5 = Utils.now();
        if (options.getBoolean("model.option.displayBorders")) {
            this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> this.displayTerritorialBorders(tileG2d, tile, BorderType.COUNTRY, true));
        }
        long t6 = Utils.now();
        nonAnimationG2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.shouldFogOfWarBeDisplayed(player, options)) {
            fow = new RescaleOp(new float[]{0.8f, 0.8f, 0.8f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
            Composite oldComposite = nonAnimationG2d.getComposite();
            nonAnimationG2d.setColor(Color.BLACK);
            nonAnimationG2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            this.paintEachTile(nonAnimationG2d, tcb, (tileG2d, tile) -> {
                if (!tile.isExplored() || player.canSee(tile)) {
                    return;
                }
                tileG2d.fill(this.mapViewerScaledUtils.getFog());
            });
            nonAnimationG2d.setComposite(oldComposite);
        } else {
            fow = null;
        }
        long t7 = Utils.now();
        this.paintEachTile(nonAnimationG2d, tcb, (tileG2d, tile) -> this.tv.displayUnknownTileBorder(tileG2d, tile));
        long t8 = Utils.now();
        int colonyLabels = options.getInteger("model.option.displayColonyLabels");
        boolean withNumbers = colonyLabels == 1;
        this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> {
            if (!tile.isExplored()) {
                return;
            }
            BufferedImage overlayImage = this.lib.getScaledOverlayImage(tile);
            RescaleOp rop = player == null || player.canSee(tile) ? null : fow;
            this.tv.displayTileItems(tileG2d, tile, rop, overlayImage);
            this.tv.displaySettlementWithChipsOrPopulationNumber(tileG2d, tile, withNumbers, rop);
            this.tv.displayOptionalTileText(tileG2d, tile);
        });
        long t9 = Utils.now();
        nonAnimationG2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (options.getInteger("model.option.displayTileText") == 3) {
            this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> this.displayTerritorialBorders(tileG2d, tile, BorderType.REGION, false));
        }
        long t10 = Utils.now();
        if (options.getBoolean("model.option.displayBorders")) {
            this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> this.displayTerritorialBorders(tileG2d, tile, BorderType.COUNTRY, false));
        }
        long t12 = Utils.now();
        nonAnimationG2d.setColor(Color.BLACK);
        boolean revengeMode = this.getGame().isInRevengeMode();
        if (!revengeMode) {
            this.paintEachTile(nonAnimationG2d, tcb.getTopLeftDirtyTile(), tcb.getUnitTiles(), (tileG2d, tile) -> {
                Unit unit = this.mapViewerState.findUnitInFront(tile);
                if (unit == null || this.mapViewerState.getUnitAnimator().isOutForAnimation(unit)) {
                    return;
                }
                this.displayUnit(tileG2d, unit);
            });
        } else {
            BufferedImage darkness = this.lib.getScaledImage("image.halo.dark");
            this.paintEachTileWithSuperExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> {
                Unit unit = this.mapViewerState.findUnitInFront(tile);
                if (unit == null || this.mapViewerState.getUnitAnimator().isOutForAnimation(unit)) {
                    return;
                }
                if (unit.isUndead()) {
                    this.tv.displayCenteredImage(tileG2d, darkness);
                }
                this.displayUnit(tileG2d, unit);
            });
        }
        long t13 = Utils.now();
        this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> {
            if (!tile.isExplored()) {
                return;
            }
            BufferedImage overlayImage = this.lib.getScaledAboveTileImage(tile);
            if (overlayImage != null) {
                tileG2d.drawImage((Image)overlayImage, (this.tileBounds.getWidth() - overlayImage.getWidth()) / 2, (this.tileBounds.getHeight() - overlayImage.getHeight()) / 2, null);
            }
        });
        this.displayDebugAiDefensiveMap(nonAnimationG2d, tcb);
        long t14 = Utils.now();
        if (colonyLabels != 0) {
            this.paintEachTileWithExtendedImageSize(nonAnimationG2d, tcb, (tileG2d, tile) -> {
                Settlement settlement = tile.getSettlement();
                if (settlement == null) {
                    return;
                }
                RescaleOp rop = player == null || player.canSee(tile) ? null : fow;
                this.displaySettlementLabels(tileG2d, settlement, player, colonyLabels, rop);
            });
        }
        long t15 = Utils.now();
        if (logger.isLoggable(Level.FINEST)) {
            long gap = Utils.now() - t0;
            Map.Position bottomRight = tcb.getBottomRightDirtyTile();
            Map.Position topLeft = tcb.getTopLeftDirtyTile();
            double avg = (double)gap / (double)((bottomRight.getX() - topLeft.getX()) * (bottomRight.getY() - topLeft.getY()));
            StringBuilder sb = new StringBuilder(128);
            sb.append("displayNonAnimationImages time = ").append(gap).append(" for ").append(tcb.getTopLeftDirtyTile()).append(" to ").append(tcb.getBottomRightDirtyTile()).append(" average ").append(avg).append(" t1=").append(t1 - t0).append(" t2=").append(t2 - t1).append(" t3=").append(t3 - t2).append(" t4=").append(t4 - t3).append(" t5=").append(t5 - t4).append(" t6=").append(t6 - t5).append(" t7=").append(t7 - t6).append(" t8=").append(t8 - t7).append(" t9=").append(t9 - t8).append(" t10=").append(t10 - t9).append(" t12=").append(t12 - t10).append(" t13=").append(t13 - t12).append(" t14=").append(t14 - t13).append(" t15=").append(t15 - t14);
            logger.finest(sb.toString());
        }
    }

    private void displayDebugAiDefensiveMap(Graphics2D nonAnimationG2d, TileClippingBounds tcb) {
        AIObject aiObject;
        if (FreeColDebugger.debugShowDefenceMapForPlayer() != null && this.getFreeColServer() != null && this.getFreeColServer().getAIMain() != null && (aiObject = this.getFreeColServer().getAIMain().getAIObject(FreeColDebugger.debugShowDefenceMapForPlayer().getId())) != null && aiObject instanceof EuropeanAIPlayer) {
            EuropeanAIPlayer eap = (EuropeanAIPlayer)aiObject;
            DefensiveMap defensiveMap = DefensiveMap.createDefensiveMap(eap);
            this.paintEachTile(nonAnimationG2d, tcb.getTopLeftDirtyTile(), tcb.getBaseTiles(), (tileG2d, tile) -> {
                DefensiveZone defensiveZone = defensiveMap.getDefensiveZone(tile);
                if (defensiveZone == null) {
                    return;
                }
                if (defensiveZone.getNumberOfMilitaryEnemies() > 0) {
                    tileG2d.setColor(new Color(255, 0, 0, 150));
                } else if (defensiveZone.isEnemiesInNeighbour()) {
                    tileG2d.setColor(new Color(255, 100, 100, 150));
                } else if (defensiveZone.isExposed()) {
                    tileG2d.setColor(new Color(255, 255, 0, 150));
                } else {
                    tileG2d.setColor(new Color(0, 255, 0, 150));
                }
                tileG2d.fill(this.mapViewerScaledUtils.getFog());
            });
        }
    }

    private boolean shouldFogOfWarBeDisplayed(Player player, ClientOptions options) {
        return player != null && this.getSpecification().getBoolean("model.option.fogOfWar") && options.getBoolean("model.option.displayFogOfWar");
    }

    private void displayGrid(Graphics2D g2d, ClientOptions options, TileClippingBounds tcb) {
        if (options.getBoolean("model.option.displayGrid")) {
            AffineTransform baseTransform = g2d.getTransform();
            GeneralPath gridPath = new GeneralPath();
            gridPath.moveTo(0.0f, 0.0f);
            int nextX = this.tileBounds.getHalfWidth();
            int nextY = -this.tileBounds.getHalfHeight();
            for (int i = 0; i <= (tcb.getBottomRightDirtyTile().getX() - tcb.getTopLeftDirtyTile().getX()) * 2 + 1; ++i) {
                gridPath.lineTo(nextX, nextY);
                nextX += this.tileBounds.getHalfWidth();
                nextY = nextY == 0 ? -this.tileBounds.getHalfHeight() : 0;
            }
            g2d.setStroke(this.mapViewerScaledUtils.getGridStroke());
            g2d.setColor(Color.BLACK);
            for (int row = tcb.getTopLeftDirtyTile().getY(); row <= tcb.getBottomRightDirtyTile().getY(); ++row) {
                g2d.translate(0, this.tileBounds.getHalfHeight());
                AffineTransform rowTransform = g2d.getTransform();
                if ((row & 1) == 1) {
                    g2d.translate(this.tileBounds.getHalfWidth(), 0);
                }
                g2d.draw(gridPath);
                g2d.setTransform(rowTransform);
            }
            g2d.setTransform(baseTransform);
        }
    }

    private void paintBlackBackground(Graphics2D g2d, Rectangle rectangle) {
        g2d.setColor(Color.black);
        g2d.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void displaySettlementLabels(Graphics2D g2d, Settlement settlement, Player player, int colonyLabels, RescaleOp rop) {
        if (settlement.isDisposed()) {
            logger.warning("Settlement display race detected: " + settlement.getName());
            return;
        }
        String name = Messages.message(settlement.getLocationLabelFor(player));
        if (name == null) {
            return;
        }
        Color backgroundColor = settlement.getOwner().getNationColor();
        if (backgroundColor == null) {
            backgroundColor = Color.WHITE;
        }
        int yOffset = this.tileBounds.getHeight();
        switch (colonyLabels) {
            case 1: {
                BufferedImage img = this.lib.getStringImage(g2d, name, backgroundColor, this.mapViewerScaledUtils.getFontNormal());
                g2d.drawImage(img, rop, (this.tileBounds.getWidth() - img.getWidth()) / 2 + 1, yOffset);
                break;
            }
            default: {
                Colony colony;
                BuildableType buildable;
                backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
                TextSpecification[] specs = new TextSpecification[1];
                if (settlement instanceof Colony && settlement.getOwner() == player && (buildable = (colony = (Colony)settlement).getCurrentlyBuilding()) != null && this.mapViewerScaledUtils.getFontProduction() != null) {
                    specs = new TextSpecification[2];
                    String t = Messages.getName(buildable) + " " + Turn.getTurnsText(colony.getTurnsToComplete(buildable));
                    specs[1] = new TextSpecification(t, this.mapViewerScaledUtils.getFontProduction());
                }
                specs[0] = new TextSpecification(name, this.mapViewerScaledUtils.getFontNormal());
                BufferedImage nameImage = MapViewer.createLabel(g2d, specs, backgroundColor);
                int spacing = this.lib.scaleInt(3);
                BufferedImage leftImage = null;
                BufferedImage rightImage = null;
                if (settlement instanceof Colony) {
                    int bonusProduction;
                    Colony colony2 = (Colony)settlement;
                    String string = Integer.toString(colony2.getApparentUnitCount());
                    leftImage = MapViewer.createLabel(g2d, string, colony2.getPreferredSizeChange() > 0 ? this.mapViewerScaledUtils.getFontItalic() : this.mapViewerScaledUtils.getFontNormal(), backgroundColor);
                    if (player.owns(settlement) && (bonusProduction = colony2.getProductionBonus()) != 0) {
                        Object bonus = bonusProduction > 0 ? "+" + bonusProduction : Integer.toString(bonusProduction);
                        rightImage = MapViewer.createLabel(g2d, (String)bonus, this.mapViewerScaledUtils.getFontNormal(), backgroundColor);
                    }
                } else if (settlement instanceof IndianSettlement) {
                    Unit missionary;
                    IndianSettlement is = (IndianSettlement)settlement;
                    if (is.getType().isCapital()) {
                        leftImage = MapViewer.createCapitalLabel(nameImage.getHeight(), 5, backgroundColor);
                    }
                    if ((missionary = is.getMissionary()) != null) {
                        boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                        backgroundColor = missionary.getOwner().getNationColor();
                        backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
                        rightImage = MapViewer.createReligiousMissionLabel(nameImage.getHeight(), 5, backgroundColor, expert);
                    }
                }
                int xOffset = this.tileBounds.getWidth() / 2 - nameImage.getWidth() / 2 - (leftImage == null ? 0 : leftImage.getWidth() + spacing);
                yOffset -= nameImage.getHeight() / 2;
                if (leftImage != null) {
                    g2d.drawImage(leftImage, rop, xOffset, yOffset);
                    xOffset += leftImage.getWidth() + spacing;
                }
                g2d.drawImage(nameImage, rop, xOffset, yOffset);
                if (rightImage == null) break;
                g2d.drawImage(rightImage, rop, xOffset += nameImage.getWidth() + spacing, yOffset);
            }
        }
    }

    private static BufferedImage createCapitalLabel(int extent, int padding, Color backgroundColor) {
        double deg2rad = Math.PI / 180;
        double angle = -90.0 * deg2rad;
        double offset = (double)extent * 0.5;
        double size1 = (double)(extent - padding - padding) * 0.5;
        GeneralPath path = new GeneralPath();
        path.moveTo(Math.cos(angle) * size1 + offset, Math.sin(angle) * size1 + offset);
        for (int i = 0; i < 4; ++i) {
            path.lineTo(Math.cos(angle += 144.0 * deg2rad) * size1 + offset, Math.sin(angle) * size1 + offset);
        }
        path.closePath();
        BufferedImage bi = new BufferedImage(extent, extent, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(backgroundColor);
        g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, extent, extent, padding, padding));
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.4f, 1, 1));
        g2d.draw(path);
        g2d.setColor(Color.WHITE);
        g2d.fill(path);
        g2d.dispose();
        return bi;
    }

    private static BufferedImage createLabel(Graphics2D g2d, String text, Font font, Color backgroundColor) {
        TextSpecification[] specs = new TextSpecification[]{new TextSpecification(text, font)};
        return MapViewer.createLabel(g2d, specs, backgroundColor);
    }

    private static BufferedImage createLabel(Graphics2D g2d, TextSpecification[] textSpecs, Color backgroundColor) {
        int i;
        int hPadding = 15;
        int vPadding = 10;
        int linePadding = 5;
        int width = 0;
        int height = vPadding;
        TextLayout[] labels = new TextLayout[textSpecs.length];
        for (i = 0; i < textSpecs.length; ++i) {
            TextLayout label;
            TextSpecification spec = textSpecs[i];
            labels[i] = label = new TextLayout(spec.text, spec.font, g2d.getFontRenderContext());
            Rectangle textRectangle = label.getPixelBounds(null, 0.0f, 0.0f);
            width = Math.max(width, textRectangle.width + hPadding);
            if (i > 0) {
                height += linePadding;
            }
            height += (int)(label.getAscent() + label.getDescent());
        }
        int radius = Math.min(hPadding, vPadding);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setColor(backgroundColor);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, radius, radius));
        g2.setColor(ImageLibrary.makeForegroundColor(backgroundColor));
        float y = (float)vPadding / 2.0f;
        for (i = 0; i < labels.length; ++i) {
            Rectangle textRectangle = labels[i].getPixelBounds(null, 0.0f, 0.0f);
            float x = (float)(width - textRectangle.width) / 2.0f;
            labels[i].draw(g2, x, y += labels[i].getAscent());
            y += labels[i].getDescent() + (float)linePadding;
        }
        g2.dispose();
        return bi;
    }

    private static BufferedImage createReligiousMissionLabel(int extent, int padding, Color backgroundColor, boolean expertMissionary) {
        double offset = (double)extent * 0.5;
        double size1 = extent - padding - padding;
        double bar = size1 / 3.0;
        double inset = 0.0;
        double kludge = 0.0;
        GeneralPath circle = new GeneralPath();
        GeneralPath cross = new GeneralPath();
        if (expertMissionary) {
            circle.append(new Ellipse2D.Double(padding - 1, padding - 1, size1 + 1.0, size1 + 1.0), false);
            inset = 4.0;
            bar = (size1 - inset - inset) / 3.0;
            kludge = 1.0;
        }
        cross.moveTo(offset -= 1.0, (double)padding + inset - kludge);
        cross.lineTo(offset, (double)(extent - padding) - inset);
        cross.moveTo(offset - bar, (double)padding + bar + inset);
        cross.lineTo(offset + bar + 1.0, (double)padding + bar + inset);
        BufferedImage bi = new BufferedImage(extent, extent, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(backgroundColor);
        g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, extent, extent, padding, padding));
        g2d.setColor(ImageLibrary.makeForegroundColor(backgroundColor));
        if (expertMissionary) {
            g2d.setStroke(new BasicStroke(2.0f, 1, 1));
            g2d.draw(circle);
            g2d.setStroke(new BasicStroke(1.6f, 1, 1));
        } else {
            g2d.setStroke(new BasicStroke(2.4f, 1, 1));
        }
        g2d.draw(cross);
        g2d.dispose();
        return bi;
    }

    private void displayPath(Graphics2D g2d, PathNode path) {
        boolean debug = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.PATHS);
        PathNode p = path;
        while (p != null) {
            Point point;
            Tile tile = p.getTile();
            if (tile != null && (point = this.mapViewerBounds.calculateTilePosition(tile, false)) != null) {
                BufferedImage image = p.isOnCarrier() ? ImageLibrary.getPathImage(ImageLibrary.PathType.NAVAL) : (this.mapViewerState.getActiveUnit() != null ? ImageLibrary.getPathImage(this.mapViewerState.getActiveUnit()) : null);
                BufferedImage turns = null;
                if (this.mapViewerScaledUtils.getFontTiny() != null) {
                    if (debug) {
                        if (this.mapViewerState.getActiveUnit() != null) {
                            image = ImageLibrary.getPathNextTurnImage(this.mapViewerState.getActiveUnit());
                        }
                        turns = this.lib.getStringImage(g2d, Integer.toString(p.getTurns()) + "/" + Integer.toString(p.getMovesLeft()), Color.WHITE, this.mapViewerScaledUtils.getFontTiny());
                    } else {
                        turns = p.getTurns() <= 0 ? null : this.lib.getStringImage(g2d, Integer.toString(p.getTurns()), Color.WHITE, this.mapViewerScaledUtils.getFontTiny());
                    }
                    g2d.setColor(turns == null ? Color.GREEN : Color.RED);
                }
                g2d.translate(point.x, point.y);
                if (image == null) {
                    g2d.fillOval(this.tileBounds.getHalfWidth(), this.tileBounds.getHalfHeight(), 10, 10);
                    g2d.setColor(Color.BLACK);
                    g2d.drawOval(this.tileBounds.getHalfWidth(), this.tileBounds.getHalfHeight(), 10, 10);
                } else {
                    this.tv.displayCenteredImage(g2d, image);
                    if (turns != null) {
                        this.tv.displayCenteredImage(g2d, turns);
                    }
                }
                g2d.translate(-point.x, -point.y);
            }
            p = p.next;
        }
    }

    void displayUnit(Graphics2D g2d, Unit unit) {
        AIUnit au;
        Player player = this.getMyPlayer();
        boolean fade = unit.getState() == Unit.UnitState.SENTRY || unit.hasTile() && player != null && !player.canSee(unit.getTile());
        BufferedImage image = this.lib.getScaledUnitImage(unit, fade);
        Point p = this.calculateUnitImagePositionInTile(image);
        g2d.drawImage((Image)image, p.x, p.y, null);
        String text = Messages.message(unit.getOccupationLabel(player, false));
        g2d.drawImage((Image)this.lib.getOccupationIndicatorChip(g2d, unit, text), this.lib.scaleInt(25), 0, null);
        int unitsOnTile = 0;
        if (unit.hasTile()) {
            unitsOnTile = unit.getTile().getTotalUnitCount();
        }
        if (unitsOnTile > 1) {
            g2d.setColor(Color.WHITE);
            int unitLinesY = 1;
            int x1 = this.lib.scaleInt(20);
            int x2 = this.lib.scaleInt(23);
            for (int i = 0; i < unitsOnTile && i < 10; ++i) {
                g2d.drawLine(x1, unitLinesY, x2, unitLinesY);
                unitLinesY += 2;
            }
        }
        if (unit.getHitPoints() >= 0 && unit.getHitPoints() < unit.getMaximumHitPoints()) {
            int offsetX = this.lib.scaleInt(8);
            int hitpointsBarWidth = this.lib.scaleInt(5);
            int hitpointsBarMargin = this.lib.scaleInt(5);
            int fullHeight = this.tileBounds.getHeight() - 2 * hitpointsBarMargin;
            int filledHeight = (int)((float)fullHeight * ((float)unit.getHitPoints() / (float)unit.getMaximumHitPoints()));
            g2d.setColor(new Color(0, 255, 0, 255));
            g2d.fillRect(hitpointsBarMargin + hitpointsBarWidth + offsetX, hitpointsBarMargin - this.lib.scaleInt(20) + fullHeight - filledHeight, hitpointsBarWidth, filledHeight);
            Stroke defaultStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(this.lib.scaleInt(1)));
            g2d.setColor(Color.BLACK);
            g2d.drawRect(hitpointsBarMargin + hitpointsBarWidth + offsetX, hitpointsBarMargin - this.lib.scaleInt(20), hitpointsBarWidth, fullHeight);
            g2d.setStroke(defaultStroke);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && player != null && !player.owns(unit) && unit.getOwner().isAI() && this.getFreeColServer() != null && this.getFreeColServer().getAIMain() != null && (au = this.getFreeColServer().getAIMain().getAIUnit(unit)) != null) {
            if (FreeColDebugger.debugShowMission()) {
                g2d.setColor(Color.WHITE);
                g2d.drawString(!au.hasMission() ? "No mission" : StringUtils.lastPart(au.getMission().getClass().toString(), "."), 0, 0);
            }
            if (FreeColDebugger.debugShowMissionInfo() && au.hasMission()) {
                g2d.setColor(Color.WHITE);
                g2d.drawString(au.getMission().toString(), 0, 25);
            }
        }
    }

    private Point calculateUnitImagePositionInTile(BufferedImage unitImage) {
        int unitX = (this.tileBounds.getWidth() - unitImage.getWidth()) / 2;
        int unitY = (this.tileBounds.getHeight() - unitImage.getHeight()) / 2 - this.lib.scaleInt(20);
        return new Point(unitX, unitY);
    }

    private void displayTerritorialBorders(Graphics2D g2d, Tile tile, BorderType type, boolean opaque) {
        Player owner = tile.getOwner();
        Region region = tile.getRegion();
        if (type == BorderType.COUNTRY && owner != null || type == BorderType.REGION && region != null) {
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(this.mapViewerScaledUtils.getBorderStroke());
            Color oldColor = g2d.getColor();
            Color c = null;
            if (type == BorderType.COUNTRY) {
                c = owner.getNationColor();
            }
            if (c == null) {
                c = Color.WHITE;
            }
            Color newColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), opaque ? 255 : 100);
            g2d.setColor(newColor);
            GeneralPath path = new GeneralPath(0);
            EnumMap<Direction, Point2D.Float> borderPoints = this.mapViewerScaledUtils.getBorderPoints();
            EnumMap<Direction, Point2D.Float> controlPoints = this.mapViewerScaledUtils.getControlPoints();
            path.moveTo(borderPoints.get((Object)Direction.longSides.get((int)0)).x, borderPoints.get((Object)Direction.longSides.get((int)0)).y);
            for (Direction d : Direction.longSides) {
                Tile otherTile = tile.getNeighbourOrNull(d);
                Direction next = d.getNextDirection();
                Direction next2 = next.getNextDirection();
                if (otherTile == null || type == BorderType.COUNTRY && !owner.owns(otherTile) || type == BorderType.REGION && otherTile.getRegion() != region) {
                    Tile tile1 = tile.getNeighbourOrNull(next);
                    Tile tile2 = tile.getNeighbourOrNull(next2);
                    if (tile2 == null || type == BorderType.COUNTRY && !owner.owns(tile2) || type == BorderType.REGION && tile2.getRegion() != region) {
                        path.lineTo(borderPoints.get((Object)next).x, borderPoints.get((Object)next).y);
                        path.quadTo(controlPoints.get((Object)next).x, controlPoints.get((Object)next).y, borderPoints.get((Object)next2).x, borderPoints.get((Object)next2).y);
                        continue;
                    }
                    int dx = 0;
                    int dy = 0;
                    switch (d) {
                        case NW: {
                            dx = this.tileBounds.getHalfWidth();
                            dy = -this.tileBounds.getHalfHeight();
                            break;
                        }
                        case NE: {
                            dx = this.tileBounds.getHalfWidth();
                            dy = this.tileBounds.getHalfHeight();
                            break;
                        }
                        case SE: {
                            dx = -this.tileBounds.getHalfWidth();
                            dy = this.tileBounds.getHalfHeight();
                            break;
                        }
                        case SW: {
                            dx = -this.tileBounds.getHalfWidth();
                            dy = -this.tileBounds.getHalfHeight();
                            break;
                        }
                    }
                    if (tile1 != null && (type == BorderType.COUNTRY && owner.owns(tile1) || type == BorderType.REGION && tile1.getRegion() == region)) {
                        path.lineTo(borderPoints.get((Object)next).x, borderPoints.get((Object)next).y);
                        Direction previous = d.getPreviousDirection();
                        Direction previous2 = previous.getPreviousDirection();
                        int ddx = 0;
                        int ddy = 0;
                        switch (d) {
                            case NW: {
                                ddy = -this.tileBounds.getHeight();
                                break;
                            }
                            case NE: {
                                ddx = this.tileBounds.getWidth();
                                break;
                            }
                            case SE: {
                                ddy = this.tileBounds.getHeight();
                                break;
                            }
                            case SW: {
                                ddx = -this.tileBounds.getWidth();
                                break;
                            }
                        }
                        path.quadTo(controlPoints.get((Object)previous).x + (float)dx, controlPoints.get((Object)previous).y + (float)dy, borderPoints.get((Object)previous2).x + (float)ddx, borderPoints.get((Object)previous2).y + (float)ddy);
                        continue;
                    }
                    path.lineTo(borderPoints.get((Object)d).x + (float)dx, borderPoints.get((Object)d).y + (float)dy);
                    continue;
                }
                path.moveTo(borderPoints.get((Object)next2).x, borderPoints.get((Object)next2).y);
            }
            g2d.draw(path);
            g2d.setColor(oldColor);
            g2d.setStroke(oldStroke);
        }
    }

    private void verifyAndMarkAsClean(Dimension size, Rectangle clipBounds) {
        Rectangle entireScreen = new Rectangle(0, 0, size.width, size.height);
        Rectangle relevantDirtyClipBounds = this.rpm.getDirtyClipBounds().intersection(entireScreen);
        if (relevantDirtyClipBounds.isEmpty() || clipBounds.contains(relevantDirtyClipBounds)) {
            this.rpm.markAsClean();
        } else {
            logger.info("Repaint has been called for a smaller area than what is dirty. Have you forgotten to call repaint() after marking stuff as dirty? The only known OK instance of this happening is when the GUI is starting up. Bounds: " + clipBounds + " ==> " + relevantDirtyClipBounds);
        }
    }

    private Tile getVisibleCursorTile() {
        Tile ret = this.mapViewerState.getCursorTile();
        return this.mapViewerBounds.isTileVisible(ret) ? ret : null;
    }

    public MapViewerBounds getMapViewerBounds() {
        return this.mapViewerBounds;
    }

    public TileBounds getTileBounds() {
        return this.tileBounds;
    }

    public MapViewerState getMapViewerState() {
        return this.mapViewerState;
    }

    public MapViewerRepaintManager getMapViewerRepaintManager() {
        return this.rpm;
    }

    private void paintSingleTile(Graphics2D g2d, TileClippingBounds tcb, Tile tile, TileRenderingCallback c) {
        this.paintEachTile(g2d, tcb.getTopLeftDirtyTile(), List.of(tile), c);
    }

    private void paintEachTile(Graphics2D g2d, TileClippingBounds tcb, TileRenderingCallback c) {
        this.paintEachTile(g2d, tcb.getTopLeftDirtyTile(), tcb.getBaseTiles(), c);
    }

    private void paintEachTileWithExtendedImageSize(Graphics2D g2d, TileClippingBounds tcb, TileRenderingCallback c) {
        this.paintEachTile(g2d, tcb.getTopLeftDirtyTile(), tcb.getExtendedTiles(), c);
    }

    private void paintEachTileWithSuperExtendedImageSize(Graphics2D g2d, TileClippingBounds tcb, TileRenderingCallback c) {
        this.paintEachTile(g2d, tcb.getTopLeftDirtyTile(), tcb.getSuperExtendedTiles(), c);
    }

    private void paintEachTile(Graphics2D g2d, Map.Position firstTile, List<Tile> tiles, TileRenderingCallback c) {
        if (tiles.isEmpty()) {
            return;
        }
        int x0 = firstTile.getX();
        int y0 = firstTile.getY();
        int xt0 = 0;
        int yt0 = 0;
        for (Tile t : tiles) {
            int x = t.getX();
            int y = t.getY();
            int xt = (x - x0) * this.tileBounds.getWidth() + (y & 1) * this.tileBounds.getHalfWidth();
            int yt = (y - y0) * this.tileBounds.getHalfHeight();
            g2d.translate(xt - xt0, yt - yt0);
            xt0 = xt;
            yt0 = yt;
            c.render(g2d, t);
        }
        g2d.translate(-xt0, -yt0);
    }

    private static class TextSpecification {
        public final String text;
        public final Font font;

        public TextSpecification(String newText, Font newFont) {
            this.text = newText;
            this.font = newFont;
        }
    }

    private static interface TileRenderingCallback {
        public void render(Graphics2D var1, Tile var2);
    }

    private final class TileClippingBounds {
        private final Map.Position topLeftDirtyTile;
        private final Map.Position bottomRightDirtyTile;
        private final int clipLeftX;
        private final int clipTopY;
        private final List<Tile> baseTiles;
        private final List<Tile> unitTiles;
        private final List<Tile> extendedTiles;
        private final List<Tile> superExtendedTiles;

        private TileClippingBounds(Map map, Rectangle clipBounds) {
            int firstRowTiles = (clipBounds.y - MapViewer.this.mapViewerBounds.getTopLeftVisibleTilePoint().y) / MapViewer.this.tileBounds.getHalfHeight() - 1;
            this.clipTopY = MapViewer.this.mapViewerBounds.getTopLeftVisibleTilePoint().y + firstRowTiles * MapViewer.this.tileBounds.getHalfHeight();
            int firstRow = MapViewer.this.mapViewerBounds.getTopLeftVisibleTile().getY() + firstRowTiles;
            int firstColumnTiles = (clipBounds.x - MapViewer.this.mapViewerBounds.getTopLeftVisibleTilePoint().x) / MapViewer.this.tileBounds.getWidth() - 1;
            this.clipLeftX = MapViewer.this.mapViewerBounds.getTopLeftVisibleTilePoint().x + firstColumnTiles * MapViewer.this.tileBounds.getWidth();
            int firstColumn = MapViewer.this.mapViewerBounds.getTopLeftVisibleTile().getX() + firstColumnTiles;
            int lastRowTiles = (clipBounds.y + clipBounds.height - MapViewer.this.mapViewerBounds.getTopLeftVisibleTilePoint().y) / MapViewer.this.tileBounds.getHalfHeight();
            int lastRow = MapViewer.this.mapViewerBounds.getTopLeftVisibleTile().getY() + lastRowTiles;
            int lastColumnTiles = (clipBounds.x + clipBounds.width - MapViewer.this.mapViewerBounds.getTopLeftVisibleTilePoint().x) / MapViewer.this.tileBounds.getWidth();
            int lastColumn = MapViewer.this.mapViewerBounds.getTopLeftVisibleTile().getX() + lastColumnTiles;
            this.topLeftDirtyTile = new Map.Position(firstColumn, firstRow);
            this.bottomRightDirtyTile = new Map.Position(lastColumn, lastRow);
            int subMapWidth = this.bottomRightDirtyTile.getX() - this.topLeftDirtyTile.getX() + 1;
            int subMapHeight = this.bottomRightDirtyTile.getY() - this.topLeftDirtyTile.getY() + 1;
            this.baseTiles = map.subMap(this.topLeftDirtyTile.getX(), this.topLeftDirtyTile.getY(), subMapWidth, subMapHeight);
            this.unitTiles = map.subMap(this.topLeftDirtyTile.getX(), this.topLeftDirtyTile.getY(), subMapWidth, subMapHeight + 1);
            this.extendedTiles = map.subMap(this.topLeftDirtyTile.getX(), this.topLeftDirtyTile.getY() - 1, subMapWidth, subMapHeight + 2);
            this.superExtendedTiles = map.subMap(this.topLeftDirtyTile.getX() - 2, this.topLeftDirtyTile.getY() - 4, subMapWidth + 4, subMapHeight + 8);
        }

        public Map.Position getTopLeftDirtyTile() {
            return this.topLeftDirtyTile;
        }

        public Map.Position getBottomRightDirtyTile() {
            return this.bottomRightDirtyTile;
        }

        public List<Tile> getBaseTiles() {
            return this.baseTiles;
        }

        public List<Tile> getUnitTiles() {
            return this.unitTiles;
        }

        public List<Tile> getExtendedTiles() {
            return this.extendedTiles;
        }

        public List<Tile> getSuperExtendedTiles() {
            return this.superExtendedTiles;
        }
    }

    private static enum BorderType {
        COUNTRY,
        REGION;

    }
}

