/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.utils;

import org.aesh.utils.Config;

public class ANSIBuilder {
    private static final String ANSI_START = "\u001b[";
    private static final String ANSI_RESET = "\u001b[0m";
    private StringBuilder b;
    private TextType textType = TextType.DEFAULT;
    private Color bg = Color.DEFAULT;
    private Color text = Color.DEFAULT;
    private boolean havePrintedColor = false;

    public ANSIBuilder() {
        this.b = new StringBuilder();
    }

    public static ANSIBuilder builder() {
        return new ANSIBuilder();
    }

    private void checkColor() {
        if (!this.havePrintedColor) {
            this.havePrintedColor = true;
            this.doAppendColors();
        }
    }

    private void doAppendColors() {
        if (this.bg == Color.DEFAULT && this.text == Color.DEFAULT && this.textType == TextType.DEFAULT) {
            return;
        }
        if (this.bg == Color.DEFAULT && this.text == Color.DEFAULT) {
            this.b.append(ANSI_START).append(this.textType.value()).append("m");
        } else {
            this.b.append(ANSI_START).append(this.textType.value()).append(';').append(this.text.text()).append(';').append(this.bg.bg()).append('m');
        }
    }

    public ANSIBuilder resetColors() {
        if (this.textType == TextType.DEFAULT && this.bg == Color.DEFAULT && this.text == Color.DEFAULT) {
            return this;
        }
        this.doResetColors();
        this.b.append(ANSI_RESET);
        return this;
    }

    private void doResetColors() {
        this.textType = TextType.DEFAULT;
        this.bg = Color.DEFAULT;
        this.text = Color.DEFAULT;
    }

    public ANSIBuilder clear() {
        this.b = new StringBuilder();
        this.doResetColors();
        this.havePrintedColor = false;
        return this;
    }

    public ANSIBuilder text(Color color) {
        if (color != null && this.text != color) {
            this.text = color;
            this.havePrintedColor = false;
        }
        return this;
    }

    public ANSIBuilder textType(TextType type) {
        if (type != null && this.textType != type) {
            this.textType = type;
            this.havePrintedColor = false;
        }
        return this;
    }

    public ANSIBuilder bg(Color color) {
        if (color != null && this.bg != color) {
            this.bg = color;
            this.havePrintedColor = false;
        }
        return this;
    }

    public ANSIBuilder blackText() {
        return this.text(Color.BLACK);
    }

    public ANSIBuilder redText() {
        return this.text(Color.RED);
    }

    public ANSIBuilder greenText() {
        return this.text(Color.GREEN);
    }

    public ANSIBuilder yellowText() {
        return this.text(Color.YELLOW);
    }

    public ANSIBuilder blueText() {
        return this.text(Color.BLUE);
    }

    public ANSIBuilder magentaText() {
        return this.text(Color.MAGENTA);
    }

    public ANSIBuilder cyanText() {
        return this.text(Color.CYAN);
    }

    public ANSIBuilder whiteText() {
        return this.text(Color.WHITE);
    }

    public ANSIBuilder defaultText() {
        return this.text(Color.DEFAULT);
    }

    public ANSIBuilder blackBg() {
        return this.bg(Color.BLACK);
    }

    public ANSIBuilder redBg() {
        return this.bg(Color.RED);
    }

    public ANSIBuilder greenBg() {
        return this.bg(Color.GREEN);
    }

    public ANSIBuilder yellowBg() {
        return this.bg(Color.YELLOW);
    }

    public ANSIBuilder blueBg() {
        return this.bg(Color.BLUE);
    }

    public ANSIBuilder magentaBg() {
        return this.bg(Color.MAGENTA);
    }

    public ANSIBuilder cyanBg() {
        return this.bg(Color.CYAN);
    }

    public ANSIBuilder whiteBg() {
        return this.bg(Color.WHITE);
    }

    public ANSIBuilder defaultBg() {
        return this.bg(Color.DEFAULT);
    }

    public ANSIBuilder blackText(String text) {
        return this.text(Color.BLACK).append(text).resetColors();
    }

    public ANSIBuilder redText(String text) {
        return this.text(Color.RED).append(text).resetColors();
    }

    public ANSIBuilder greenText(String text) {
        return this.text(Color.GREEN).append(text).resetColors();
    }

    public ANSIBuilder yellowText(String text) {
        return this.text(Color.YELLOW).append(text).resetColors();
    }

    public ANSIBuilder blueText(String text) {
        return this.text(Color.BLUE).append(text).resetColors();
    }

    public ANSIBuilder magentaText(String text) {
        return this.text(Color.MAGENTA).append(text).resetColors();
    }

    public ANSIBuilder cyanText(String text) {
        return this.text(Color.CYAN).append(text).resetColors();
    }

    public ANSIBuilder whiteText(String text) {
        return this.text(Color.WHITE).append(text).resetColors();
    }

    public ANSIBuilder defaultText(String text) {
        return this.text(Color.DEFAULT).append(text).resetColors();
    }

    public ANSIBuilder blackBg(String text) {
        return this.bg(Color.BLACK).append(text).resetColors();
    }

    public ANSIBuilder redBg(String text) {
        return this.bg(Color.RED).append(text).resetColors();
    }

    public ANSIBuilder greenBg(String text) {
        return this.bg(Color.GREEN).append(text).resetColors();
    }

    public ANSIBuilder yellowBg(String text) {
        return this.bg(Color.YELLOW).append(text).resetColors();
    }

    public ANSIBuilder blueBg(String text) {
        return this.bg(Color.BLUE).append(text).resetColors();
    }

    public ANSIBuilder magentaBg(String text) {
        return this.bg(Color.MAGENTA).append(text).resetColors();
    }

    public ANSIBuilder cyanBg(String text) {
        return this.bg(Color.CYAN).append(text).resetColors();
    }

    public ANSIBuilder whiteBg(String text) {
        return this.bg(Color.WHITE).append(text).resetColors();
    }

    public ANSIBuilder defaultBg(String text) {
        return this.bg(Color.DEFAULT).append(text).resetColors();
    }

    public ANSIBuilder append(String data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(int data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(char data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(CharSequence data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(char[] data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(Object data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(StringBuilder data) {
        this.checkColor();
        this.b.append((CharSequence)data);
        return this;
    }

    public ANSIBuilder append(float data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(double data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder append(long data) {
        this.checkColor();
        this.b.append(data);
        return this;
    }

    public ANSIBuilder bold() {
        return this.textType(TextType.BOLD);
    }

    public ANSIBuilder boldOff() {
        return this.textType(TextType.BOLD_OFF);
    }

    public ANSIBuilder faint() {
        return this.textType(TextType.FAINT);
    }

    public ANSIBuilder faintOff() {
        return this.textType(TextType.DEFAULT);
    }

    public ANSIBuilder italic() {
        return this.textType(TextType.ITALIC);
    }

    public ANSIBuilder italicOff() {
        return this.textType(TextType.ITALIC_OFF);
    }

    public ANSIBuilder underline() {
        return this.textType(TextType.UNDERLINE);
    }

    public ANSIBuilder underlineOff() {
        return this.textType(TextType.UNDERLINE_OFF);
    }

    public ANSIBuilder blink() {
        return this.textType(TextType.BLINK);
    }

    public ANSIBuilder blinkOff() {
        return this.textType(TextType.BLINK_OFF);
    }

    public ANSIBuilder invert() {
        return this.textType(TextType.INVERT);
    }

    public ANSIBuilder invertOff() {
        return this.textType(TextType.INVERT_OFF);
    }

    public ANSIBuilder conceal() {
        return this.textType(TextType.CONCEAL);
    }

    public ANSIBuilder concealOff() {
        return this.textType(TextType.CONCEAL_OFF);
    }

    public ANSIBuilder crossedOut() {
        return this.textType(TextType.CROSSED_OUT);
    }

    public ANSIBuilder crossedOutOff() {
        return this.textType(TextType.CROSSED_OUT_OFF);
    }

    public ANSIBuilder newline() {
        this.b.append(Config.getLineSeparator());
        return this;
    }

    public ANSIBuilder bold(String text) {
        return this.textType(TextType.BOLD).append(text).textType(TextType.BOLD_OFF);
    }

    public ANSIBuilder faint(String text) {
        return this.textType(TextType.FAINT).append(text).textType(TextType.DEFAULT);
    }

    public ANSIBuilder italic(String text) {
        return this.textType(TextType.ITALIC).append(text).textType(TextType.ITALIC_OFF);
    }

    public ANSIBuilder underline(String text) {
        return this.textType(TextType.UNDERLINE).append(text).textType(TextType.UNDERLINE_OFF);
    }

    public ANSIBuilder blink(String text) {
        return this.textType(TextType.BLINK).append(text).textType(TextType.BLINK_OFF);
    }

    public ANSIBuilder invert(String text) {
        return this.textType(TextType.INVERT).append(text).textType(TextType.INVERT_OFF);
    }

    public ANSIBuilder conceal(String text) {
        return this.textType(TextType.CONCEAL).append(text).textType(TextType.CONCEAL_OFF);
    }

    public ANSIBuilder crossedOut(String text) {
        return this.textType(TextType.CROSSED_OUT).append(text).textType(TextType.CROSSED_OUT_OFF);
    }

    public String toString() {
        this.resetColors();
        return this.b.toString();
    }

    public static enum TextType {
        DEFAULT(0),
        BOLD(1),
        FAINT(2),
        ITALIC(3),
        UNDERLINE(4),
        BLINK(5),
        INVERT(7),
        CONCEAL(8),
        CROSSED_OUT(9),
        UNDERLINE_DOUBLE(21),
        BOLD_OFF(22),
        ITALIC_OFF(23),
        UNDERLINE_OFF(24),
        BLINK_OFF(25),
        INVERT_OFF(27),
        CONCEAL_OFF(28),
        CROSSED_OUT_OFF(29);

        private final int value;

        private TextType(int c) {
            this.value = c;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Color {
        BLACK(0),
        RED(1),
        GREEN(2),
        YELLOW(3),
        BLUE(4),
        MAGENTA(5),
        CYAN(6),
        WHITE(7),
        DEFAULT(9);

        private final int value;

        private Color(int index) {
            this.value = index;
        }

        public String toString() {
            return this.name();
        }

        public int value() {
            return this.value;
        }

        public int text() {
            return this.value + 30;
        }

        public int bg() {
            return this.value + 40;
        }
    }
}

