/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.nio.file.Path;
import java.util.Map;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.ProvisioningImpl;
import org.jboss.galleon.core.builder.LocalFP;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;

public class ProvisioningBuilder {
    private Path installationHome;
    private MessageWriter messageWriter;
    private final UniverseResolver resolver;
    private boolean logTime;
    private boolean recordState = true;
    private final String coreVersion;
    private final Map<FeaturePackLocation.FPID, LocalFP> locals;

    ProvisioningBuilder(UniverseResolver resolver, Map<FeaturePackLocation.FPID, LocalFP> locals, String coreVersion) throws ProvisioningException {
        this.resolver = resolver;
        this.locals = locals;
        this.coreVersion = coreVersion;
    }

    public ProvisioningBuilder setInstallationHome(Path installationHome) {
        this.installationHome = installationHome;
        return this;
    }

    public ProvisioningBuilder setMessageWriter(MessageWriter messageWriter) {
        this.messageWriter = messageWriter;
        return this;
    }

    public ProvisioningBuilder setLogTime(boolean logTime) {
        this.logTime = logTime;
        return this;
    }

    public ProvisioningBuilder setRecordState(boolean recordState) {
        this.recordState = recordState;
        return this;
    }

    public Provisioning build() throws ProvisioningException {
        return new ProvisioningImpl(this);
    }

    public Path getInstallationHome() {
        return this.installationHome;
    }

    public MessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    public boolean isLogTime() {
        return this.logTime;
    }

    public boolean isRecordState() {
        return this.recordState;
    }

    UniverseResolver getUniverseResolver() throws ProvisioningException {
        return this.resolver;
    }

    Map<FeaturePackLocation.FPID, LocalFP> getLocals() {
        return this.locals;
    }

    public String getGalleonCoreVersion() {
        return this.coreVersion;
    }
}

