/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.stream.Stream;
import org.gradle.internal.snapshot.AbstractInvalidateChildHandler;
import org.gradle.internal.snapshot.AbstractStorePathRelationshipHandler;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public class SingletonChildMap<T>
implements ChildMap<T> {
    private final ChildMap.Entry<T> entry;

    public SingletonChildMap(String path, T child) {
        this(new ChildMap.Entry<T>(path, child));
    }

    public SingletonChildMap(ChildMap.Entry<T> entry) {
        this.entry = entry;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Stream<ChildMap.Entry<T>> stream() {
        return Stream.of(this.entry);
    }

    @Override
    public <R> R withNode(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.NodeHandler<T, R> handler) {
        return this.entry.withNode(targetPath, caseSensitivity, handler);
    }

    @Override
    public <RESULT> ChildMap<RESULT> invalidate(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, ChildMap.InvalidationHandler<T, RESULT> handler) {
        return (ChildMap)this.entry.withNode(targetPath, caseSensitivity, new AbstractInvalidateChildHandler<T, RESULT>(handler){

            @Override
            public SingletonChildMap<RESULT> getChildMap() {
                return SingletonChildMap.this;
            }

            @Override
            public ChildMap<RESULT> withReplacedChild(RESULT newChild) {
                return this.withReplacedChild(SingletonChildMap.this.entry.getPath(), newChild);
            }

            @Override
            public ChildMap<RESULT> withReplacedChild(String newChildPath, RESULT newChild) {
                return ((SingletonChildMap)this.getChildMap()).withReplacedChild(newChildPath, newChild);
            }

            @Override
            public ChildMap<RESULT> withRemovedChild() {
                return EmptyChildMap.getInstance();
            }
        });
    }

    @Override
    public ChildMap<T> store(VfsRelativePath targetPath, final CaseSensitivity caseSensitivity, ChildMap.StoreHandler<T> storeHandler) {
        return (ChildMap)this.entry.handlePath(targetPath, caseSensitivity, new AbstractStorePathRelationshipHandler<T>(caseSensitivity, storeHandler){

            @Override
            public ChildMap<T> withReplacedChild(T newChild) {
                return this.withReplacedChild(SingletonChildMap.this.entry.getPath(), newChild);
            }

            @Override
            public ChildMap<T> withReplacedChild(String newChildPath, T newChild) {
                return SingletonChildMap.this.withReplacedChild(newChildPath, newChild);
            }

            @Override
            public ChildMap<T> withNewChild(String newChildPath, T newChild) {
                return SingletonChildMap.this.withNewChild(caseSensitivity, newChildPath, newChild);
            }
        });
    }

    private ChildMap<T> withNewChild(CaseSensitivity caseSensitivity, String newChildPath, T newChild) {
        ChildMap.Entry<T> newEntry = new ChildMap.Entry<T>(newChildPath, newChild);
        return ChildMapFactory.childMap(caseSensitivity, this.entry, newEntry);
    }

    private <RESULT> ChildMap<RESULT> withReplacedChild(String newPath, RESULT newChild) {
        if (this.entry.getPath().equals(newPath) && this.entry.getValue().equals(newChild)) {
            return this.castThis();
        }
        return new SingletonChildMap<RESULT>(newPath, newChild);
    }

    private <RESULT> SingletonChildMap<RESULT> castThis() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingletonChildMap that = (SingletonChildMap)o;
        return this.entry.equals(that.entry);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public String toString() {
        return this.entry.toString();
    }
}

