/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionEditor;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionRenderer;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberConflictResolverColumnModel
extends DefaultTableColumnModel {
    private final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
    private final transient PrimitiveRenderer primitiveRenderer = new MemberRenderer();
    private final transient TableCellRenderer tableRenderer = (table, value, isSelected, hasFocus, row, column) -> RelationMemberConflictResolverColumnModel.setColors(this.defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column), table, isSelected, row);

    public RelationMemberConflictResolverColumnModel() {
        this.createColumns();
    }

    private static Component setColors(Component comp, JTable table, boolean isSelected, int row) {
        if (table.getModel() instanceof RelationMemberConflictResolverModel) {
            RelationMemberConflictResolverModel model = (RelationMemberConflictResolverModel)table.getModel();
            if (!isSelected && comp != null) {
                switch (model.getDecision(row).getDecision()) {
                    case UNDECIDED: {
                        comp.setForeground(ConflictColors.FGCOLOR_UNDECIDED.get());
                        comp.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
                        break;
                    }
                    case KEEP: {
                        comp.setForeground(ConflictColors.FGCOLOR_MEMBER_KEEP.get());
                        comp.setBackground(ConflictColors.BGCOLOR_MEMBER_KEEP.get());
                        break;
                    }
                    case REMOVE: {
                        comp.setForeground(ConflictColors.FGCOLOR_MEMBER_REMOVE.get());
                        comp.setBackground(ConflictColors.BGCOLOR_MEMBER_REMOVE.get());
                    }
                }
            }
        }
        return comp;
    }

    protected final void createColumns() {
        AutoCompletingTextField roleEditor = new AutoCompletingTextField(0, false);
        RelationMemberConflictDecisionRenderer decisionRenderer = new RelationMemberConflictDecisionRenderer();
        RelationMemberConflictDecisionEditor decisionEditor = new RelationMemberConflictDecisionEditor();
        TableColumn col = new TableColumn(0);
        col.setHeaderValue("Relation");
        col.setResizable(true);
        col.setWidth(100);
        col.setPreferredWidth(100);
        col.setCellRenderer(this.primitiveRenderer);
        this.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue(I18n.tr("Pos.", new Object[0]));
        col.setResizable(true);
        col.setWidth(40);
        col.setPreferredWidth(40);
        col.setCellRenderer(this.tableRenderer);
        col.setMaxWidth(50);
        this.addColumn(col);
        col = new TableColumn(2);
        col.setHeaderValue(I18n.tr("Role", new Object[0]));
        col.setResizable(true);
        col.setCellRenderer(this.tableRenderer);
        col.setCellEditor(roleEditor);
        col.setWidth(50);
        col.setPreferredWidth(50);
        this.addColumn(col);
        col = new TableColumn(3);
        col.setHeaderValue(I18n.tr("Orig. Way", new Object[0]));
        col.setResizable(true);
        col.setCellRenderer(this.primitiveRenderer);
        col.setWidth(100);
        col.setPreferredWidth(100);
        this.addColumn(col);
        col = new TableColumn(4);
        col.setHeaderValue(I18n.tr("Decision", new Object[0]));
        col.setResizable(true);
        col.setCellRenderer(decisionRenderer);
        col.setCellEditor(decisionEditor);
        col.setWidth(100);
        col.setPreferredWidth(100);
        col.setMaxWidth(100);
        this.addColumn(col);
    }

    static final class MemberRenderer
    extends PrimitiveRenderer {
        MemberRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return RelationMemberConflictResolverColumnModel.setColors(super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column), table, isSelected, row);
        }
    }
}

