/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassInput;

class AttributeEntry {
    private int attribute_name_index;
    private ClassFormatOutput infoOut;
    byte[] infoIn;

    AttributeEntry(int name_index, ClassFormatOutput info) {
        this.attribute_name_index = name_index;
        this.infoOut = info;
    }

    AttributeEntry(ClassInput in) throws IOException {
        this.attribute_name_index = in.getU2();
        this.infoIn = in.getU1Array(in.getU4());
    }

    int getNameIndex() {
        return this.attribute_name_index;
    }

    void put(ClassFormatOutput out) throws IOException {
        out.putU2(this.attribute_name_index);
        if (this.infoOut != null) {
            out.putU4(this.infoOut.size());
            this.infoOut.writeTo(out);
        } else {
            out.putU4(this.infoIn.length);
            out.write(this.infoIn);
        }
    }

    int classFileSize() {
        return 6 + (this.infoOut != null ? this.infoOut.size() : this.infoIn.length);
    }
}

