/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class UnaryDateTimestampOperatorNode
extends UnaryOperatorNode {
    private static final String TIMESTAMP_METHOD_NAME = "getTimestamp";
    private static final String DATE_METHOD_NAME = "getDate";
    static final int K_DATE = 0;
    static final int K_TIMESTAMP = 1;
    final int kind;

    UnaryDateTimestampOperatorNode(ValueNode operand, int kind, ContextManager cm) throws StandardException {
        super(operand, kind == 0 ? "date" : "timestamp", kind == 0 ? DATE_METHOD_NAME : TIMESTAMP_METHOD_NAME, cm);
        this.kind = kind;
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(kind == 0 ? 91 : 93));
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        boolean isIdentity = false;
        boolean operandIsNumber = false;
        this.bindOperand(fromList, subqueryList, aggregates);
        DataTypeDescriptor operandType = this.operand.getTypeServices();
        switch (operandType.getJDBCTypeId()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                operandIsNumber = true;
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 91: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                isIdentity = true;
                break;
            }
            case 0: {
                break;
            }
            case 93: {
                if (!TIMESTAMP_METHOD_NAME.equals(this.methodName)) break;
                isIdentity = true;
                break;
            }
            default: {
                this.invalidOperandType();
            }
        }
        if (this.operand instanceof ConstantNode) {
            DataValueFactory dvf = this.getLanguageConnectionContext().getDataValueFactory();
            DataValueDescriptor sourceValue = ((ConstantNode)this.operand).getValue();
            DateTimeDataValue destValue = sourceValue.isNull() ? (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dvf.getNullTimestamp(null) : dvf.getNullDate(null)) : (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dvf.getTimestamp(sourceValue) : dvf.getDate(sourceValue));
            return new UserTypeConstantNode(destValue, this.getContextManager());
        }
        if (isIdentity) {
            return this.operand;
        }
        return this;
    }

    private void invalidOperandType() throws StandardException {
        throw StandardException.newException((String)"42X25", (Object[])new Object[]{this.getOperatorString(), this.getOperand().getTypeServices().getSQLstring()});
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushDataValueFactory(mb);
        this.operand.generateExpression(acb, mb);
        mb.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.callMethod((short)185, null, this.methodName, this.getTypeCompiler().interfaceName(), 1);
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((UnaryDateTimestampOperatorNode)o).kind == this.kind;
    }
}

