/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.RuleStatusInfo;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.TriggerHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.automation.internal.composite.AbstractCompositeModuleHandler;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.util.ReferenceResolver;

@NonNullByDefault
public class CompositeTriggerHandler
extends AbstractCompositeModuleHandler<Trigger, CompositeTriggerType, TriggerHandler>
implements TriggerHandler,
TriggerHandlerCallback {
    @NonNullByDefault(value={})
    private TriggerHandlerCallback callback;

    public CompositeTriggerHandler(Trigger trigger, CompositeTriggerType mt, LinkedHashMap<Trigger, @Nullable TriggerHandler> mapModuleToHandler, String ruleUID) {
        super(trigger, mt, mapModuleToHandler);
    }

    @Override
    public void triggered(Trigger trigger, Map<String, ?> context) {
        if (this.callback != null) {
            List<Output> outputs = ((CompositeTriggerType)this.moduleType).getOutputs();
            HashMap result = new HashMap(11);
            for (Output output : outputs) {
                String refs = output.getReference();
                if (refs == null) continue;
                StringTokenizer st = new StringTokenizer(refs, ",");
                while (st.hasMoreTokens()) {
                    Object value;
                    int idx;
                    String ref = st.nextToken().trim();
                    int i = ref.indexOf(46);
                    if (i != -1) {
                        String childModuleId = ref.substring(0, i);
                        if (trigger.getId().equals(childModuleId)) {
                            ref = ref.substring(i + 1);
                        }
                    }
                    if ((idx = ReferenceResolver.getNextRefToken(ref, 1)) < ref.length()) {
                        String outputId = ref.substring(0, idx);
                        value = ReferenceResolver.resolveComplexDataReference(context.get(outputId), ref.substring(idx + 1));
                    } else {
                        value = context.get(ref);
                    }
                    if (value == null) continue;
                    result.put(output.getName(), value);
                }
            }
            this.callback.triggered((Trigger)this.module, result);
        }
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.callback.getScheduler();
    }

    @Override
    public void setCallback(@Nullable ModuleHandlerCallback callback) {
        this.callback = (TriggerHandlerCallback)callback;
        if (callback instanceof TriggerHandlerCallback) {
            List<Trigger> children = this.getChildren();
            for (Trigger child : children) {
                TriggerHandler handler = (TriggerHandler)this.moduleHandlerMap.get(child);
                if (handler == null) continue;
                handler.setCallback(this);
            }
        }
    }

    @Override
    public void dispose() {
        this.setCallback(null);
        super.dispose();
    }

    @Override
    protected List<Trigger> getChildren() {
        return ((CompositeTriggerType)this.moduleType).getChildren();
    }

    @Override
    public @Nullable Boolean isEnabled(String ruleUID) {
        return this.callback.isEnabled(ruleUID);
    }

    @Override
    public void setEnabled(String uid, boolean isEnabled) {
        this.callback.setEnabled(uid, isEnabled);
    }

    @Override
    public @Nullable RuleStatusInfo getStatusInfo(String ruleUID) {
        return this.callback.getStatusInfo(ruleUID);
    }

    @Override
    public @Nullable RuleStatus getStatus(String ruleUID) {
        return this.callback.getStatus(ruleUID);
    }

    @Override
    public void runNow(String uid) {
        this.callback.runNow(uid);
    }

    @Override
    public void runNow(String uid, boolean considerConditions, @Nullable Map<String, Object> context) {
        this.callback.runNow(uid, considerConditions, context);
    }
}

