/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.common;

import java.util.Locale;
import lombok.Generated;
import org.opensearch.knn.index.VectorDataType;

public class KNNValidationUtil {
    public static void validateFloatVectorValue(float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("KNN vector values cannot be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException("KNN vector values cannot be infinity");
        }
    }

    public static void validateByteVectorValue(float value, VectorDataType dataType) {
        KNNValidationUtil.validateFloatVectorValue(value);
        if (value % 1.0f != 0.0f) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field was set as [%s] in index mapping. But, KNN vector values are floats instead of byte integers", "data_type", dataType.getValue()));
        }
        if ((int)value < -128 || (int)value > 127) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field was set as [%s] in index mapping. But, KNN vector values are not within in the byte range [%d, %d]", "data_type", dataType.getValue(), (byte)-128, (byte)127));
        }
    }

    public static void validateVectorDimension(int dimension, int vectorSize, VectorDataType dataType) {
        int actualDimension;
        int n = actualDimension = VectorDataType.BINARY == dataType ? vectorSize * 8 : vectorSize;
        if (dimension != actualDimension) {
            if (VectorDataType.BINARY == dataType) {
                String errorMessage = String.format(Locale.ROOT, "The dimension of the binary vector must be 8 times the length of the provided vector. Expected: %d, Given: %d", dimension, actualDimension);
                throw new IllegalArgumentException(errorMessage);
            }
            String errorMessage = String.format(Locale.ROOT, "Vector dimension mismatch. Expected: %d, Given: %d", dimension, actualDimension);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Generated
    private KNNValidationUtil() {
    }
}

