/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.yaml.YamlXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.util.ParseUtils;

public class Template
implements ToXContentObject {
    public static final String WORKFLOWS_FIELD = "workflows";
    public static final String COMPATIBILITY_FIELD = "compatibility";
    public static final String TEMPLATE_FIELD = "template";
    public static final String USE_CASE_FIELD = "use_case";
    public static final Set<String> UPDATE_FIELD_ALLOWLIST = Set.of("name", "description", "use_case", "version", "ui_metadata");
    private final String name;
    private final String description;
    private final String useCase;
    private final Version templateVersion;
    private final List<Version> compatibilityVersion;
    private final Map<String, Workflow> workflows;
    private final Map<String, Object> uiMetadata;
    private final User user;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final Instant lastProvisionedTime;
    private String tenantId;

    public Template(String name, String description, String useCase, Version templateVersion, List<Version> compatibilityVersion, Map<String, Workflow> workflows, Map<String, Object> uiMetadata, User user, Instant createdTime, Instant lastUpdatedTime, Instant lastProvisionedTime, String tenantId) {
        this.name = name;
        this.description = description;
        this.useCase = useCase;
        this.templateVersion = templateVersion;
        this.compatibilityVersion = List.copyOf(compatibilityVersion);
        this.workflows = Map.copyOf(workflows);
        this.uiMetadata = uiMetadata;
        this.user = user;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.lastProvisionedTime = lastProvisionedTime;
        this.tenantId = tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Template t) {
        return new Builder(t);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field("name", this.name.trim());
        xContentBuilder.field("description", this.description == null ? "" : this.description.trim());
        xContentBuilder.field(USE_CASE_FIELD, this.useCase == null ? "" : this.useCase.trim());
        if (this.templateVersion != null || !this.compatibilityVersion.isEmpty()) {
            xContentBuilder.startObject("version");
            if (this.templateVersion != null) {
                xContentBuilder.field(TEMPLATE_FIELD, (ToXContent)this.templateVersion);
            }
            if (!this.compatibilityVersion.isEmpty()) {
                xContentBuilder.startArray(COMPATIBILITY_FIELD);
                for (Version v : this.compatibilityVersion) {
                    xContentBuilder.value((Object)v);
                }
                xContentBuilder.endArray();
            }
            xContentBuilder.endObject();
        }
        xContentBuilder.startObject(WORKFLOWS_FIELD);
        for (Map.Entry<String, Workflow> e : this.workflows.entrySet()) {
            xContentBuilder.field(e.getKey(), (ToXContent)e.getValue(), params);
        }
        xContentBuilder.endObject();
        if (this.uiMetadata != null && !this.uiMetadata.isEmpty()) {
            xContentBuilder.field("ui_metadata", this.uiMetadata);
        }
        if (this.user != null) {
            xContentBuilder.field("user", (ToXContent)this.user);
        }
        if (this.createdTime != null) {
            xContentBuilder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            xContentBuilder.field("last_updated_time", this.lastUpdatedTime.toEpochMilli());
        }
        if (this.lastProvisionedTime != null) {
            xContentBuilder.field("last_provisioned_time", this.lastProvisionedTime.toEpochMilli());
        }
        if (this.tenantId != null) {
            xContentBuilder.field("tenant_id", this.tenantId);
        }
        return xContentBuilder.endObject();
    }

    public static Template updateExistingTemplate(Template existingTemplate, Template templateWithNewFields) {
        Builder builder = Template.builder(existingTemplate).lastUpdatedTime(Instant.now());
        if (templateWithNewFields.name() != null) {
            builder.name(templateWithNewFields.name());
        }
        if (Strings.hasText((String)templateWithNewFields.description())) {
            builder.description(templateWithNewFields.description());
        }
        if (Strings.hasText((String)templateWithNewFields.useCase())) {
            builder.useCase(templateWithNewFields.useCase());
        }
        if (templateWithNewFields.templateVersion() != null) {
            builder.templateVersion(templateWithNewFields.templateVersion());
        }
        if (!templateWithNewFields.compatibilityVersion().isEmpty()) {
            builder.compatibilityVersion(templateWithNewFields.compatibilityVersion());
        }
        if (templateWithNewFields.getUiMetadata() != null) {
            builder.uiMetadata(templateWithNewFields.getUiMetadata());
        }
        return builder.build();
    }

    public static Template parse(XContentParser parser) throws IOException {
        return Template.parse(parser, false);
    }

    public static Template parse(XContentParser parser, boolean fieldUpdate) throws IOException {
        String name = null;
        String description = null;
        String useCase = null;
        Version templateVersion = null;
        ArrayList<Version> compatibilityVersion = new ArrayList<Version>();
        HashMap<String, Workflow> workflows = new HashMap<String, Workflow>();
        Map uiMetadata = null;
        User user = null;
        Instant createdTime = null;
        Instant lastUpdatedTime = null;
        Instant lastProvisionedTime = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block34: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            if (fieldUpdate && !UPDATE_FIELD_ALLOWLIST.contains(fieldName)) {
                throw new FlowFrameworkException("You can not update the field [" + fieldName + "] without updating the whole template.", RestStatus.BAD_REQUEST);
            }
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block34;
                }
                case "description": {
                    description = parser.text();
                    continue block34;
                }
                case "use_case": {
                    useCase = parser.text();
                    continue block34;
                }
                case "version": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    block35: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String versionFieldName = parser.currentName();
                        parser.nextToken();
                        switch (versionFieldName) {
                            case "template": {
                                templateVersion = Version.fromString((String)parser.text());
                                continue block35;
                            }
                            case "compatibility": {
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    compatibilityVersion.add(Version.fromString((String)parser.text()));
                                }
                                continue block35;
                            }
                        }
                        throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a version object.", RestStatus.BAD_REQUEST);
                    }
                    continue block34;
                }
                case "workflows": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String workflowFieldName = parser.currentName();
                        parser.nextToken();
                        workflows.put(workflowFieldName, Workflow.parse(parser));
                    }
                    continue block34;
                }
                case "ui_metadata": {
                    uiMetadata = parser.map();
                    continue block34;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block34;
                }
                case "created_time": {
                    createdTime = ParseUtils.parseInstant(parser);
                    continue block34;
                }
                case "last_updated_time": {
                    lastUpdatedTime = ParseUtils.parseInstant(parser);
                    continue block34;
                }
                case "last_provisioned_time": {
                    lastProvisionedTime = ParseUtils.parseInstant(parser);
                    continue block34;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block34;
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a template object.", RestStatus.BAD_REQUEST);
        }
        if (!fieldUpdate) {
            if (name == null) {
                throw new FlowFrameworkException("A template object requires a name.", RestStatus.BAD_REQUEST);
            }
            if (description == null) {
                description = "";
            }
            if (useCase == null) {
                useCase = "";
            }
        }
        Template template = new Builder().name(name).description(description).useCase(useCase).templateVersion(templateVersion).compatibilityVersion(compatibilityVersion).workflows(workflows).uiMetadata(uiMetadata).user(user).createdTime(createdTime).lastUpdatedTime(lastUpdatedTime).lastProvisionedTime(lastProvisionedTime).tenantId(tenantId).build();
        return template;
    }

    public static Template parse(String json) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, json);){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            Template template = Template.parse(parser);
            return template;
        }
    }

    public static Template createEmptyTemplateWithTenantId(String tenantId) {
        if (tenantId == null) {
            return null;
        }
        Template emptyTemplate = Template.builder().name("").tenantId(tenantId).build();
        return emptyTemplate;
    }

    public String toJson() {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            return this.toXContent(builder, EMPTY_PARAMS).toString();
        }
        catch (IOException e) {
            return "{\"error\": \"couldn't create JSON from XContent\"}";
        }
    }

    public String toYaml() {
        try {
            XContentBuilder builder = YamlXContent.contentBuilder();
            return this.toXContent(builder, EMPTY_PARAMS).toString();
        }
        catch (IOException e) {
            return "error: couldn't create YAML from XContent";
        }
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String useCase() {
        return this.useCase;
    }

    public Version templateVersion() {
        return this.templateVersion;
    }

    public List<Version> compatibilityVersion() {
        return this.compatibilityVersion;
    }

    public Map<String, Workflow> workflows() {
        return this.workflows;
    }

    public Map<String, Object> getUiMetadata() {
        return this.uiMetadata;
    }

    public User getUser() {
        return this.user;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Instant lastProvisionedTime() {
        return this.lastProvisionedTime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String toString() {
        return "Template [name=" + this.name + ", description=" + this.description + ", useCase=" + this.useCase + ", templateVersion=" + String.valueOf(this.templateVersion) + ", compatibilityVersion=" + String.valueOf(this.compatibilityVersion) + ", workflows=" + String.valueOf(this.workflows) + ", uiMedata=" + String.valueOf(this.uiMetadata == null ? "{}" : this.uiMetadata) + "]";
    }

    public static class Builder {
        private String name = null;
        private String description = "";
        private String useCase = "";
        private Version templateVersion = null;
        private List<Version> compatibilityVersion = Collections.emptyList();
        private Map<String, Workflow> workflows = Collections.emptyMap();
        private Map<String, Object> uiMetadata = null;
        private User user = null;
        private Instant createdTime = null;
        private Instant lastUpdatedTime = null;
        private Instant lastProvisionedTime = null;
        private String tenantId = null;

        private Builder() {
        }

        private Builder(Template t) {
            this.name = t.name();
            this.description = t.description();
            this.useCase = t.useCase();
            this.templateVersion = t.templateVersion;
            if (t.compatibilityVersion() != null) {
                this.compatibilityVersion = List.copyOf(t.compatibilityVersion());
            }
            if (t.workflows() != null) {
                this.workflows = Map.copyOf(t.workflows());
            }
            if (t.getUiMetadata() != null) {
                this.uiMetadata = Map.copyOf(t.getUiMetadata());
            }
            this.user = t.getUser();
            this.createdTime = t.createdTime();
            this.lastUpdatedTime = t.lastUpdatedTime();
            this.lastProvisionedTime = t.lastProvisionedTime();
            this.tenantId = t.getTenantId();
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder useCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        public Builder templateVersion(Version templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public Builder compatibilityVersion(List<Version> compatibilityVersion) {
            this.compatibilityVersion = compatibilityVersion;
            return this;
        }

        public Builder workflows(Map<String, Workflow> workflows) {
            this.workflows = workflows;
            return this;
        }

        public Builder uiMetadata(Map<String, Object> uiMetadata) {
            this.uiMetadata = uiMetadata;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public Builder lastProvisionedTime(Instant lastProvisionedTime) {
            this.lastProvisionedTime = lastProvisionedTime;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Template build() {
            return new Template(this.name, this.description, this.useCase, this.templateVersion, this.compatibilityVersion, this.workflows, this.uiMetadata, this.user, this.createdTime, this.lastUpdatedTime, this.lastProvisionedTime, this.tenantId);
        }
    }
}

