/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.opensearch.common.io.Channels;
import org.opensearch.index.translog.BaseTranslogReader;
import org.opensearch.index.translog.BufferedChecksumStreamInput;
import org.opensearch.index.translog.Checkpoint;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogCorruptedException;

final class TranslogSnapshot
extends BaseTranslogReader {
    private final int totalOperations;
    private final Checkpoint checkpoint;
    protected final long length;
    private final ByteBuffer reusableBuffer;
    private long position;
    private int skippedOperations;
    private int readOperations;
    private BufferedChecksumStreamInput reuse;

    TranslogSnapshot(BaseTranslogReader reader, long length) {
        super(reader.generation, reader.channel, reader.path, reader.header);
        this.length = length;
        this.totalOperations = reader.totalOperations();
        this.checkpoint = reader.getCheckpoint();
        this.reusableBuffer = ByteBuffer.allocate(1024);
        this.readOperations = 0;
        this.position = reader.getFirstOperationOffset();
        this.reuse = null;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    int skippedOperations() {
        return this.skippedOperations;
    }

    @Override
    Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public Translog.Operation next() throws IOException {
        while (this.readOperations < this.totalOperations) {
            Translog.Operation operation = this.readOperation();
            if (operation.seqNo() <= this.checkpoint.trimmedAboveSeqNo || this.checkpoint.trimmedAboveSeqNo == -2L) {
                return operation;
            }
            ++this.skippedOperations;
        }
        return null;
    }

    private Translog.Operation readOperation() throws IOException {
        int opSize = this.readSize(this.reusableBuffer, this.position);
        this.reuse = this.checksummedStream(this.reusableBuffer, this.position, opSize, this.reuse);
        Translog.Operation op = this.read(this.reuse);
        this.position += (long)opSize;
        ++this.readOperations;
        return op;
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        try {
            if (position >= this.length) {
                throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "], generation: [" + this.getGeneration() + "], path: [" + String.valueOf(this.path) + "]");
            }
            if (position < this.getFirstOperationOffset()) {
                throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.getFirstOperationOffset() + "], generation: [" + this.getGeneration() + "], path: [" + String.valueOf(this.path) + "]");
            }
            Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
        }
        catch (EOFException e) {
            throw new TranslogCorruptedException(this.path.toString(), "translog truncated", e);
        }
    }

    @Override
    public String toString() {
        return "TranslogSnapshot{readOperations=" + this.readOperations + ", position=" + this.position + ", estimateTotalOperations=" + this.totalOperations + ", length=" + this.length + ", generation=" + this.generation + ", reusableBuffer=" + String.valueOf(this.reusableBuffer) + "}";
    }
}

