/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.support.RetryableAction;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.SendRequestTransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public final class RetryableTransportClient {
    private final ThreadPool threadPool;
    private final Map<Object, RetryableAction<?>> onGoingRetryableActions = ConcurrentCollections.newConcurrentMap();
    private volatile boolean isCancelled = false;
    private final TransportService transportService;
    private final TimeValue retryTimeout;
    private final DiscoveryNode targetNode;
    private final Logger logger;

    public RetryableTransportClient(TransportService transportService, DiscoveryNode targetNode, TimeValue retryTimeout, Logger logger) {
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.retryTimeout = retryTimeout;
        this.targetNode = targetNode;
        this.logger = logger;
    }

    public <T extends TransportResponse> void executeRetryableAction(String action, TransportRequest request, ActionListener<T> actionListener, Writeable.Reader<T> reader) {
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.retryTimeout).build();
        this.executeRetryableAction(action, request, options, actionListener, reader);
    }

    public <T extends TransportResponse> void executeRetryableAction(final String action, final TransportRequest request, final TransportRequestOptions options, ActionListener<T> actionListener, final Writeable.Reader<T> reader) {
        Object key = new Object();
        ActionListener removeListener = ActionListener.runBefore(actionListener, () -> this.onGoingRetryableActions.remove(key));
        TimeValue initialDelay = TimeValue.timeValueMillis((long)200L);
        RetryableAction retryableAction = new RetryableAction<T>(this.logger, this.threadPool, initialDelay, this.retryTimeout, removeListener){

            @Override
            public void tryAction(ActionListener<T> listener) {
                RetryableTransportClient.this.transportService.sendRequest(RetryableTransportClient.this.targetNode, action, request, options, new ActionListenerResponseHandler(listener, reader, "generic"));
            }

            @Override
            public boolean shouldRetry(Exception e) {
                return RetryableTransportClient.this.targetNode.getVersion().onOrAfter((Version)LegacyESVersion.V_7_9_0) && RetryableTransportClient.retryableException(e);
            }
        };
        this.onGoingRetryableActions.put(key, retryableAction);
        retryableAction.run();
        if (this.isCancelled) {
            retryableAction.cancel((Exception)((Object)new CancellableThreads.ExecutionCancelledException("retryable action was cancelled")));
        }
    }

    public void cancel() {
        this.isCancelled = true;
        if (this.onGoingRetryableActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("retryable action was cancelled");
        this.threadPool.generic().execute(() -> this.lambda$cancel$1((RuntimeException)((Object)exception)));
    }

    private static boolean retryableException(Exception e) {
        if (e instanceof ConnectTransportException) {
            return true;
        }
        if (e instanceof SendRequestTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            return cause instanceof ConnectTransportException;
        }
        if (e instanceof RemoteTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            return cause instanceof CircuitBreakingException || cause instanceof OpenSearchRejectedExecutionException;
        }
        return false;
    }

    private /* synthetic */ void lambda$cancel$1(RuntimeException exception) {
        for (RetryableAction<?> action : this.onGoingRetryableActions.values()) {
            action.cancel(exception);
        }
        this.onGoingRetryableActions.clear();
    }
}

