/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.collect.Tuple;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.script.DynamicMap;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptFactory;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;

public abstract class DerivedFieldScript {
    public static final String[] PARAMETERS = new String[0];
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("derived_field", Factory.class);
    private static final int MAX_BYTE_SIZE = 0x100000;
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> value, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    private List<Object> emittedValues;
    private int totalByteSize;

    public DerivedFieldScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new DynamicMap(parameters, PARAMS_FUNCTIONS);
        this.emittedValues = new ArrayList<Object>();
        this.totalByteSize = 0;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public List<Object> getEmittedValues() {
        return this.emittedValues;
    }

    public void setDocument(int docid) {
        this.emittedValues = new ArrayList<Object>();
        this.totalByteSize = 0;
        this.leafLookup.setDocument(docid);
    }

    public void addEmittedValue(Object o) {
        int byteSize = this.getObjectByteSize(o);
        int newTotalByteSize = this.totalByteSize + byteSize;
        if (newTotalByteSize > 0x100000) {
            throw new IllegalStateException("Exceeded maximum allowed byte size for emitted values");
        }
        this.emittedValues.add(o);
        this.totalByteSize = newTotalByteSize;
    }

    private int getObjectByteSize(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).getBytes(StandardCharsets.UTF_8).length;
        }
        if (obj instanceof Integer) {
            return 4;
        }
        if (obj instanceof Long) {
            return 8;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Tuple) {
            return 16;
        }
        if (obj == null) {
            return 0;
        }
        throw new IllegalArgumentException("Unsupported object type passed in emit() - " + String.valueOf(obj));
    }

    public void execute() {
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public DerivedFieldScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

