/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.Instant;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.wlm.MutableQueryGroupFragment;
import org.opensearch.wlm.ResourceType;

@PublicApi(since="2.18.0")
public class QueryGroup
extends AbstractDiffable<QueryGroup>
implements ToXContentObject {
    public static final String _ID_STRING = "_id";
    public static final String NAME_STRING = "name";
    public static final String UPDATED_AT_STRING = "updated_at";
    private static final int MAX_CHARS_ALLOWED_IN_NAME = 50;
    private final String name;
    private final String _id;
    private final long updatedAtInMillis;
    private final MutableQueryGroupFragment mutableQueryGroupFragment;

    public QueryGroup(String name, MutableQueryGroupFragment mutableQueryGroupFragment) {
        this(name, UUIDs.randomBase64UUID(), mutableQueryGroupFragment, Instant.now().getMillis());
    }

    public QueryGroup(String name, String _id, MutableQueryGroupFragment mutableQueryGroupFragment, long updatedAt) {
        Objects.requireNonNull(name, "QueryGroup.name can't be null");
        Objects.requireNonNull(mutableQueryGroupFragment.getResourceLimits(), "QueryGroup.resourceLimits can't be null");
        Objects.requireNonNull(mutableQueryGroupFragment.getResiliencyMode(), "QueryGroup.resiliencyMode can't be null");
        Objects.requireNonNull(_id, "QueryGroup._id can't be null");
        QueryGroup.validateName(name);
        if (mutableQueryGroupFragment.getResourceLimits().isEmpty()) {
            throw new IllegalArgumentException("QueryGroup.resourceLimits should at least have 1 resource limit");
        }
        if (!QueryGroup.isValid(updatedAt)) {
            throw new IllegalArgumentException("QueryGroup.updatedAtInMillis is not a valid epoch");
        }
        this.name = name;
        this._id = _id;
        this.mutableQueryGroupFragment = mutableQueryGroupFragment;
        this.updatedAtInMillis = updatedAt;
    }

    public static boolean isValid(long updatedAt) {
        long minValidTimestamp = Instant.ofEpochMilli((long)0L).getMillis();
        long currentSeconds = Instant.now().getMillis();
        return minValidTimestamp <= updatedAt && updatedAt <= currentSeconds;
    }

    public QueryGroup(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), new MutableQueryGroupFragment(in), in.readLong());
    }

    public static QueryGroup updateExistingQueryGroup(QueryGroup existingGroup, MutableQueryGroupFragment mutableQueryGroupFragment) {
        HashMap<ResourceType, Double> updatedResourceLimits = new HashMap<ResourceType, Double>(existingGroup.getResourceLimits());
        Map<ResourceType, Double> mutableFragmentResourceLimits = mutableQueryGroupFragment.getResourceLimits();
        if (mutableFragmentResourceLimits != null && !mutableFragmentResourceLimits.isEmpty()) {
            updatedResourceLimits.putAll(mutableFragmentResourceLimits);
        }
        MutableQueryGroupFragment.ResiliencyMode mode = Optional.ofNullable(mutableQueryGroupFragment.getResiliencyMode()).orElse(existingGroup.getResiliencyMode());
        return new QueryGroup(existingGroup.getName(), existingGroup.get_id(), new MutableQueryGroupFragment(mode, updatedResourceLimits), Instant.now().getMillis());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this._id);
        this.mutableQueryGroupFragment.writeTo(out);
        out.writeLong(this.updatedAtInMillis);
    }

    public static void validateName(String name) {
        if (name == null || name.isEmpty() || name.length() > 50) {
            throw new IllegalArgumentException("QueryGroup.name shouldn't be null, empty or more than 50 chars long");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_ID_STRING, this._id);
        builder.field(NAME_STRING, this.name);
        for (String fieldName : MutableQueryGroupFragment.acceptedFieldNames) {
            this.mutableQueryGroupFragment.writeField(builder, fieldName);
        }
        builder.field(UPDATED_AT_STRING, this.updatedAtInMillis);
        builder.endObject();
        return builder;
    }

    public static QueryGroup fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser).build();
    }

    public static Diff<QueryGroup> readDiff(StreamInput in) throws IOException {
        return QueryGroup.readDiffFrom(QueryGroup::new, in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryGroup that = (QueryGroup)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.mutableQueryGroupFragment, that.mutableQueryGroupFragment) && Objects.equals(this._id, that._id) && this.updatedAtInMillis == that.updatedAtInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mutableQueryGroupFragment, this.updatedAtInMillis, this._id);
    }

    public String getName() {
        return this.name;
    }

    public MutableQueryGroupFragment getMutableQueryGroupFragment() {
        return this.mutableQueryGroupFragment;
    }

    public MutableQueryGroupFragment.ResiliencyMode getResiliencyMode() {
        return this.getMutableQueryGroupFragment().getResiliencyMode();
    }

    public Map<ResourceType, Double> getResourceLimits() {
        return this.getMutableQueryGroupFragment().getResourceLimits();
    }

    public String get_id() {
        return this._id;
    }

    public long getUpdatedAtInMillis() {
        return this.updatedAtInMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    @ExperimentalApi
    public static class Builder {
        private String name;
        private String _id;
        private MutableQueryGroupFragment mutableQueryGroupFragment;
        private long updatedAt;

        private Builder() {
        }

        public static Builder fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            Builder builder = QueryGroup.builder();
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected START_OBJECT token but found [" + parser.currentName() + "]");
            }
            String fieldName = "";
            MutableQueryGroupFragment mutableQueryGroupFragment1 = new MutableQueryGroupFragment();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (fieldName.equals(QueryGroup._ID_STRING)) {
                        builder._id(parser.text());
                        continue;
                    }
                    if (fieldName.equals(QueryGroup.NAME_STRING)) {
                        builder.name(parser.text());
                        continue;
                    }
                    if (MutableQueryGroupFragment.shouldParse(fieldName)) {
                        mutableQueryGroupFragment1.parseField(parser, fieldName);
                        continue;
                    }
                    if (fieldName.equals(QueryGroup.UPDATED_AT_STRING)) {
                        builder.updatedAt(parser.longValue());
                        continue;
                    }
                    throw new IllegalArgumentException(fieldName + " is not a valid field in QueryGroup");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (!MutableQueryGroupFragment.shouldParse(fieldName)) {
                    throw new IllegalArgumentException(fieldName + " is not a valid object in QueryGroup");
                }
                mutableQueryGroupFragment1.parseField(parser, fieldName);
            }
            return builder.mutableQueryGroupFragment(mutableQueryGroupFragment1);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder _id(String _id) {
            this._id = _id;
            return this;
        }

        public Builder mutableQueryGroupFragment(MutableQueryGroupFragment mutableQueryGroupFragment) {
            this.mutableQueryGroupFragment = mutableQueryGroupFragment;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public QueryGroup build() {
            return new QueryGroup(this.name, this._id, this.mutableQueryGroupFragment, this.updatedAt);
        }

        public MutableQueryGroupFragment getMutableQueryGroupFragment() {
            return this.mutableQueryGroupFragment;
        }
    }
}

