/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.transport.GetWorkflowStateAction;
import org.opensearch.flowframework.transport.GetWorkflowStateRequest;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.flowframework.util.WorkflowTimeoutUtility;
import org.opensearch.flowframework.workflow.ProcessNode;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowProcessSorter;
import org.opensearch.plugins.PluginsService;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ProvisionWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, WorkflowResponse> {
    private final Logger logger = LogManager.getLogger(ProvisionWorkflowTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final WorkflowProcessSorter workflowProcessSorter;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private final EncryptorUtils encryptorUtils;
    private final PluginsService pluginsService;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public ProvisionWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, WorkflowProcessSorter workflowProcessSorter, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, EncryptorUtils encryptorUtils, PluginsService pluginsService, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings) {
        super("cluster:admin/opensearch/flow_framework/workflow/provision", transportService, actionFilters, WorkflowRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.workflowProcessSorter = workflowProcessSorter;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.encryptorUtils = encryptorUtils;
        this.pluginsService = pluginsService;
        this.filterByEnabled = (Boolean)FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<WorkflowResponse> listener) {
        String tenantId;
        String string = tenantId = request.getTemplate() == null ? null : request.getTemplate().getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.flowFrameworkSettings.isMultiTenancyEnabled(), tenantId, listener)) {
            return;
        }
        String workflowId = request.getWorkflowId();
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, workflowId, tenantId, this.filterByEnabled, false, this.flowFrameworkSettings.isMultiTenancyEnabled(), listener, () -> this.executeProvisionRequest(request, tenantId, listener, context), this.client, this.sdkClient, this.clusterService, this.xContentRegistry);
        }
        catch (Exception e) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template from global context for workflow {}", (Object)workflowId).getFormattedMessage();
            this.logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }

    private void executeProvisionRequest(WorkflowRequest request, String tenantId, ActionListener<WorkflowResponse> listener, ThreadContext.StoredContext context) {
        String workflowId = request.getWorkflowId();
        this.logger.info("Querying workflow from global context: {}", (Object)workflowId);
        this.flowFrameworkIndicesHandler.getTemplate(workflowId, tenantId, (ActionListener<GetResponse>)ActionListener.wrap(response -> {
            context.restore();
            if (!response.isExists()) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
                this.logger.error(errorMessage);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
                return;
            }
            Template parsedTemplate = Template.parse(response.getSourceAsString());
            Template template = this.encryptorUtils.decryptTemplateCredentials(parsedTemplate);
            Workflow provisionWorkflow = template.workflows().get("provision");
            List<ProcessNode> provisionProcessSequence = this.workflowProcessSorter.sortProcessNodes(provisionWorkflow, workflowId, request.getParams(), tenantId);
            this.workflowProcessSorter.validate(provisionProcessSequence, this.pluginsService);
            this.flowFrameworkIndicesHandler.getProvisioningProgress(workflowId, tenantId, progress -> {
                if (ProvisioningProgress.NOT_STARTED.equals(progress.orElse(null))) {
                    this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, tenantId, Map.ofEntries(Map.entry("state", State.PROVISIONING), Map.entry("provisioning_progress", ProvisioningProgress.IN_PROGRESS), Map.entry("provision_start_time", Instant.now().toEpochMilli()), Map.entry("resources_created", Collections.emptyList())), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                        this.logger.info("updated workflow {} state to {}", (Object)request.getWorkflowId(), (Object)State.PROVISIONING);
                        if (request.getWaitForCompletionTimeout() == TimeValue.MINUS_ONE) {
                            this.executeWorkflowAsync(workflowId, tenantId, provisionProcessSequence, listener);
                        } else {
                            this.executeWorkflowSync(workflowId, tenantId, provisionProcessSequence, listener, request.getWaitForCompletionTimeout().getMillis());
                        }
                        Template newTemplate = Template.builder(template).lastProvisionedTime(Instant.now()).build();
                        this.flowFrameworkIndicesHandler.updateTemplateInGlobalContext(request.getWorkflowId(), newTemplate, (ActionListener<IndexResponse>)ActionListener.wrap(templateResponse -> {
                            if (request.getWaitForCompletionTimeout() == TimeValue.MINUS_ONE) {
                                listener.onResponse((Object)new WorkflowResponse(request.getWorkflowId()));
                            } else {
                                this.logger.info("Waiting for workflow completion");
                            }
                        }, exception -> {
                            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update use case template {}", (Object)request.getWorkflowId()).getFormattedMessage();
                            this.logger.error(errorMessage, (Throwable)exception);
                            if (exception instanceof FlowFrameworkException) {
                                listener.onFailure(exception);
                            } else {
                                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                            }
                        }), true);
                    }, exception -> {
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update workflow state: {}", (Object)workflowId).getFormattedMessage();
                        this.logger.error(errorMessage, (Throwable)exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }));
                } else {
                    String errorMessage = "The workflow provisioning state is " + (progress.isPresent() ? ((ProvisioningProgress)((Object)((Object)((Object)progress.get())))).toString() : "unknown") + " and can not be provisioned unless its state is NOT_STARTED: " + workflowId + ". Deprovision the workflow to reset the state.";
                    this.logger.info(errorMessage);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
                }
            }, listener);
        }, exception -> {
            if (exception instanceof FlowFrameworkException) {
                this.logger.error("Workflow validation failed for workflow {}", (Object)workflowId);
                listener.onFailure(exception);
            } else {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template from global context for workflow {}", (Object)workflowId).getFormattedMessage();
                this.logger.error(errorMessage, (Throwable)exception);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
            }
        }), context);
    }

    private void executeWorkflowAsync(String workflowId, String tenantId, List<ProcessNode> workflowSequence, ActionListener<WorkflowResponse> listener) {
        try {
            this.client.threadPool().executor("opensearch_provision_workflow").execute(() -> this.executeWorkflow(workflowSequence, workflowId, tenantId, listener, false));
        }
        catch (Exception exception) {
            listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to execute workflow " + workflowId, ExceptionsHelper.status((Throwable)exception))));
        }
    }

    private void executeWorkflowSync(final String workflowId, String tenantId, List<ProcessNode> workflowSequence, final ActionListener<WorkflowResponse> listener, long timeout) {
        final AtomicBoolean isResponseSent = new AtomicBoolean(false);
        CompletableFuture.runAsync(() -> {
            try {
                this.executeWorkflow(workflowSequence, workflowId, tenantId, new ActionListener<WorkflowResponse>(){

                    public void onResponse(WorkflowResponse workflowResponse) {
                        WorkflowTimeoutUtility.handleResponse(workflowId, workflowResponse, isResponseSent, (ActionListener<WorkflowResponse>)listener);
                    }

                    public void onFailure(Exception e) {
                        WorkflowTimeoutUtility.handleFailure(workflowId, e, isResponseSent, (ActionListener<WorkflowResponse>)listener);
                    }
                }, true);
            }
            catch (Exception ex) {
                WorkflowTimeoutUtility.handleFailure(workflowId, ex, isResponseSent, listener);
            }
        }, this.client.threadPool().executor("opensearch_provision_workflow"));
        WorkflowTimeoutUtility.scheduleTimeoutHandler(this.client, this.client.threadPool(), workflowId, tenantId, listener, timeout, isResponseSent);
    }

    private void executeWorkflow(List<ProcessNode> workflowSequence, String workflowId, String tenantId, ActionListener<WorkflowResponse> listener, boolean isSyncExecution) {
        String currentStepId = "";
        try {
            LinkedHashMap<String, PlainActionFuture<WorkflowData>> workflowFutureMap = new LinkedHashMap<String, PlainActionFuture<WorkflowData>>();
            for (ProcessNode processNode : workflowSequence) {
                List<ProcessNode> predecessors = processNode.predecessors();
                this.logger.info("Queueing process [{}].{}", (Object)processNode.id(), (Object)(predecessors.isEmpty() ? " Can start immediately!" : String.format(Locale.getDefault(), " Must wait for [%s] to complete first.", predecessors.stream().map(p -> p.id()).collect(Collectors.joining(", ")))));
                workflowFutureMap.put(processNode.id(), processNode.execute());
            }
            for (Map.Entry entry : workflowFutureMap.entrySet()) {
                currentStepId = (String)entry.getKey();
                ((PlainActionFuture)entry.getValue()).actionGet();
            }
            this.logger.info("Provisioning completed successfully for workflow {}", (Object)workflowId);
            this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, tenantId, Map.ofEntries(Map.entry("state", State.COMPLETED), Map.entry("provisioning_progress", ProvisioningProgress.DONE), Map.entry("provision_end_time", Instant.now().toEpochMilli())), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                this.logger.info("updated workflow {} state to {}", (Object)workflowId, (Object)State.COMPLETED);
                if (isSyncExecution) {
                    this.client.execute((ActionType)GetWorkflowStateAction.INSTANCE, (ActionRequest)new GetWorkflowStateRequest(workflowId, false, tenantId), ActionListener.wrap(response -> listener.onResponse((Object)new WorkflowResponse(workflowId, response.getWorkflowState())), exception -> {
                        String errorMessage = "Failed to get workflow state.";
                        this.logger.error(errorMessage, (Throwable)exception);
                        if (exception instanceof FlowFrameworkException) {
                            listener.onFailure(exception);
                        } else {
                            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                        }
                    }));
                }
            }, exception -> this.logger.error("Failed to update workflow state for workflow {}", (Object)workflowId, exception)));
        }
        catch (Exception ex) {
            RestStatus status = ex instanceof FlowFrameworkException ? ((FlowFrameworkException)((Object)ex)).getRestStatus() : ExceptionsHelper.status((Throwable)ex);
            this.logger.error("Provisioning failed for workflow {} during step {}.", (Object)workflowId, (Object)currentStepId, (Object)ex);
            String string = (ex.getCause() == null ? ex.getMessage() : ex.getCause().getClass().getName()) + " during step " + currentStepId + ", restStatus: " + status.toString();
            this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, tenantId, Map.ofEntries(Map.entry("state", State.FAILED), Map.entry("error", string), Map.entry("provisioning_progress", ProvisioningProgress.FAILED), Map.entry("provision_end_time", Instant.now().toEpochMilli())), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> this.logger.info("updated workflow {} state to {}", (Object)workflowId, (Object)State.FAILED), exceptionState -> this.logger.error("Failed to update workflow state for workflow {}", (Object)workflowId, exceptionState)));
        }
    }
}

