/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.common;

import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;

public class TIFLockService {
    private static final Logger log = LogManager.getLogger(TIFLockService.class);
    public static final long LOCK_DURATION_IN_SECONDS = 300L;
    public static final long RENEW_AFTER_IN_SECONDS = 120L;
    private final ClusterService clusterService;
    private final LockService lockService;

    public TIFLockService(ClusterService clusterService, Client client) {
        this.clusterService = clusterService;
        this.lockService = new LockService(client, clusterService);
    }

    public void acquireLock(final String tifJobName, Long lockDurationSeconds, final ActionListener<LockModel> listener) {
        final AtomicReference lockReference = new AtomicReference();
        this.lockService.acquireLockWithId(".opensearch-sap--job", lockDurationSeconds, tifJobName, (ActionListener)new ActionListener<LockModel>(){

            public void onResponse(LockModel lockModel) {
                lockReference.set(lockModel);
                listener.onResponse((Object)((LockModel)lockReference.get()));
            }

            public void onFailure(Exception e) {
                log.error("Failed to acquire lock for tif job " + tifJobName, (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public void releaseLock(LockModel lockModel, ActionListener<Boolean> listener) {
        this.lockService.release(lockModel, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), exception -> {
            log.error("Failed to release the lock", (Throwable)exception);
            listener.onFailure(exception);
        }));
    }

    public LockModel renewLock(LockModel lockModel) {
        final AtomicReference lockReference = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.lockService.renewLock(lockModel, (ActionListener)new ActionListener<LockModel>(){

            public void onResponse(LockModel lockModel) {
                lockReference.set(lockModel);
                countDownLatch.countDown();
            }

            public void onFailure(Exception e) {
                log.error("failed to renew lock", (Throwable)e);
                lockReference.set(null);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(((TimeValue)this.clusterService.getClusterSettings().get(SecurityAnalyticsSettings.THREAT_INTEL_TIMEOUT)).getSeconds(), TimeUnit.SECONDS);
            return (LockModel)lockReference.get();
        }
        catch (InterruptedException e) {
            log.error("Interrupted exception", (Throwable)e);
            return null;
        }
    }

    public Runnable getRenewLockRunnable(AtomicReference<LockModel> lockModel) {
        return () -> {
            LockModel preLock = (LockModel)lockModel.get();
            if (Instant.now().isBefore(preLock.getLockTime().plusSeconds(120L))) {
                return;
            }
            lockModel.set(this.renewLock((LockModel)lockModel.get()));
            if (lockModel.get() == null) {
                log.error("Exception: failed to renew a lock");
                new OpenSearchException("failed to renew a lock [{}]", new Object[]{preLock});
            }
        };
    }
}

