/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;

public class ZstdFactory {
    private ZstdFactory() {
    }

    public static OutputStream wrapForOutput(ByteBufferOutputStream buffer) {
        try {
            return new BufferedOutputStream((OutputStream)new ZstdOutputStreamNoFinalizer((OutputStream)buffer, RecyclingBufferPool.INSTANCE), 16384);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    public static InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, final BufferSupplier decompressionBufferSupplier) {
        try {
            BufferPool bufferPool = new BufferPool(){

                public ByteBuffer get(int capacity) {
                    return decompressionBufferSupplier.get(capacity);
                }

                public void release(ByteBuffer buffer) {
                    decompressionBufferSupplier.release(buffer);
                }
            };
            return new ZstdInputStreamNoFinalizer((InputStream)new ByteBufferInputStream(buffer), bufferPool);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }
}

