/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.columnar.extractors.SimpleFieldExtractor;

public class DateExtractor
extends SimpleFieldExtractor<LocalDate> {
    private static final Logger logger = Logger.getLogger(DateExtractor.class.getName());
    @Config(mandatory=true, description="The expected date format.")
    private String dateFormat;
    private DateTimeFormatter formatter;
    @Config(mandatory=false, description="Sets the locale language.")
    private String localeLanguage = null;
    @Config(mandatory=false, description="Sets the locale country.")
    private String localeCountry = null;

    private DateExtractor() {
    }

    public DateExtractor(String fieldName, String metadataName, String dateFormat) {
        this(fieldName, metadataName, dateFormat, null, null);
    }

    public DateExtractor(String fieldName, String metadataName, String dateFormat, String localeLanguage, String localeCountry) {
        super(fieldName, metadataName);
        this.dateFormat = dateFormat;
        this.localeCountry = localeCountry;
        this.localeLanguage = localeLanguage;
        this.postConfig();
    }

    @Deprecated
    public DateExtractor(String fieldName, String metadataName, DateTimeFormatter formatter) {
        super(fieldName, metadataName);
        this.formatter = formatter;
        this.dateFormat = formatter.toString();
    }

    @Override
    public void postConfig() {
        Locale locale;
        super.postConfig();
        if (this.localeLanguage == null && this.localeCountry == null) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        } else {
            if (this.localeLanguage == null) {
                throw new PropertyException("", "localeLanguage", "Must supply both localeLanguage and localeCountry when setting the locale.");
            }
            if (this.localeCountry == null) {
                throw new PropertyException("", "localeCountry", "Must supply both localeLanguage and localeCountry when setting the locale.");
            }
            locale = new Locale(this.localeLanguage, this.localeCountry);
        }
        if (this.dateFormat != null) {
            try {
                this.formatter = DateTimeFormatter.ofPattern(this.dateFormat, locale);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyException((Throwable)e, "", "dateFormat", "dateFormat could not be parsed by DateTimeFormatter");
            }
        } else {
            this.formatter = DateTimeFormatter.BASIC_ISO_DATE;
        }
    }

    @Override
    public Class<LocalDate> getValueType() {
        return LocalDate.class;
    }

    @Override
    protected Optional<LocalDate> extractField(String s) {
        try {
            return Optional.of(LocalDate.parse(s, this.formatter));
        }
        catch (DateTimeParseException e) {
            logger.log(Level.WARNING, e.getParsedString());
            logger.log(Level.WARNING, String.format("Unable to parse date %s with formatter %s", s, this.formatter.toString()));
            return Optional.empty();
        }
    }

    @Override
    public String toString() {
        return "DateExtractor(fieldName='" + this.fieldName + '\'' + ", metadataName='" + this.metadataName + '\'' + ", dateFormat=" + this.formatter + ", localeLanguage='" + this.localeLanguage + '\'' + ", localeCountry='" + this.localeCountry + '\'' + ')';
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "DateExtractor");
    }
}

