/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.CorrelatedFindingRequest;
import org.opensearch.securityanalytics.action.CorrelatedFindingResponse;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.correlation.index.query.CorrelationQueryBuilder;
import org.opensearch.securityanalytics.model.FindingWithScore;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSearchCorrelationAction
extends HandledTransportAction<CorrelatedFindingRequest, CorrelatedFindingResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportSearchCorrelationAction.class);
    private final ClusterService clusterService;
    private final Settings settings;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;

    @Inject
    public TransportSearchCorrelationAction(TransportService transportService, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, Settings settings, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/securityanalytics/correlations/findings", transportService, actionFilters, CorrelatedFindingRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.settings = settings;
        this.threadPool = this.client.threadPool();
    }

    protected void doExecute(Task task, CorrelatedFindingRequest request, ActionListener<CorrelatedFindingResponse> actionListener) {
        AsyncSearchCorrelationAction searchCorrelationAction = new AsyncSearchCorrelationAction(task, request, actionListener);
        searchCorrelationAction.start();
    }

    class AsyncSearchCorrelationAction {
        private CorrelatedFindingRequest request;
        private ActionListener<CorrelatedFindingResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncSearchCorrelationAction(Task task, CorrelatedFindingRequest request, ActionListener<CorrelatedFindingResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            final String findingId = this.request.getFindingId();
            String detectorType = this.request.getDetectorType();
            final long timeWindow = this.request.getTimeWindow();
            final int noOfNearbyFindings = this.request.getNoOfNearbyFindings();
            MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"_id", (Object)findingId);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.fetchField("timestamp");
            searchSourceBuilder.size(1);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(detectorType)});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            TransportSearchCorrelationAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    SearchHit hit = response.getHits().getAt(0);
                    final long findingTimestamp = (Long)((DocumentField)hit.getFields().get("timestamp")).getValue();
                    BoolQueryBuilder scoreQueryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"scoreTimestamp", (long)0L));
                    SearchSourceBuilder scoreSearchSourceBuilder = new SearchSourceBuilder();
                    scoreSearchSourceBuilder.query((QueryBuilder)scoreQueryBuilder);
                    scoreSearchSourceBuilder.fetchSource(true);
                    scoreSearchSourceBuilder.size(1);
                    SearchRequest scoreSearchRequest = new SearchRequest();
                    scoreSearchRequest.indices(new String[]{".opensearch-sap-correlation-metadata"});
                    scoreSearchRequest.source(scoreSearchSourceBuilder);
                    scoreSearchRequest.preference(Preference.PRIMARY_FIRST.type());
                    TransportSearchCorrelationAction.this.client.search(scoreSearchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                            final long scoreTimestamp = (Long)hitSource.get("scoreTimestamp");
                            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)findingId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)""));
                            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                            searchSourceBuilder.query((QueryBuilder)queryBuilder);
                            searchSourceBuilder.fetchSource(false);
                            searchSourceBuilder.fetchField("counter");
                            searchSourceBuilder.size(1);
                            SearchRequest searchRequest = new SearchRequest();
                            searchRequest.indices(new String[]{".opensearch-sap-correlation-history*"});
                            searchRequest.source(searchSourceBuilder);
                            searchRequest.preference(Preference.PRIMARY_FIRST.type());
                            TransportSearchCorrelationAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                                public void onResponse(SearchResponse response) {
                                    SearchHit[] hits;
                                    MultiSearchRequest mSearchRequest = new MultiSearchRequest();
                                    for (SearchHit hit : hits = response.getHits().getHits()) {
                                        long counter = (Long)((DocumentField)hit.getFields().get("counter")).getValue();
                                        float[] query = new float[3];
                                        for (int i = 0; i < 2; ++i) {
                                            query[i] = (2.0f * (float)counter - 50.0f) / 2.0f;
                                        }
                                        query[2] = Long.valueOf((findingTimestamp - scoreTimestamp) / 1000L).floatValue();
                                        CorrelationQueryBuilder correlationQueryBuilder = new CorrelationQueryBuilder("corr_vector", query, noOfNearbyFindings, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)"")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)"")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - timeWindow)).lte((Object)(findingTimestamp + timeWindow))));
                                        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                                        searchSourceBuilder.query((QueryBuilder)correlationQueryBuilder);
                                        searchSourceBuilder.fetchSource(true);
                                        searchSourceBuilder.size(noOfNearbyFindings);
                                        SearchRequest searchRequest = new SearchRequest();
                                        searchRequest.indices(new String[]{".opensearch-sap-correlation-history*"});
                                        searchRequest.source(searchSourceBuilder);
                                        searchRequest.preference(Preference.PRIMARY_FIRST.type());
                                        mSearchRequest.add(searchRequest);
                                    }
                                    TransportSearchCorrelationAction.this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                                        public void onResponse(MultiSearchResponse items) {
                                            MultiSearchResponse.Item[] responses = items.getResponses();
                                            HashMap<Pair, Pair> correlatedFindings = new HashMap<Pair, Pair>();
                                            for (MultiSearchResponse.Item response : responses) {
                                                SearchHit[] hits;
                                                if (response.isFailure()) {
                                                    log.info(response.getFailureMessage());
                                                    continue;
                                                }
                                                for (SearchHit hit : hits = response.getResponse().getHits().getHits()) {
                                                    Set rules;
                                                    double score;
                                                    Map source = hit.getSourceAsMap();
                                                    if (!source.get("finding1").toString().equals(findingId)) {
                                                        Pair findingKey1 = Pair.of((Object)source.get("finding1").toString(), (Object)source.get("logType").toString().split("-")[0]);
                                                        if (correlatedFindings.containsKey(findingKey1)) {
                                                            score = Math.max((Double)((Pair)correlatedFindings.get(findingKey1)).getLeft(), (double)hit.getScore());
                                                            rules = (Set)((Pair)correlatedFindings.get(findingKey1)).getRight();
                                                            rules.addAll((List)source.get("corrRules"));
                                                            correlatedFindings.put(findingKey1, Pair.of((Object)score, (Object)rules));
                                                        } else {
                                                            HashSet rules2 = new HashSet((List)source.get("corrRules"));
                                                            correlatedFindings.put(findingKey1, Pair.of((Object)hit.getScore(), rules2));
                                                        }
                                                    }
                                                    if (source.get("finding2").toString().equals(findingId)) continue;
                                                    Pair findingKey2 = Pair.of((Object)source.get("finding2").toString(), (Object)source.get("logType").toString().split("-")[1]);
                                                    if (correlatedFindings.containsKey(findingKey2)) {
                                                        score = Math.max((Double)((Pair)correlatedFindings.get(findingKey2)).getLeft(), (double)hit.getScore());
                                                        rules = (Set)((Pair)correlatedFindings.get(findingKey2)).getRight();
                                                        rules.addAll((List)source.get("corrRules"));
                                                        correlatedFindings.put(findingKey2, Pair.of((Object)score, (Object)rules));
                                                        continue;
                                                    }
                                                    HashSet rules3 = new HashSet((List)source.get("corrRules"));
                                                    correlatedFindings.put(findingKey2, Pair.of((Object)hit.getScore(), rules3));
                                                }
                                            }
                                            ArrayList<FindingWithScore> findingWithScores = new ArrayList<FindingWithScore>();
                                            for (Map.Entry correlatedFinding : correlatedFindings.entrySet()) {
                                                findingWithScores.add(new FindingWithScore((String)((Pair)correlatedFinding.getKey()).getKey(), (String)((Pair)correlatedFinding.getKey()).getValue(), (Double)((Pair)correlatedFinding.getValue()).getLeft(), new ArrayList<String>((Collection)((Pair)correlatedFinding.getValue()).getRight())));
                                            }
                                            AsyncSearchCorrelationAction.this.onOperation(new CorrelatedFindingResponse(findingWithScores));
                                        }

                                        public void onFailure(Exception e) {
                                            AsyncSearchCorrelationAction.this.onFailures(e);
                                        }
                                    });
                                }

                                public void onFailure(Exception e) {
                                    AsyncSearchCorrelationAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            AsyncSearchCorrelationAction.this.onFailures(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    AsyncSearchCorrelationAction.this.onFailures(e);
                }
            });
        }

        private void onOperation(CorrelatedFindingResponse response) {
            this.response.set((Object)response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(CorrelatedFindingResponse response, Exception t) {
            TransportSearchCorrelationAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return response;
            }));
        }
    }
}

