/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ClearCachesAction
extends ActionType<ClearCachesNodesResponse> {
    public static final String NAME = "cluster:admin/ltr/caches";
    public static final ClearCachesAction INSTANCE = new ClearCachesAction();

    private ClearCachesAction() {
        super(NAME, ClearCachesNodesResponse::new);
    }

    public Writeable.Reader<ClearCachesNodesResponse> getResponseReader() {
        return ClearCachesNodesResponse::new;
    }

    public static class ClearCachesNodeResponse
    extends BaseNodeResponse {
        public ClearCachesNodeResponse(StreamInput in) throws IOException {
            super(in);
        }

        public ClearCachesNodeResponse(DiscoveryNode node) {
            super(node);
        }
    }

    public static class ClearCachesNodesResponse
    extends BaseNodesResponse<ClearCachesNodeResponse> {
        public ClearCachesNodesResponse(StreamInput in) throws IOException {
            super(in);
        }

        public ClearCachesNodesResponse(ClusterName clusterName, List<ClearCachesNodeResponse> responses, List<FailedNodeException> failures) {
            super(clusterName, responses, failures);
        }

        protected List<ClearCachesNodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(ClearCachesNodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<ClearCachesNodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class ClearCachesNodesRequest
    extends BaseNodesRequest<ClearCachesNodesRequest> {
        private String store;
        private Operation operation;
        private String name;

        public ClearCachesNodesRequest(StreamInput in) throws IOException {
            super(in);
            this.store = in.readString();
            this.operation = Operation.values()[in.readVInt()];
            this.name = in.readOptionalString();
        }

        public ClearCachesNodesRequest() {
            super((String[])null);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = null;
            if (this.store == null) {
                arve = ValidateActions.addValidationError((String)"store cannot be null", null);
            }
            if (this.operation == null) {
                arve = ValidateActions.addValidationError((String)"no operation provided", (ActionRequestValidationException)arve);
            }
            if (this.operation != null && this.operation != Operation.ClearStore && this.name == null) {
                arve = ValidateActions.addValidationError((String)"name must be provided if clearing a specific element", (ActionRequestValidationException)arve);
            }
            return arve;
        }

        public void clearStore(String storeName) {
            this.operation = Operation.ClearStore;
            this.store = Objects.requireNonNull(storeName);
        }

        public void clearFeature(String storeName, String name) {
            this.clearElement(storeName, name, Operation.ClearFeature);
        }

        public void clearFeatureSet(String storeName, String name) {
            this.clearElement(storeName, name, Operation.ClearFeatureSet);
        }

        public void clearModel(String storeName, String name) {
            this.clearElement(storeName, name, Operation.ClearModel);
        }

        private void clearElement(String storeName, String name, Operation op) {
            this.operation = op;
            this.store = Objects.requireNonNull(storeName);
            this.name = Objects.requireNonNull(name);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.store);
            out.writeVInt(this.operation.ordinal());
            out.writeOptionalString(this.name);
        }

        public String getStore() {
            return this.store;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getName() {
            return this.name;
        }

        public static enum Operation {
            ClearStore,
            ClearFeature,
            ClearFeatureSet,
            ClearModel;

        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<ClearCachesNodesRequest, ClearCachesNodesResponse> {
        public RequestBuilder(OpenSearchClient client) throws IOException {
            super(client, (ActionType)INSTANCE, (ActionRequest)new ClearCachesNodesRequest());
        }
    }
}

