/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Pair<T1, T2>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Pair.class.getName());
    private final T1 a;
    private final T2 b;

    public Pair(T1 a, T2 b) {
        this.a = a;
        this.b = b;
    }

    public T1 getA() {
        return this.a;
    }

    public T2 getB() {
        return this.b;
    }

    public static <T1, T2> ArrayList<Pair<T1, T2>> zipArrays(ArrayList<T1> first, ArrayList<T2> second) {
        if (first.size() == second.size()) {
            ArrayList<Pair<T1, T2>> output = new ArrayList<Pair<T1, T2>>(first.size());
            for (int i = 0; i < first.size(); ++i) {
                Pair<T1, T2> pair = new Pair<T1, T2>(first.get(i), second.get(i));
                output.add(i, pair);
            }
            return output;
        }
        throw new IllegalArgumentException("Zipping requires arrays of the same length. first.size() = " + first.size() + ", second.size() = " + second.size());
    }

    private static int mix32(long z) {
        return (int)(((z *= 7109453100751455733L) ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public int hashCode() {
        int aCode = this.a instanceof Integer ? Pair.mix32(((Integer)this.a).intValue()) : (this.a instanceof Long ? Pair.mix32((Long)this.a) : this.a.hashCode());
        int bCode = this.b instanceof Integer ? Pair.mix32(((Integer)this.b).intValue()) : (this.b instanceof Long ? Pair.mix32((Long)this.b) : this.b.hashCode());
        return aCode ^ bCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (!(this.a == other.a || this.a != null && this.a.equals(other.a))) {
            return false;
        }
        return this.b == other.b || this.b != null && this.b.equals(other.b);
    }

    public String toString() {
        return "Pair{a=" + this.a + ", b=" + this.b + '}';
    }
}

